/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.io;

import icy.plugin.abstract_.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.workbooks.Workbooks;

public class FileToWorkbook
extends Plugin
implements IOBlock {
    VarFile inputFile = new VarFile("input file", null);
    VarWorkbook workbook = new VarWorkbook("workbook", (Workbook)null);

    public void run() {
        this.workbook.setValue(FileToWorkbook.readWorkbook((File)this.inputFile.getValue(true)));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input file", (Var)this.inputFile);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("workbook", (Var)this.workbook);
    }

    public static Workbook readWorkbook(File file) {
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("Cannot read a workbook from " + file.getPath());
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            Workbook workbook = WorkbookFactory.create((InputStream)fis);
            fis.close();
            return workbook;
        }
        catch (Exception e) {
            Workbook wb = Workbooks.createEmptyWorkbook();
            Sheet sheet = null;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                int rowID = 0;
                boolean newLine = false;
                while (reader.ready()) {
                    String[] words;
                    String line = reader.readLine();
                    if (line.isEmpty()) {
                        newLine = true;
                        continue;
                    }
                    if (line.startsWith("== ")) {
                        newLine = false;
                        String sheetName = line.substring(3, line.indexOf(" =="));
                        sheet = wb.createSheet(sheetName);
                        rowID = 0;
                        continue;
                    }
                    if (sheet == null) {
                        sheet = wb.createSheet();
                        rowID = 0;
                    }
                    if (newLine) {
                        sheet.createRow(rowID++);
                    }
                    Row row = sheet.createRow(rowID++);
                    if (line.isEmpty()) continue;
                    int colID = 0;
                    for (String word : words = line.split("\t")) {
                        if (!word.isEmpty()) {
                            Cell cell = row.createCell(colID);
                            try {
                                cell.setCellValue(Double.parseDouble(word));
                            }
                            catch (NumberFormatException formatError) {
                                cell.setCellValue(word);
                            }
                        }
                        ++colID;
                    }
                }
                reader.close();
                return wb;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

