/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.RangeSlider;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeComponent
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 7244476681262628392L;
    protected final JSpinner lowSpinner;
    protected final JSpinner highSpinner;
    protected final RangeSlider slider;

    public RangeComponent(int orientation, double min, double max, double step) {
        this.lowSpinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        this.lowSpinner.setToolTipText("Set low bound");
        this.highSpinner = new JSpinner(new SpinnerNumberModel(max, min, max, step));
        this.highSpinner.setToolTipText("Set high bound");
        this.slider = new RangeSlider(orientation);
        this.updateSliderModel();
        this.lowSpinner.addChangeListener(this);
        this.highSpinner.addChangeListener(this);
        this.slider.addChangeListener(this);
        this.slider.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        if (orientation == 1) {
            this.add((Component)this.lowSpinner, "South");
            this.add((Component)this.slider, "Center");
            this.add((Component)this.highSpinner, "North");
        } else {
            this.add((Component)this.lowSpinner, "West");
            this.add((Component)this.slider, "Center");
            this.add((Component)this.highSpinner, "East");
        }
        this.validate();
    }

    public RangeComponent(double min, double max, double step) {
        this(0, min, max, step);
    }

    public RangeComponent(int orientation) {
        this(orientation, 0.0, 100.0, 1.0);
    }

    public RangeComponent() {
        this(0, 0.0, 100.0, 1.0);
    }

    public JSpinner getLowSpinner() {
        return this.lowSpinner;
    }

    public JSpinner getHighSpinner() {
        return this.highSpinner;
    }

    public RangeSlider getSlider() {
        return this.slider;
    }

    public SpinnerNumberModel getLowModel() {
        return (SpinnerNumberModel)this.lowSpinner.getModel();
    }

    public SpinnerNumberModel getHighModel() {
        return (SpinnerNumberModel)this.highSpinner.getModel();
    }

    private double getRange() {
        return this.getMax() - this.getMin();
    }

    private int getSliderRange() {
        return this.slider.getMaximum() - this.slider.getMinimum();
    }

    private int spinnerToSlider(double value) {
        double spinnerRange = this.getRange();
        if (spinnerRange == 0.0) {
            return 0;
        }
        return (int)((value - this.getMin()) * (double)this.getSliderRange() / spinnerRange);
    }

    private double sliderToSpinner(int value) {
        int sliderRange = this.getSliderRange();
        if (sliderRange == 0) {
            return 0.0;
        }
        return (double)value * this.getRange() / (double)sliderRange + this.getMin();
    }

    private void updateSliderModel() {
        int sliderRange = (int)Math.round(this.getRange() / this.getStep());
        this.slider.setModel(new DefaultBoundedRangeModel(0, 0, 0, sliderRange));
        this.slider.setLowerValue(this.spinnerToSlider(this.getLow()));
        this.slider.setUpperValue(this.spinnerToSlider(this.getHigh()));
    }

    public void setLowHigh(double low, double high) {
        this.getLowModel().setValue(low);
        this.getHighModel().setValue(high);
    }

    public double getLow() {
        return this.getLowModel().getNumber().doubleValue();
    }

    public double getHigh() {
        return this.getHighModel().getNumber().doubleValue();
    }

    public void setLow(double value) {
        this.getLowModel().setValue(value);
    }

    public void setHigh(double value) {
        this.getHighModel().setValue(value);
    }

    public boolean isInteger() {
        SpinnerNumberModel model = this.getLowModel();
        Number value = model.getNumber();
        Number step = model.getStepSize();
        return value.doubleValue() == (double)value.longValue() && step.doubleValue() == (double)step.longValue();
    }

    public double getMin() {
        return (Double)this.getLowModel().getMinimum();
    }

    public double getMax() {
        return (Double)this.getHighModel().getMaximum();
    }

    public double getStep() {
        return this.getLowModel().getStepSize().doubleValue();
    }

    public void setMinMaxStep(double min, double max, double step) {
        double low = Math.max(Math.min(this.getLow(), max), min);
        double high = Math.max(Math.min(this.getHigh(), max), min);
        this.lowSpinner.setModel(new SpinnerNumberModel(low, min, max, step));
        this.highSpinner.setModel(new SpinnerNumberModel(high, min, max, step));
        this.updateSliderModel();
    }

    public void setMinMax(double min, double max) {
        this.setMinMaxStep(min, max, this.getStep());
    }

    public void setMin(double value) {
        this.setMinMaxStep(value, this.getMax(), this.getStep());
    }

    public void setMax(double value) {
        this.setMinMaxStep(this.getMin(), value, this.getStep());
    }

    public void setStep(double value) {
        this.setMinMaxStep(this.getMin(), this.getMax(), value);
    }

    public void setSliderVisible(boolean value) {
        if (value) {
            this.add((Component)this.slider, "Center");
        } else {
            this.add((Component)new JLabel(" - "), "Center");
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.slider.setToolTipText(text);
        super.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.lowSpinner.setEnabled(enabled);
        this.highSpinner.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected void fireChangedEvent(ChangeEvent event) {
        for (ChangeListener listener : (ChangeListener[])this.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        double low = this.getLow();
        double high = this.getHigh();
        if (source == this.lowSpinner) {
            this.slider.setLowerValue(this.spinnerToSlider(low));
            if (high < low) {
                this.setHigh(low);
            }
            this.getHighModel().setMinimum(Double.valueOf(low));
        } else if (source == this.highSpinner) {
            this.slider.setUpperValue(this.spinnerToSlider(high));
            if (low > high) {
                this.setLow(high);
            }
            this.getLowModel().setMaximum(Double.valueOf(high));
        } else if (source == this.slider) {
            this.setLow(this.sliderToSpinner(this.slider.getLowerValue()));
            this.setHigh(this.sliderToSpinner(this.slider.getUpperValue()));
        }
        this.fireChangedEvent(e);
    }
}

