/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence;

import icy.gui.component.IcyTextField;
import icy.gui.component.NumberTextField;
import icy.gui.util.ComponentUtil;
import icy.math.UnitUtil;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SequencePropertiesPanel
extends JPanel {
    private static final long serialVersionUID = -1568878218022361239L;
    private IcyTextField nameField;
    NumberTextField tfPxSizeX;
    NumberTextField tfPxSizeY;
    private NumberTextField tfPxSizeZ;
    private JComboBox cbPxSizeX;
    JComboBox cbPxSizeY;
    private JComboBox cbPxSizeZ;
    private NumberTextField tfTimeInterval;
    private JPanel panelChannels;
    private IcyTextField[] tfsChannels;
    private JLabel lblX;
    private JLabel lblY;
    private JLabel lblZ;
    JCheckBox checkLinked;
    private JComboBox cbTimeUnit;
    private JLabel lblValue;
    private JPanel panelPosition;
    private NumberTextField positionXField;
    private NumberTextField positionYField;
    private NumberTextField positionZField;
    private JComboBox posXUnitComboBox;
    private JComboBox posYUnitComboBox;
    private JComboBox posZUnitComboBox;
    private JPanel panelPixelSize;
    private JPanel panelTimeInterval;
    private final int unitStartIndex;

    public SequencePropertiesPanel() {
        UnitUtil.UnitPrefix[] upValues = UnitUtil.UnitPrefix.values();
        this.unitStartIndex = UnitUtil.UnitPrefix.KILO.ordinal();
        String[] cbModel = new String[upValues.length - this.unitStartIndex];
        for (int i = 0; i < upValues.length; ++i) {
            if (i < this.unitStartIndex) continue;
            cbModel[i - this.unitStartIndex] = upValues[i].toString() + "m";
        }
        this.initialize(cbModel);
    }

    private void initialize(String[] cbModel) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelMain = new JPanel();
        panelMain.setBorder(new EmptyBorder(4, 4, 0, 4));
        this.add((Component)panelMain, "North");
        panelMain.setLayout(new BoxLayout(panelMain, 1));
        JPanel panelName = new JPanel();
        panelName.setBorder(new TitledBorder(null, "Name", 4, 2, null, null));
        panelMain.add(panelName);
        panelName.setLayout(new BoxLayout(panelName, 2));
        this.nameField = new IcyTextField();
        this.nameField.setPreferredSize(new Dimension(200, 20));
        this.nameField.setMinimumSize(new Dimension(80, 20));
        panelName.add(this.nameField);
        this.panelPixelSize = new JPanel();
        this.panelPixelSize.setBorder(new TitledBorder(null, "Pixel Size", 4, 2, null, null));
        panelMain.add(this.panelPixelSize);
        GridBagLayout gbl_panelPixelSize = new GridBagLayout();
        gbl_panelPixelSize.columnWidths = new int[]{60, 80, 40, 60, 0};
        gbl_panelPixelSize.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelPixelSize.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panelPixelSize.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panelPixelSize.setLayout(gbl_panelPixelSize);
        this.lblX = new JLabel("X");
        GridBagConstraints gbc_lblX = new GridBagConstraints();
        gbc_lblX.anchor = 17;
        gbc_lblX.fill = 3;
        gbc_lblX.insets = new Insets(0, 0, 5, 5);
        gbc_lblX.gridx = 0;
        gbc_lblX.gridy = 0;
        this.panelPixelSize.add((Component)this.lblX, gbc_lblX);
        this.tfPxSizeX = new NumberTextField();
        this.tfPxSizeX.setColumns(4);
        GridBagConstraints gbc_tfPxSizeX = new GridBagConstraints();
        gbc_tfPxSizeX.fill = 1;
        gbc_tfPxSizeX.insets = new Insets(0, 0, 5, 5);
        gbc_tfPxSizeX.gridx = 1;
        gbc_tfPxSizeX.gridy = 0;
        this.panelPixelSize.add((Component)this.tfPxSizeX, gbc_tfPxSizeX);
        this.tfPxSizeX.addTextChangeListener(new IcyTextField.TextChangeListener(){

            @Override
            public void textChanged(IcyTextField source, boolean validate) {
                if (SequencePropertiesPanel.this.checkLinked.isSelected()) {
                    SequencePropertiesPanel.this.tfPxSizeY.setText(SequencePropertiesPanel.this.tfPxSizeX.getText());
                }
            }
        });
        this.tfPxSizeX.setToolTipText("X pixel size");
        this.cbPxSizeX = new JComboBox<String>(cbModel);
        GridBagConstraints gbc_cbPxSizeX = new GridBagConstraints();
        gbc_cbPxSizeX.fill = 1;
        gbc_cbPxSizeX.insets = new Insets(0, 0, 5, 5);
        gbc_cbPxSizeX.gridx = 2;
        gbc_cbPxSizeX.gridy = 0;
        this.panelPixelSize.add((Component)this.cbPxSizeX, gbc_cbPxSizeX);
        this.lblY = new JLabel("Y");
        GridBagConstraints gbc_lblY = new GridBagConstraints();
        gbc_lblY.anchor = 17;
        gbc_lblY.fill = 3;
        gbc_lblY.insets = new Insets(0, 0, 5, 5);
        gbc_lblY.gridx = 0;
        gbc_lblY.gridy = 1;
        this.panelPixelSize.add((Component)this.lblY, gbc_lblY);
        this.tfPxSizeY = new NumberTextField();
        this.tfPxSizeY.setColumns(4);
        GridBagConstraints gbc_tfPxSizeY = new GridBagConstraints();
        gbc_tfPxSizeY.fill = 1;
        gbc_tfPxSizeY.insets = new Insets(0, 0, 5, 5);
        gbc_tfPxSizeY.gridx = 1;
        gbc_tfPxSizeY.gridy = 1;
        this.panelPixelSize.add((Component)this.tfPxSizeY, gbc_tfPxSizeY);
        this.tfPxSizeY.setToolTipText("Y pixel size");
        this.cbPxSizeY = new JComboBox<String>(cbModel);
        GridBagConstraints gbc_cbPxSizeY = new GridBagConstraints();
        gbc_cbPxSizeY.fill = 1;
        gbc_cbPxSizeY.insets = new Insets(0, 0, 5, 5);
        gbc_cbPxSizeY.gridx = 2;
        gbc_cbPxSizeY.gridy = 1;
        this.panelPixelSize.add((Component)this.cbPxSizeY, gbc_cbPxSizeY);
        this.checkLinked = new JCheckBox("link X/Y");
        GridBagConstraints gbc_checkLinked = new GridBagConstraints();
        gbc_checkLinked.anchor = 17;
        gbc_checkLinked.fill = 3;
        gbc_checkLinked.insets = new Insets(0, 0, 5, 0);
        gbc_checkLinked.gridx = 3;
        gbc_checkLinked.gridy = 1;
        this.panelPixelSize.add((Component)this.checkLinked, gbc_checkLinked);
        this.lblZ = new JLabel("Z");
        GridBagConstraints gbc_lblZ = new GridBagConstraints();
        gbc_lblZ.anchor = 17;
        gbc_lblZ.fill = 3;
        gbc_lblZ.insets = new Insets(0, 0, 0, 5);
        gbc_lblZ.gridx = 0;
        gbc_lblZ.gridy = 2;
        this.panelPixelSize.add((Component)this.lblZ, gbc_lblZ);
        this.tfPxSizeZ = new NumberTextField();
        this.tfPxSizeZ.setColumns(4);
        GridBagConstraints gbc_tfPxSizeZ = new GridBagConstraints();
        gbc_tfPxSizeZ.fill = 1;
        gbc_tfPxSizeZ.insets = new Insets(0, 0, 0, 5);
        gbc_tfPxSizeZ.gridx = 1;
        gbc_tfPxSizeZ.gridy = 2;
        this.panelPixelSize.add((Component)this.tfPxSizeZ, gbc_tfPxSizeZ);
        this.tfPxSizeZ.setToolTipText("Z pixel size");
        this.cbPxSizeZ = new JComboBox<String>(cbModel);
        GridBagConstraints gbc_cbPxSizeZ = new GridBagConstraints();
        gbc_cbPxSizeZ.fill = 1;
        gbc_cbPxSizeZ.insets = new Insets(0, 0, 0, 5);
        gbc_cbPxSizeZ.gridx = 2;
        gbc_cbPxSizeZ.gridy = 2;
        this.panelPixelSize.add((Component)this.cbPxSizeZ, gbc_cbPxSizeZ);
        this.checkLinked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SequencePropertiesPanel.this.checkLinked.isSelected()) {
                    SequencePropertiesPanel.this.tfPxSizeY.setEnabled(false);
                    SequencePropertiesPanel.this.tfPxSizeY.setText(SequencePropertiesPanel.this.tfPxSizeX.getText());
                    SequencePropertiesPanel.this.cbPxSizeY.setEnabled(false);
                } else {
                    SequencePropertiesPanel.this.tfPxSizeY.setEnabled(true);
                    SequencePropertiesPanel.this.cbPxSizeY.setEnabled(true);
                }
            }
        });
        this.panelTimeInterval = new JPanel();
        this.panelTimeInterval.setBorder(new TitledBorder(null, "Time Interval", 4, 2, null, null));
        panelMain.add(this.panelTimeInterval);
        GridBagLayout gbl_panelTimeInterval = new GridBagLayout();
        gbl_panelTimeInterval.columnWidths = new int[]{60, 80, 40, 60, 0};
        gbl_panelTimeInterval.rowHeights = new int[]{0, 0};
        gbl_panelTimeInterval.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panelTimeInterval.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelTimeInterval.setLayout(gbl_panelTimeInterval);
        this.lblValue = new JLabel("Value");
        GridBagConstraints gbc_lblValue = new GridBagConstraints();
        gbc_lblValue.anchor = 17;
        gbc_lblValue.fill = 3;
        gbc_lblValue.insets = new Insets(0, 0, 0, 5);
        gbc_lblValue.gridx = 0;
        gbc_lblValue.gridy = 0;
        this.panelTimeInterval.add((Component)this.lblValue, gbc_lblValue);
        this.tfTimeInterval = new NumberTextField();
        this.tfTimeInterval.setColumns(4);
        GridBagConstraints gbc_tfTimeInterval = new GridBagConstraints();
        gbc_tfTimeInterval.fill = 1;
        gbc_tfTimeInterval.insets = new Insets(0, 0, 0, 5);
        gbc_tfTimeInterval.gridx = 1;
        gbc_tfTimeInterval.gridy = 0;
        this.panelTimeInterval.add((Component)this.tfTimeInterval, gbc_tfTimeInterval);
        this.tfTimeInterval.setToolTipText("T time resolution");
        this.cbTimeUnit = new JComboBox<String>(new String[]{"h", "min", "s", "ms"});
        GridBagConstraints gbc_cbTimeUnit = new GridBagConstraints();
        gbc_cbTimeUnit.insets = new Insets(0, 0, 0, 5);
        gbc_cbTimeUnit.fill = 1;
        gbc_cbTimeUnit.gridx = 2;
        gbc_cbTimeUnit.gridy = 0;
        this.panelTimeInterval.add((Component)this.cbTimeUnit, gbc_cbTimeUnit);
        this.cbTimeUnit.setSelectedIndex(2);
        this.panelPosition = new JPanel();
        this.panelPosition.setBorder(new TitledBorder(null, "Position", 4, 2, null, null));
        panelMain.add(this.panelPosition);
        GridBagLayout gbl_panelPosition = new GridBagLayout();
        gbl_panelPosition.columnWidths = new int[]{60, 80, 40, 60, 0};
        gbl_panelPosition.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelPosition.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panelPosition.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panelPosition.setLayout(gbl_panelPosition);
        JLabel lblX_1 = new JLabel("X");
        GridBagConstraints gbc_lblX_1 = new GridBagConstraints();
        gbc_lblX_1.fill = 3;
        gbc_lblX_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblX_1.anchor = 17;
        gbc_lblX_1.gridx = 0;
        gbc_lblX_1.gridy = 0;
        this.panelPosition.add((Component)lblX_1, gbc_lblX_1);
        this.positionXField = new NumberTextField();
        this.positionXField.setColumns(4);
        this.positionXField.setToolTipText("Image position / offset X");
        GridBagConstraints gbc_positionXfield = new GridBagConstraints();
        gbc_positionXfield.insets = new Insets(0, 0, 5, 5);
        gbc_positionXfield.fill = 1;
        gbc_positionXfield.gridx = 1;
        gbc_positionXfield.gridy = 0;
        this.panelPosition.add((Component)this.positionXField, gbc_positionXfield);
        this.posXUnitComboBox = new JComboBox<String>(cbModel);
        GridBagConstraints gbc_posXUnitComboBox = new GridBagConstraints();
        gbc_posXUnitComboBox.insets = new Insets(0, 0, 5, 5);
        gbc_posXUnitComboBox.fill = 1;
        gbc_posXUnitComboBox.gridx = 2;
        gbc_posXUnitComboBox.gridy = 0;
        this.panelPosition.add((Component)this.posXUnitComboBox, gbc_posXUnitComboBox);
        JLabel lblY_1 = new JLabel("Y");
        GridBagConstraints gbc_lblY_1 = new GridBagConstraints();
        gbc_lblY_1.fill = 3;
        gbc_lblY_1.anchor = 17;
        gbc_lblY_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblY_1.gridx = 0;
        gbc_lblY_1.gridy = 1;
        this.panelPosition.add((Component)lblY_1, gbc_lblY_1);
        this.positionYField = new NumberTextField();
        this.positionYField.setColumns(4);
        this.positionYField.setToolTipText("Image position / offset Y");
        GridBagConstraints gbc_positionYField = new GridBagConstraints();
        gbc_positionYField.insets = new Insets(0, 0, 5, 5);
        gbc_positionYField.fill = 1;
        gbc_positionYField.gridx = 1;
        gbc_positionYField.gridy = 1;
        this.panelPosition.add((Component)this.positionYField, gbc_positionYField);
        this.posYUnitComboBox = new JComboBox<String>(cbModel);
        GridBagConstraints gbc_posYUnitComboBox = new GridBagConstraints();
        gbc_posYUnitComboBox.insets = new Insets(0, 0, 5, 5);
        gbc_posYUnitComboBox.fill = 1;
        gbc_posYUnitComboBox.gridx = 2;
        gbc_posYUnitComboBox.gridy = 1;
        this.panelPosition.add((Component)this.posYUnitComboBox, gbc_posYUnitComboBox);
        JLabel lblZ_1 = new JLabel("Z");
        GridBagConstraints gbc_lblZ_1 = new GridBagConstraints();
        gbc_lblZ_1.fill = 3;
        gbc_lblZ_1.anchor = 17;
        gbc_lblZ_1.insets = new Insets(0, 0, 0, 5);
        gbc_lblZ_1.gridx = 0;
        gbc_lblZ_1.gridy = 2;
        this.panelPosition.add((Component)lblZ_1, gbc_lblZ_1);
        this.positionZField = new NumberTextField();
        this.positionZField.setColumns(4);
        this.positionZField.setToolTipText("Image position / offset Z");
        GridBagConstraints gbc_positionZField = new GridBagConstraints();
        gbc_positionZField.insets = new Insets(0, 0, 0, 5);
        gbc_positionZField.fill = 1;
        gbc_positionZField.gridx = 1;
        gbc_positionZField.gridy = 2;
        this.panelPosition.add((Component)this.positionZField, gbc_positionZField);
        this.posZUnitComboBox = new JComboBox<String>(cbModel);
        GridBagConstraints gbc_posZUnitComboBox = new GridBagConstraints();
        gbc_posZUnitComboBox.insets = new Insets(0, 0, 0, 5);
        gbc_posZUnitComboBox.fill = 1;
        gbc_posZUnitComboBox.gridx = 2;
        gbc_posZUnitComboBox.gridy = 2;
        this.panelPosition.add((Component)this.posZUnitComboBox, gbc_posZUnitComboBox);
        this.panelChannels = new JPanel();
        this.panelChannels.setBorder(new TitledBorder(null, "Channels", 4, 2, null, null));
        panelMain.add(this.panelChannels);
        this.panelChannels.setLayout(new BoxLayout(this.panelChannels, 1));
    }

    public void setSequence(Sequence sequence) {
        this.nameField.setText(sequence.getName());
        double pxSizeX = sequence.getPixelSizeX();
        double pxSizeY = sequence.getPixelSizeY();
        double pxSizeZ = sequence.getPixelSizeZ();
        UnitUtil.UnitPrefix pxSizeXUnit = UnitUtil.getBestUnit(pxSizeX, UnitUtil.UnitPrefix.MICRO);
        UnitUtil.UnitPrefix pxSizeYUnit = UnitUtil.getBestUnit(pxSizeX, UnitUtil.UnitPrefix.MICRO);
        UnitUtil.UnitPrefix pxSizeZUnit = UnitUtil.getBestUnit(pxSizeX, UnitUtil.UnitPrefix.MICRO);
        this.cbPxSizeX.setSelectedItem(pxSizeXUnit.toString() + "m");
        this.cbPxSizeY.setSelectedItem(pxSizeYUnit.toString() + "m");
        this.cbPxSizeZ.setSelectedItem(pxSizeZUnit.toString() + "m");
        this.tfPxSizeX.setText(StringUtil.toString(UnitUtil.getValueInUnit(pxSizeX, UnitUtil.UnitPrefix.MICRO, pxSizeXUnit)));
        this.tfPxSizeY.setText(StringUtil.toString(UnitUtil.getValueInUnit(pxSizeY, UnitUtil.UnitPrefix.MICRO, pxSizeYUnit)));
        this.tfPxSizeZ.setText(StringUtil.toString(UnitUtil.getValueInUnit(pxSizeZ, UnitUtil.UnitPrefix.MICRO, pxSizeZUnit)));
        if (this.tfPxSizeX.getText().equals(this.tfPxSizeY.getText()) && this.cbPxSizeX.getSelectedIndex() == this.cbPxSizeY.getSelectedIndex()) {
            this.checkLinked.doClick();
        }
        double timeInterval = sequence.getTimeInterval() * 1000.0;
        TimeUnit unit = UnitUtil.getBestTimeUnit(timeInterval);
        switch (unit) {
            case MILLISECONDS: {
                this.tfTimeInterval.setText(StringUtil.toString(timeInterval));
                this.cbTimeUnit.setSelectedIndex(3);
                break;
            }
            case SECONDS: {
                this.tfTimeInterval.setText(StringUtil.toString(timeInterval / 1000.0));
                this.cbTimeUnit.setSelectedIndex(2);
                break;
            }
            case MINUTES: {
                this.tfTimeInterval.setText(StringUtil.toString(timeInterval / 60000.0));
                this.cbTimeUnit.setSelectedIndex(1);
                break;
            }
            case HOURS: {
                this.tfTimeInterval.setText(StringUtil.toString(timeInterval / 3600000.0));
                this.cbTimeUnit.setSelectedIndex(0);
            }
        }
        double posX = sequence.getPositionX();
        double posY = sequence.getPositionY();
        double posZ = sequence.getPositionZ();
        UnitUtil.UnitPrefix posXUnit = UnitUtil.getBestUnit(posX, UnitUtil.UnitPrefix.MICRO);
        UnitUtil.UnitPrefix posYUnit = UnitUtil.getBestUnit(posY, UnitUtil.UnitPrefix.MICRO);
        UnitUtil.UnitPrefix posZUnit = UnitUtil.getBestUnit(posZ, UnitUtil.UnitPrefix.MICRO);
        this.posXUnitComboBox.setSelectedItem(posXUnit.toString() + "m");
        this.posYUnitComboBox.setSelectedItem(posYUnit.toString() + "m");
        this.posZUnitComboBox.setSelectedItem(posZUnit.toString() + "m");
        this.positionXField.setText(StringUtil.toString(UnitUtil.getValueInUnit(posX, UnitUtil.UnitPrefix.MICRO, posXUnit)));
        this.positionYField.setText(StringUtil.toString(UnitUtil.getValueInUnit(posY, UnitUtil.UnitPrefix.MICRO, posYUnit)));
        this.positionZField.setText(StringUtil.toString(UnitUtil.getValueInUnit(posZ, UnitUtil.UnitPrefix.MICRO, posZUnit)));
        int sizeC = sequence.getSizeC();
        this.panelChannels.removeAll();
        this.tfsChannels = new IcyTextField[sizeC];
        for (int c = 0; c < sizeC; ++c) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 2));
            JLabel label = new JLabel("Channel " + c + " name");
            label.setToolTipText("Channel " + c + " name");
            ComponentUtil.setFixedWidth(label, 100);
            IcyTextField field = new IcyTextField();
            field.setText(sequence.getChannelName(c));
            panel.add(label);
            panel.add(field);
            this.tfsChannels[c] = field;
            this.panelChannels.add(panel);
        }
        this.panelChannels.revalidate();
    }

    public String getNameFieldValue() {
        return this.nameField.getText();
    }

    public double getPixelSizeXFieldValue() {
        return this.tfPxSizeX.getNumericValue();
    }

    public UnitUtil.UnitPrefix getPixelSizeXUnit() {
        return UnitUtil.UnitPrefix.values()[this.cbPxSizeX.getSelectedIndex() + this.unitStartIndex];
    }

    public double getPixelSizeYFieldValue() {
        if (this.checkLinked.isSelected()) {
            return this.tfPxSizeX.getNumericValue();
        }
        return this.tfPxSizeY.getNumericValue();
    }

    public UnitUtil.UnitPrefix getPixelSizeYUnit() {
        if (this.checkLinked.isSelected()) {
            return UnitUtil.UnitPrefix.values()[this.cbPxSizeX.getSelectedIndex() + this.unitStartIndex];
        }
        return UnitUtil.UnitPrefix.values()[this.cbPxSizeY.getSelectedIndex() + this.unitStartIndex];
    }

    public double getPixelSizeZFieldValue() {
        return this.tfPxSizeZ.getNumericValue();
    }

    public UnitUtil.UnitPrefix getPixelSizeZUnit() {
        return UnitUtil.UnitPrefix.values()[this.cbPxSizeZ.getSelectedIndex() + this.unitStartIndex];
    }

    public double getTimeIntervalFieldValue() {
        return this.tfTimeInterval.getNumericValue();
    }

    public int getTimeIntervalUnit() {
        return this.cbTimeUnit.getSelectedIndex();
    }

    public double getPositionXValue() {
        return this.positionXField.getNumericValue();
    }

    public UnitUtil.UnitPrefix getPositionXUnit() {
        return UnitUtil.UnitPrefix.values()[this.posXUnitComboBox.getSelectedIndex() + this.unitStartIndex];
    }

    public double getPositionYValue() {
        return this.positionYField.getNumericValue();
    }

    public UnitUtil.UnitPrefix getPositionYUnit() {
        return UnitUtil.UnitPrefix.values()[this.posYUnitComboBox.getSelectedIndex() + this.unitStartIndex];
    }

    public double getPositionZValue() {
        return this.positionZField.getNumericValue();
    }

    public UnitUtil.UnitPrefix getPositionZUnit() {
        return UnitUtil.UnitPrefix.values()[this.posZUnitComboBox.getSelectedIndex() + this.unitStartIndex];
    }

    public String getChannelNameFieldValue(int index) {
        return this.tfsChannels[index].getText();
    }
}

