/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.image.IcyBufferedImage;
import icy.image.ImageDataIterator;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.DataIterator;
import icy.type.rectangle.Rectangle5D;
import java.awt.Rectangle;
import java.util.NoSuchElementException;

public class SequenceDataIterator
implements DataIterator {
    protected final Sequence sequence;
    protected final ROI roi;
    protected final Rectangle XYBounds;
    protected final int startC;
    protected final int endC;
    protected final int startZ;
    protected final int endZ;
    protected final int startT;
    protected final int endT;
    protected final boolean inclusive;
    protected int c;
    protected int z;
    protected int t;
    protected boolean done;
    protected ImageDataIterator imageIterator;

    public SequenceDataIterator(Sequence sequence, Rectangle5D.Integer bounds5D) {
        this.sequence = sequence;
        this.roi = null;
        this.imageIterator = null;
        this.inclusive = true;
        if (sequence != null) {
            Rectangle5D.Integer bounds = (Rectangle5D.Integer)bounds5D.createIntersection(sequence.getBounds5D());
            this.XYBounds = (Rectangle)bounds.toRectangle2D();
            this.startZ = bounds.z;
            this.endZ = bounds.z + bounds.sizeZ - 1;
            this.startT = bounds.t;
            this.endT = bounds.t + bounds.sizeT - 1;
            this.startC = bounds.c;
            this.endC = bounds.c + bounds.sizeC - 1;
        } else {
            this.XYBounds = null;
            this.startZ = 0;
            this.endZ = 0;
            this.startT = 0;
            this.endT = 0;
            this.startC = 0;
            this.endC = 0;
        }
        this.reset();
    }

    public SequenceDataIterator(Sequence sequence, Rectangle XYBounds, int z, int t, int c) {
        this(sequence, new Rectangle5D.Integer(XYBounds.x, XYBounds.y, z, t, c, XYBounds.x + XYBounds.width - 1, XYBounds.y + XYBounds.height - 1, 1, 1, 1));
    }

    @Deprecated
    public SequenceDataIterator(Sequence sequence, int startX, int endX, int startY, int endY, int startC, int endC, int startZ, int endZ, int startT, int endT) {
        this(sequence, new Rectangle5D.Integer(startX, startY, startZ, startT, startC, endX - startX + 1, endY - startY + 1, endZ - startZ + 1, endT - startT + 1, endC - startC + 1));
    }

    @Deprecated
    public SequenceDataIterator(Sequence sequence, int startX, int endX, int startY, int endY, int c, int z, int t) {
        this(sequence, new Rectangle5D.Integer(startX, startY, z, t, c, endX - startX + 1, endY - startY + 1, 1, 1, 1));
    }

    public SequenceDataIterator(Sequence sequence, int z, int t, int c) {
        this(sequence, new Rectangle5D.Integer(0, 0, z, t, c, sequence.getSizeX(), sequence.getSizeY(), 1, 1, 1));
    }

    public SequenceDataIterator(Sequence sequence) {
        this(sequence, new Rectangle5D.Integer(0, 0, 0, 0, 0, sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeZ(), sequence.getSizeT(), sequence.getSizeC()));
    }

    public SequenceDataIterator(Sequence sequence, ROI roi, boolean inclusive, int z, int t, int c) {
        this.sequence = sequence;
        this.roi = roi;
        this.inclusive = inclusive;
        this.XYBounds = null;
        if (sequence != null && roi != null) {
            Rectangle5D bounds5D = roi.getBounds5D();
            if (z != -1) {
                bounds5D.setZ(z);
                bounds5D.setSizeZ(1.0);
            }
            if (t != -1) {
                bounds5D.setT(t);
                bounds5D.setSizeT(1.0);
            }
            if (c != -1) {
                bounds5D.setC(c);
                bounds5D.setSizeC(1.0);
            }
            Rectangle5D.Integer bounds = (Rectangle5D.Integer)sequence.getBounds5D().createIntersection(bounds5D);
            this.startZ = bounds.z;
            this.endZ = bounds.z + bounds.sizeZ - 1;
            this.startT = bounds.t;
            this.endT = bounds.t + bounds.sizeT - 1;
            this.startC = bounds.c;
            this.endC = bounds.c + bounds.sizeC - 1;
        } else {
            this.startZ = 0;
            this.endZ = 0;
            this.startT = 0;
            this.endT = 0;
            this.startC = 0;
            this.endC = 0;
        }
        this.reset();
    }

    public SequenceDataIterator(Sequence sequence, ROI roi, boolean inclusive) {
        this(sequence, roi, inclusive, -1, -1, -1);
    }

    public SequenceDataIterator(Sequence sequence, ROI roi) {
        this(sequence, roi, false);
    }

    @Override
    public void reset() {
        boolean bl = this.done = this.sequence == null || this.startT > this.endT || this.startZ > this.endZ || this.startC > this.endC;
        if (!this.done) {
            this.t = this.startT;
            this.z = this.startZ;
            this.c = this.startC;
            this.prepareDataXY();
            this.nextImageifNeeded();
        }
    }

    protected void flushDataXY() {
        if (this.imageIterator != null) {
            this.imageIterator.flush();
        }
    }

    protected void prepareDataXY() {
        this.flushDataXY();
        IcyBufferedImage img = this.sequence.getImage(this.t, this.z);
        if (this.roi != null) {
            switch (this.roi.getDimension()) {
                case 2: {
                    this.imageIterator = new ImageDataIterator(img, this.roi.getBooleanMask2D(-1, -1, -1, this.inclusive), this.c);
                    break;
                }
                case 3: {
                    this.imageIterator = new ImageDataIterator(img, this.roi.getBooleanMask2D(this.z, -1, -1, this.inclusive), this.c);
                    break;
                }
                case 4: {
                    this.imageIterator = new ImageDataIterator(img, this.roi.getBooleanMask2D(this.z, this.t, -1, this.inclusive), this.c);
                    break;
                }
                default: {
                    this.imageIterator = new ImageDataIterator(img, this.roi.getBooleanMask2D(this.z, this.t, this.c, this.inclusive), this.c);
                    break;
                }
            }
        } else {
            this.imageIterator = new ImageDataIterator(img, this.XYBounds, this.c);
        }
    }

    @Override
    public void next() {
        this.imageIterator.next();
        this.nextImageifNeeded();
    }

    protected void nextImageifNeeded() {
        while (this.imageIterator.done() && !this.done) {
            if (++this.c > this.endC) {
                this.c = this.startC;
                if (++this.z > this.endZ) {
                    this.z = this.startZ;
                    if (++this.t > this.endT) {
                        this.done = true;
                        return;
                    }
                }
            }
            this.prepareDataXY();
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public double get() {
        if (this.done) {
            throw new NoSuchElementException("SequenceDataIterator.get() error: no more element !");
        }
        return this.imageIterator.get();
    }

    @Override
    public void set(double value) {
        if (this.done) {
            throw new NoSuchElementException("SequenceDataIterator.get() error: no more element !");
        }
        this.imageIterator.set(value);
    }

    public int getPositionX() {
        if (this.imageIterator != null) {
            return this.imageIterator.getX();
        }
        return 0;
    }

    public int getPositionY() {
        if (this.imageIterator != null) {
            return this.imageIterator.getY();
        }
        return 0;
    }

    public int getPositionC() {
        return this.c;
    }

    public int getPositionZ() {
        return this.z;
    }

    public int getPositionT() {
        return this.t;
    }

    public void flush() {
        this.flushDataXY();
    }
}

