/*
 * Decompiled with CFR 0.152.
 */
package icy.type.dimension;

import icy.type.dimension.Dimension2D;
import icy.type.dimension.Dimension3D;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;

public abstract class Dimension4D
implements Cloneable {
    public abstract double getSizeX();

    public abstract double getSizeY();

    public abstract double getSizeZ();

    public abstract double getSizeT();

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    public abstract void setSizeZ(double var1);

    public abstract void setSizeT(double var1);

    public abstract void setSize(double var1, double var3, double var5, double var7);

    public void setSize(Dimension4D d) {
        this.setSize(d.getSizeX(), d.getSizeY(), d.getSizeZ(), d.getSizeT());
    }

    public abstract boolean isInfiniteX();

    public abstract boolean isInfiniteY();

    public abstract boolean isInfiniteZ();

    public abstract boolean isInfiniteT();

    public abstract Dimension2D toDimension2D();

    public abstract Dimension3D toDimension3D();

    public Integer toInteger() {
        return new Integer((int)Math.ceil(this.getSizeX()), (int)Math.ceil(this.getSizeY()), (int)Math.ceil(this.getSizeZ()), (int)Math.ceil(this.getSizeT()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dimension4D) {
            Dimension4D dim = (Dimension4D)obj;
            return this.getSizeX() == dim.getSizeX() && this.getSizeY() == dim.getSizeY() && this.getSizeZ() == dim.getSizeZ() && this.getSizeT() == dim.getSizeT();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getSizeX() + "," + this.getSizeY() + "," + this.getSizeZ() + "," + this.getSizeT() + "]";
    }

    public static class Integer
    extends Dimension4D {
        public int sizeX;
        public int sizeY;
        public int sizeZ;
        public int sizeT;

        public Integer(int sizeX, int sizeY, int sizeZ, int sizeT) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        public Integer(int[] sizeXYZT) {
            int len = sizeXYZT.length;
            if (len > 0) {
                this.sizeX = sizeXYZT[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZT[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZT[2];
            }
            if (len > 3) {
                this.sizeT = sizeXYZT[3];
            }
        }

        public Integer() {
            this(0, 0, 0, 0);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (int)Math.ceil(value);
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (int)Math.ceil(value);
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (int)Math.ceil(value);
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (int)Math.ceil(value);
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.sizeX = (int)Math.ceil(sizeX);
            this.sizeY = (int)Math.ceil(sizeY);
            this.sizeZ = (int)Math.ceil(sizeZ);
            this.sizeT = (int)Math.ceil(sizeT);
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteT() {
            return this.getSizeT() == 2.147483647E9;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension(this.sizeX, this.sizeY);
        }

        @Override
        public Dimension3D toDimension3D() {
            return new Dimension3D.Integer(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Integer toInteger() {
            return (Integer)this.clone();
        }
    }

    public static class Float
    extends Dimension4D {
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public float sizeT;

        public Float(float sizeX, float sizeY, float sizeZ, float sizeT) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        public Float(float[] sizeXYZT) {
            int len = sizeXYZT.length;
            if (len > 0) {
                this.sizeX = sizeXYZT[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZT[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZT[2];
            }
            if (len > 3) {
                this.sizeT = sizeXYZT[3];
            }
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (float)value;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (float)value;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
            this.sizeZ = (float)sizeZ;
            this.sizeT = (float)sizeT;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteT() {
            return this.getSizeT() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension2D.Float(this.sizeX, this.sizeY);
        }

        @Override
        public Dimension3D toDimension3D() {
            return new Dimension3D.Float(this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    public static class Double
    extends Dimension4D {
        public double sizeX;
        public double sizeY;
        public double sizeZ;
        public double sizeT;

        public Double(double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        public Double(double[] sizeXYZT) {
            int len = sizeXYZT.length;
            if (len > 0) {
                this.sizeX = sizeXYZT[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZT[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZT[2];
            }
            if (len > 3) {
                this.sizeT = sizeXYZT[3];
            }
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = value;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = value;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteT() {
            return this.getSizeT() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension2D.Double(this.sizeX, this.sizeY);
        }

        @Override
        public Dimension3D toDimension3D() {
            return new Dimension3D.Double(this.sizeX, this.sizeY, this.sizeZ);
        }
    }
}

