/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import javax.swing.UIDefaults;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.pushingpixels.lafwidget.ant.AugmentException;
import org.pushingpixels.lafwidget.ant.InfoClassVisitor;
import org.pushingpixels.lafwidget.ant.UiDelegateWriterEmptyCtr;
import org.pushingpixels.lafwidget.ant.UiDelegateWriterOneParamCtr;
import org.pushingpixels.lafwidget.ant.Utils;

public class LafMainClassAugmenter {
    protected static String METHOD_NAME = "initClassDefaults";
    private boolean isVerbose;
    private String[] delegatesToAdd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String augmentClass(String dir, String name) {
        byte[] b;
        if (this.isVerbose) {
            System.out.println("Working on LAF main class " + name);
        }
        String resource = dir + File.separator + name.replace('.', '/') + ".class";
        Method origMethod = null;
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{new File(dir).toURL()}, LafMainClassAugmenter.class.getClassLoader());
            Class<?> clazz = cl.loadClass(name);
            origMethod = clazz.getDeclaredMethod(METHOD_NAME, UIDefaults.class);
        }
        catch (NoSuchMethodException nsme) {
            origMethod = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AugmentException(name, e);
        }
        Set<String> existingMethods = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(resource);
            ClassReader cr = new ClassReader((InputStream)is);
            InfoClassVisitor infoAdapter = new InfoClassVisitor();
            cr.accept((ClassVisitor)infoAdapter, 4);
            existingMethods = infoAdapter.getMethods();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AugmentException(name, e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        String superClassName = null;
        try {
            is = new FileInputStream(resource);
            ClassReader cr = new ClassReader((InputStream)is);
            ClassWriter cw = new ClassWriter(cr, 2);
            AugmentClassAdapter cv = new AugmentClassAdapter((ClassVisitor)cw, existingMethods, origMethod);
            cr.accept((ClassVisitor)cv, 4);
            b = cw.toByteArray();
            superClassName = cv.getSuperClassName();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AugmentException(name, e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(resource);
            fos.write(b);
            if (this.isVerbose) {
                System.out.println("Updated resource " + resource);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return superClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String toStrip, File file, String mainClassName) {
        block19: {
            block18: {
                if (!file.isDirectory()) break block18;
                File[] children = file.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    this.process(toStrip, children[i], mainClassName);
                }
                break block19;
            }
            String className = file.getAbsolutePath().substring(toStrip.length() + 1);
            className = className.replace(File.separatorChar, '.');
            if (!mainClassName.equals(className = className.substring(0, className.length() - 6))) break block19;
            String superClassName = this.augmentClass(toStrip, className);
            for (int i = 0; i < this.delegatesToAdd.length; ++i) {
                String uiKey = this.delegatesToAdd[i];
                String uiSuperClassName = Utils.getUtils().getUIDelegate(uiKey, superClassName);
                Class<?>[] uiSuperCtrParams = null;
                try {
                    Class<?> uiSuperClazz = Class.forName(uiSuperClassName);
                    Constructor<?>[] uiSuperCtrs = uiSuperClazz.getDeclaredConstructors();
                    if (uiSuperCtrs.length != 1) {
                        throw new AugmentException("Unsupported base UI class " + uiSuperClassName + " - not exactly one ctr");
                    }
                    Constructor<?> uiSuperCtr = uiSuperCtrs[0];
                    uiSuperCtrParams = uiSuperCtr.getParameterTypes();
                    if (uiSuperCtrParams.length > 1) {
                        throw new AugmentException("Unsupported base UI class " + uiSuperClassName + " - " + uiSuperCtrParams.length + " parameters");
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new AugmentException("Failed locating base UI class", cnfe);
                }
                int lastDotIndex = className.lastIndexOf(46);
                String packageName = lastDotIndex >= 0 ? className.substring(0, lastDotIndex) : "";
                String uiClassName = "__Forwarding__" + uiKey;
                String resource = toStrip + File.separator + (packageName + File.separator + uiClassName).replace('.', File.separatorChar) + ".class";
                System.out.println("...Creating forwarding delegate");
                System.out.println("...... at '" + resource + "'");
                System.out.println("...... with class name '" + uiClassName + "'");
                System.out.println("...... package '" + packageName + "'");
                System.out.println("...... super impl '" + uiSuperClassName + "'");
                byte[] b = null;
                b = uiSuperCtrParams.length == 0 ? UiDelegateWriterEmptyCtr.createClass(packageName, uiClassName, uiSuperClassName) : UiDelegateWriterOneParamCtr.createClass(packageName, uiClassName, uiSuperClassName, Utils.getTypeDesc(uiSuperCtrParams[0]));
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(resource);
                    fos.write(b);
                    if (!this.isVerbose) continue;
                    System.out.println("...Created resource " + resource);
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void setDelegatesToAdd(String[] delegatesToAdd) {
        this.delegatesToAdd = delegatesToAdd;
    }

    public static void main(String[] args) throws AugmentException {
        if (args.length == 0) {
            System.out.println("Usage : java ... LafMainClassAugmenter [-verbose]");
            System.out.println("\t -main main_class_name -dir class_directory ");
            System.out.println("\t -delegates delegate_ui_ids");
            return;
        }
        LafMainClassAugmenter augmenter = new LafMainClassAugmenter();
        int argNum = 0;
        String mainLafClassName = null;
        String startDir = null;
        while (argNum < args.length) {
            String currArg = args[argNum];
            if ("-verbose".equals(currArg)) {
                augmenter.setVerbose(true);
                ++argNum;
                continue;
            }
            if ("-main".equals(currArg)) {
                mainLafClassName = args[++argNum];
                ++argNum;
                continue;
            }
            if ("-dir".equals(currArg)) {
                startDir = args[++argNum];
                ++argNum;
                continue;
            }
            if (!"-delegates".equals(currArg)) break;
            augmenter.setDelegatesToAdd(args[++argNum].split(";"));
            ++argNum;
        }
        File starter = new File(startDir);
        augmenter.process(starter.getAbsolutePath(), starter, mainLafClassName);
    }

    protected class AugmentClassAdapter
    extends ClassVisitor
    implements Opcodes {
        private Set<String> existingMethods;
        private String prefix;
        private String superClassName;

        public AugmentClassAdapter(ClassVisitor cv, Set<String> existingMethods, Method originalMethod) {
            super(393216, cv);
            this.existingMethods = existingMethods;
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClassName = superName;
            this.prefix = "__" + name.replaceAll("/", "__") + "__";
            super.visit(version, access, name, signature, superName, interfaces);
            boolean hasOriginal = this.existingMethods.contains(METHOD_NAME);
            boolean hasDelegate = this.existingMethods.contains(this.prefix + METHOD_NAME);
            if (LafMainClassAugmenter.this.isVerbose) {
                System.out.println("..." + METHOD_NAME + " (Ljavax/swing/UIDefaults;)V : delegate - " + hasDelegate + ", 1 params");
            }
            if (!hasDelegate) {
                this.augmentInitClassDefaultsMethod(!hasOriginal, name, superName);
            }
        }

        public void augmentInitClassDefaultsMethod(boolean toSynthOriginal, String className, String superClassName) {
            MethodVisitor mv;
            if (toSynthOriginal) {
                if (LafMainClassAugmenter.this.isVerbose) {
                    System.out.println("... Creating empty 'initClassDefaults' forwarding to super '" + superClassName + "'");
                }
                mv = this.cv.visitMethod(4, this.prefix + "initClassDefaults", "(Ljavax/swing/UIDefaults;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, superClassName, "initClassDefaults", "(Ljavax/swing/UIDefaults;)V");
                mv.visitInsn(177);
                mv.visitMaxs(2, 2);
                mv.visitEnd();
            }
            mv = this.cv.visitMethod(4, "initClassDefaults", "(Ljavax/swing/UIDefaults;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, className, this.prefix + "initClassDefaults", "(Ljavax/swing/UIDefaults;)V");
            String packageName = className.replace('/', '.');
            int lastDotIndex = packageName.lastIndexOf(46);
            packageName = lastDotIndex >= 0 ? packageName.substring(0, lastDotIndex) : "";
            for (int i = 0; i < LafMainClassAugmenter.this.delegatesToAdd.length; ++i) {
                mv.visitVarInsn(25, 1);
                String delegateKey = LafMainClassAugmenter.this.delegatesToAdd[i];
                String delegateValue = packageName + ".__Forwarding__" + delegateKey;
                if (LafMainClassAugmenter.this.isVerbose) {
                    System.out.println("...Putting '" + delegateKey + "' -> '" + delegateValue + "'");
                }
                mv.visitLdcInsn((Object)delegateKey);
                mv.visitLdcInsn((Object)delegateValue);
                mv.visitMethodInsn(182, "javax/swing/UIDefaults", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
            }
            mv.visitInsn(177);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (METHOD_NAME.equals(name) && !this.existingMethods.contains(this.prefix + name)) {
                return this.cv.visitMethod(access, this.prefix + name, desc, signature, exceptions);
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

