/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.VarEditorFactory;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.MutableType;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarListener;

public class VarMutable
extends Var
implements MutableType {
    private final ArrayList<TypeChangeListener> listeners = new ArrayList();

    public VarMutable(String name, Class<?> initialType) {
        this(name, initialType, (VarListener<?>)null);
    }

    public VarMutable(String name, Class<?> initialType, VarListener<?> defaultListener) {
        super(name, initialType != null ? initialType : Object.class, null, defaultListener);
    }

    public VarEditor createVarEditor() {
        VarEditorFactory factory = VarEditorFactory.getDefaultFactory();
        if (this.getDefaultEditorModel() instanceof TypeSelectionModel) {
            return factory.createTypeChooser(this);
        }
        return factory.createMutableVarEditor(this);
    }

    public VarEditor createVarViewer() {
        if (Sequence.class.equals((Object)this.type)) {
            return VarEditorFactory.getDefaultFactory().createSequenceViewer(this);
        }
        return super.createVarViewer();
    }

    @Override
    public void addTypeChangeListener(TypeChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTypeChangeListener(TypeChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isAssignableFrom(Var source) {
        Class sourceType = source.getType();
        if (sourceType == null) {
            return false;
        }
        if (this.type == null) {
            return true;
        }
        if (Number.class.isAssignableFrom(this.type) && sourceType.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(sourceType) && this.type.isPrimitive()) {
            return true;
        }
        return this.type.isAssignableFrom(sourceType) || this.type.isArray() && this.type.getComponentType().isAssignableFrom(sourceType);
    }

    public void setDefaultEditorModel(VarEditorModel model) {
        if (model instanceof TypeSelectionModel) {
            this.defaultEditorModel = model;
            this.setType((Class)((TypeSelectionModel)model).getDefaultValue());
        } else {
            super.setDefaultEditorModel(model);
        }
    }

    @Override
    public void setType(Class<?> newType) {
        Class oldType = this.getType();
        if (oldType == newType) {
            return;
        }
        if (this.isReferenced()) {
            throw new IllegalAccessError("Cannot change the type of variable \"" + this.getName() + "\": it is being referenced by another variable");
        }
        this.setValue((Object)null);
        this.type = newType;
        for (TypeChangeListener listener : this.listeners) {
            listener.typeChanged(this, oldType, newType);
        }
    }

    public void setValue(Object newValue) {
        if (newValue == null || this.getType().isAssignableFrom(newValue.getClass())) {
            super.setValue(newValue);
        } else if (newValue instanceof Number && Number.class.isAssignableFrom(this.getType()) || this.getType().isPrimitive() && this.getType() != Boolean.TYPE) {
            if (this.getType() == Integer.class || this.getType() == Integer.TYPE) {
                super.setValue(((Number)newValue).intValue());
            } else if (this.getType() == Double.class || this.getType() == Double.TYPE) {
                super.setValue(((Number)newValue).doubleValue());
            } else if (this.getType() == Byte.class || this.getType() == Byte.TYPE) {
                super.setValue(((Number)newValue).byteValue());
            } else if (this.getType() == Short.class || this.getType() == Short.TYPE) {
                super.setValue(((Number)newValue).shortValue());
            } else if (this.getType() == Float.class || this.getType() == Float.TYPE) {
                super.setValue(Float.valueOf(((Number)newValue).floatValue()));
            } else {
                super.setValue(((Number)newValue).longValue());
            }
        } else if (this.getType().isArray() && newValue.getClass().isArray()) {
            try {
                Class<?> localType = this.getType().getComponentType();
                int nbValues = Array.getLength(newValue);
                Object array = Array.newInstance(localType, nbValues);
                if (localType.isPrimitive()) {
                    DataType dataType = ArrayUtil.getDataType((Object)array);
                    for (int i = 0; i < nbValues; ++i) {
                        Number n = (Number)Array.get(newValue, i);
                        Array1DUtil.setValue((Object)array, (int)i, (DataType)dataType, (double)n.doubleValue());
                    }
                } else {
                    System.arraycopy(newValue, 0, array, 0, nbValues);
                }
                super.setValue(array);
            }
            catch (ArrayStoreException typeError) {
                String text = "[" + ArrayUtil.arrayToString((Object)newValue).replace(":", ", ") + "]";
                throw new ClassCastException(text + " is not of type " + this.getType().getSimpleName());
            }
        } else if (this.getType().isArray() && this.getType().getComponentType().isAssignableFrom(newValue.getClass())) {
            Object array = Array.newInstance(this.getType().getComponentType(), 1);
            Array.set(array, 0, newValue);
            super.setValue(array);
        } else {
            throw new ClassCastException(newValue + " is not of type " + this.getType().getSimpleName());
        }
    }

    public void setReference(Var variable) throws ClassCastException {
        if (variable != null) {
            this.setType(variable.getType());
        }
        super.setReference(variable);
    }
}

