/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarString;
import plugins.stef.roi.bloc.RoiBlocks;

public class SetROIName
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarROIArray roiSet = new VarROIArray("ROI(s)", null);
    protected VarString name = new VarString("Name", "ROI");
    protected VarString numSuffix = new VarString("Number suffix", "_%d");

    public void run() {
        int i = 0;
        for (ROI roi : this.roiSet) {
            if (roi == null) continue;
            String newName = (String)this.name.getValue();
            String suf = (String)this.numSuffix.getValue();
            if (!StringUtil.isEmpty((String)suf)) {
                try {
                    newName = newName + String.format(suf, i);
                }
                catch (Exception e) {
                    System.err.println("Warning: block 'Set ROI Name' cannot parse 'Number suffix' field:");
                    IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
                    System.err.println("Default suffix used.");
                    newName = newName + String.format("_%d", i);
                }
            }
            roi.setName(newName);
            ++i;
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("rois", (Var)this.roiSet);
        inputMap.add("name", (Var)this.name);
        inputMap.add("suffix", (Var)this.numSuffix);
    }

    public void declareOutput(VarList outputMap) {
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

