/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextField;

public abstract class FormattedTextField<T>
extends JTextField {
    private static final long serialVersionUID = 1L;
    private List<ValueListener<T>> _listeners = new LinkedList<ValueListener<T>>();
    private boolean _isTextEmpty;
    private T _currentValue;

    protected FormattedTextField() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextField.this.onComponentValueChanged(FormattedTextField.this.getText());
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FormattedTextField.this.onComponentValueChanged(FormattedTextField.this.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (FormattedTextField.this._isTextEmpty) {
                    FormattedTextField.this.setText("");
                    FormattedTextField.this.setForeground(Color.BLACK);
                }
            }
        });
    }

    public void addValueListener(ValueListener<T> l) {
        this._listeners.add(l);
    }

    public void removeValueListener(ValueListener<T> l) {
        this._listeners.remove(l);
    }

    public T getValue() {
        return this._currentValue;
    }

    public void setValue(T value) {
        T oldValue = this._currentValue;
        this._currentValue = value;
        this.updateComponentText(this.objectToString(this._currentValue));
        if (this.areIdenticObjectsOrNull(this._currentValue, oldValue)) {
            return;
        }
        this.fireValueListeners();
    }

    protected void initializeComponent() {
        this._currentValue = this.stringToObject("");
        this.updateComponentText("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setBackground(enabled ? Color.WHITE : Color.GRAY);
        super.setEnabled(enabled);
    }

    protected abstract String makeHelpText();

    protected abstract T stringToObject(String var1);

    protected abstract String objectToString(T var1);

    protected abstract boolean areIdenticObjects(T var1, T var2);

    private boolean areIdenticObjectsOrNull(T obj1, T obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return this.areIdenticObjects(obj1, obj2);
    }

    private void onComponentValueChanged(String newText) {
        T oldValue = this._currentValue;
        this._currentValue = this.stringToObject(newText);
        this.updateComponentText(this._currentValue == null ? newText : this.objectToString(this._currentValue));
        if (this.areIdenticObjectsOrNull(this._currentValue, oldValue)) {
            return;
        }
        this.fireValueListeners();
    }

    private void updateComponentText(String text) {
        if (text.isEmpty()) {
            this._isTextEmpty = true;
            if (this.hasFocus()) {
                this.setText("");
                this.setForeground(Color.BLACK);
            } else {
                this.setText(this.makeHelpText());
                this.setForeground(Color.GRAY);
            }
        } else {
            this._isTextEmpty = false;
            this.setText(text);
            this.setForeground(this._currentValue == null ? Color.RED : Color.BLACK);
        }
    }

    private void fireValueListeners() {
        for (ValueListener<T> l : this._listeners) {
            l.valueChanged(this._currentValue);
        }
    }

    public static interface ValueListener<T> {
        public void valueChanged(T var1);
    }
}

