/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.roi;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.point.Point5D;
import java.awt.geom.Point2D;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class TranslateROI
extends Plugin
implements ROIBlock {
    VarROIArray inputROI = new VarROIArray("Input ROI");
    VarInteger xShift = new VarInteger("X shift", 0);
    VarInteger yShift = new VarInteger("Y shift", 0);
    VarInteger zShift = new VarInteger("Z shift", 0);
    VarROIArray outputROI = new VarROIArray("Translated ROI");

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("input ROI", (Var<?>)this.inputROI);
        inputMap.add("X shift", (Var<?>)this.xShift);
        inputMap.add("Y shift", (Var<?>)this.yShift);
        inputMap.add("Z shift", (Var<?>)this.zShift);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("output ROI", (Var<?>)this.outputROI);
    }

    @Override
    public void run() {
        this.outputROI.setValue((Object)new ROI[0]);
        for (ROI roi : this.inputROI) {
            ROI shiftedROI;
            if (Thread.currentThread().isInterrupted()) break;
            if (roi.canSetPosition()) {
                shiftedROI = roi.getCopy();
                Point5D pos = shiftedROI.getPosition5D();
                pos.setX(pos.getX() + (double)this.xShift.getValue().intValue());
                pos.setY(pos.getY() + (double)this.yShift.getValue().intValue());
                pos.setZ(pos.getZ() + (double)this.zShift.getValue().intValue());
                shiftedROI.setPosition5D(pos);
                this.outputROI.add((Object[])new ROI[]{shiftedROI});
                continue;
            }
            if (!(roi instanceof ROI3DArea)) continue;
            shiftedROI = new ROI3DArea();
            for (ROI2DArea slice : (ROI3DArea)roi) {
                ROI2DArea sliceCopy = (ROI2DArea)slice.getCopy();
                Point2D p2 = slice.getPosition2D();
                p2.setLocation(p2.getX() + (double)this.xShift.getValue().intValue(), p2.getY() + (double)this.yShift.getValue().intValue());
                sliceCopy.setPosition2D(p2);
                shiftedROI.setSlice(slice.getZ() + this.zShift.getValue(), (ROI2D)sliceCopy);
            }
            this.outputROI.add((Object[])new ROI[]{shiftedROI});
        }
    }
}

