/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.link;

import icy.system.thread.ThreadUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.protocols.gui.block.BlockPanel;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.protocols.gui.link.DragDropZone;
import plugins.adufour.vars.lang.Var;

public abstract class Line
extends Line2D.Float
implements ComponentListener,
MouseListener {
    private final Link<?> link;
    private final Color typeColor;
    protected final BlockPanel srcPanel;
    protected final BlockPanel dstPanel;
    private final Stroke stroke = new BasicStroke(2.0f);
    private boolean isHighlighted = false;
    private final Path2D.Float path = new Path2D.Float();
    private final Ellipse2D.Float closeButton = new Ellipse2D.Float();
    private boolean isSelected = false;
    private final Stroke selectedStroke = new BasicStroke(8.0f);

    public Line(BlockPanel srcPanel, BlockPanel dstPanel, Link<?> link) throws IllegalArgumentException {
        if (link == null) {
            throw new IllegalArgumentException("link cannot be null");
        }
        this.link = link;
        this.srcPanel = srcPanel;
        this.dstPanel = dstPanel;
        this.typeColor = DragDropZone.getColor(link.getType());
        srcPanel.addComponentListener(this);
        dstPanel.addComponentListener(this);
        this.attachListeners();
        this.update();
    }

    public Line(BlockPanel srcPanel, BlockPanel dstPanel, Var<?> exposedVariable) {
        this.link = null;
        this.srcPanel = srcPanel;
        this.dstPanel = dstPanel;
        this.typeColor = DragDropZone.getColor(exposedVariable.getType());
        if (srcPanel.blockDesc.isWorkFlow() && ((WorkFlow)srcPanel.blockDesc.getBlock()).contains(dstPanel.blockDesc)) {
            dstPanel.addComponentListener(this);
        } else {
            srcPanel.addComponentListener(this);
        }
        this.attachListeners();
        this.update();
    }

    private void attachListeners() {
        DragDropZone p1z = this.getP1Zone();
        DragDropZone p2z = this.getP2Zone();
        if (p1z != null) {
            p1z.addMouseListener(this);
        }
        if (p2z != null) {
            p2z.addMouseListener(this);
        }
    }

    protected DragDropZone getP1Zone() {
        return this.srcPanel.getDragZone(this.link.srcVar);
    }

    protected DragDropZone getP2Zone() {
        return this.dstPanel.getDropZone(this.link.dstVar);
    }

    protected void updateP1() {
        Point loc = this.srcPanel.getDragZoneLocation(this.link.srcVar);
        this.x1 = loc.x;
        this.y1 = loc.y;
    }

    protected void updateP2() {
        Point loc = this.dstPanel.getDropZoneLocation(this.link.dstVar);
        this.x2 = loc.x;
        this.y2 = loc.y;
    }

    public abstract void updateShape(Path2D var1, Ellipse2D var2);

    public void paint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isSelected) {
            g.setColor(WorkFlowContainer.TRANSPARENT_BLUE);
            g.setStroke(this.selectedStroke);
            g.draw(this.path);
        }
        g.setColor(this.typeColor);
        g.setStroke(this.stroke);
        this.path.reset();
        this.updateShape(this.path, this.closeButton);
        g.draw(this.path);
        if (this.isHighlighted) {
            this.paintCloseButton(g);
        }
    }

    private void paintCloseButton(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.fill(this.closeButton);
        g2.setColor(Color.white);
        g2.drawLine((int)this.closeButton.x + 4, (int)this.closeButton.y + 4, (int)this.closeButton.x + 8, (int)this.closeButton.y + 8);
        g2.drawLine((int)this.closeButton.x + 4, (int)this.closeButton.y + 8, (int)this.closeButton.x + 8, (int)this.closeButton.y + 4);
        g2.dispose();
    }

    protected void updateCloseButtonShape(Shape s) {
        Rectangle r = s.getBounds();
        this.closeButton.setFrame(r.x + r.width / 2 - 6, r.y + r.height / 2 - 6, 13.0f, 13.0f);
    }

    public boolean isOverCloseButton(Point p) {
        return this.isOverCloseButton(p.x, p.y);
    }

    public boolean isOverCloseButton(double x, double y) {
        return this.closeButton.contains(x, y);
    }

    public void dispose() {
        DragDropZone p1 = this.getP1Zone();
        DragDropZone p2 = this.getP2Zone();
        if (p1 != null) {
            p1.removeMouseListener(this);
        }
        if (p2 != null) {
            p2.removeMouseListener(this);
        }
        this.srcPanel.removeComponentListener(this);
        this.dstPanel.removeComponentListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.updateLine((BlockPanel)arg0.getSource());
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.updateLine((BlockPanel)arg0.getSource());
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCustomColor(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCustomColor(false);
    }

    public void setCustomColor(boolean custom) {
        this.isHighlighted = custom;
        this.srcPanel.getWorkFlowContainer().repaint();
    }

    public void update() {
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Line.this.updateP1();
                    Line.this.updateP2();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void updateLine(BlockPanel panel) {
        if (panel == this.srcPanel) {
            this.updateP1();
        } else {
            this.updateP2();
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }
}

