/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.filtering;

import Jama.Matrix;
import plugins.nchenouard.particletracking.VirtualSpot;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.filtering.Predictor3D;
import plugins.nchenouard.spot.Spot;

public class KF3dDirected
extends KalmanFilter
implements Predictor3D {
    public KF3dDirected() {
        this.initMatrices();
    }

    @Override
    public Matrix buildMeasurementMatrix(Spot s) {
        if (s == null) {
            return null;
        }
        return new Matrix((double[][])new double[][]{{s.mass_center.x}, {s.mass_center.y}, {s.mass_center.z}});
    }

    @Override
    Matrix buildX0(Matrix firstElement) {
        Matrix x0 = new Matrix(6, 1);
        x0.set(0, 0, firstElement.get(0, 0));
        x0.set(1, 0, 0.0);
        x0.set(2, 0, firstElement.get(1, 0));
        x0.set(3, 0, 0.0);
        x0.set(4, 0, firstElement.get(2, 0));
        x0.set(5, 0, 0.0);
        return x0;
    }

    @Override
    Matrix getP0() {
        double[][] p0 = new double[][]{{0.1, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.1, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.1, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.1, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.1, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.1}};
        return new Matrix((double[][])p0);
    }

    @Override
    public void setTrackingCovariances(double[] trackingCov) {
        this.Q.set(0, 0, trackingCov[0]);
        this.Q.set(2, 2, trackingCov[1]);
        this.Q.set(4, 2, trackingCov[2]);
        this.Q0 = this.Q;
    }

    @Override
    public Spot buildSpotFromState(Matrix state) {
        if (state == null) {
            return null;
        }
        return new Spot(state.get(0, 0), state.get(2, 0), state.get(4, 0));
    }

    @Override
    public Predictor copy() {
        KF3dDirected kf = new KF3dDirected();
        this.copyMyDataInKF(kf);
        return kf;
    }

    @Override
    public Predictor copyInit() {
        KF3dDirected kf = new KF3dDirected();
        kf.setTrackingCovariances(this.Q0);
        kf.t = this.t;
        kf.setUpdateCovariances(this.updateCovariances);
        return kf;
    }

    @Override
    public VirtualSpot getCurrentPredictedStateAsSpot() {
        return new VirtualSpot(this.x_pre.get(0, 0), this.x_pre.get(2, 0), this.x_pre.get(4, 0));
    }

    private void initMatrices() {
        double[][] f = new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        this.F = new Matrix((double[][])f);
        double[][] q = new double[][]{{2.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 3.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 3.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 3.0}};
        this.Q = new Matrix((double[][])q);
        double[][] h = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}};
        this.H = new Matrix((double[][])h);
        double[][] r = new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}};
        this.R = new Matrix((double[][])r);
    }

    @Override
    public void correct(Matrix z) {
        if (this.t - this.t0 == 1) {
            Matrix x0 = this.x_est;
            x0.set(1, 0, z.get(0, 0) - this.x_est.get(0, 0));
            x0.set(3, 0, z.get(1, 0) - this.x_est.get(2, 0));
            x0.set(5, 0, z.get(2, 0) - this.x_est.get(4, 0));
            this.init(x0, this.P_est);
        }
        if (z.getRowDimension() != this.H.getRowDimension()) {
            throw new IllegalArgumentException("row dimension of z (is " + z.getRowDimension() + " should be " + this.H.getRowDimension() + ") is not the same as row dimension of H");
        }
        if (z.getColumnDimension() != 1) {
            throw new IllegalArgumentException("z is not a vector");
        }
        this.z_err = z.minus(this.z_pre);
        this.x_est = this.x_pre.plus(this.W.times(this.z_err));
        this.P_est = this.P_pre.minus(this.W.times(this.S).times(this.W.transpose()));
        if (this.t - this.t0 != 1) {
            this.covupdate();
        }
    }

    @Override
    public double getXCoordEstimated() {
        return this.x_est.get(0, 0);
    }

    @Override
    public double getYCoordEstimated() {
        return this.x_est.get(2, 0);
    }

    @Override
    public double getZCoordEstimated() {
        return this.x_est.get(4, 0);
    }

    @Override
    public double getXCoordPredicted() {
        return this.x_pre.get(0, 0);
    }

    @Override
    public double getYCoordPredicted() {
        return this.x_pre.get(2, 0);
    }

    @Override
    public double getZCoordPredicted() {
        return this.x_pre.get(4, 0);
    }

    @Override
    public void setCurrentStateErrorCovariance3D(Matrix m) {
        this.P_est.set(0, 0, m.get(0, 0));
        this.P_est.set(0, 2, m.get(0, 1));
        this.P_est.set(0, 4, m.get(0, 2));
        this.P_est.set(2, 0, m.get(1, 0));
        this.P_est.set(2, 2, m.get(1, 1));
        this.P_est.set(2, 4, m.get(1, 2));
        this.P_est.set(4, 0, m.get(2, 0));
        this.P_est.set(4, 2, m.get(2, 1));
        this.P_est.set(4, 4, m.get(2, 2));
    }

    @Override
    public void setCurrentEstimatedState3D(Matrix m) {
        this.x_est.set(0, 0, m.get(0, 0));
        this.x_est.set(2, 0, m.get(1, 0));
        this.x_est.set(4, 0, m.get(2, 0));
    }

    @Override
    public Matrix getStateErrorCovariance3D(int t) {
        Matrix Ppre = this.F.times(this.P_est).times(this.F.transpose()).plus(this.Q);
        for (int i = this.t + 1; i < t; ++i) {
            Ppre = this.F.times(Ppre).times(this.F.transpose()).plus(this.Q);
        }
        return Ppre;
    }

    @Override
    public Matrix getCurrentEstimatedState3D() {
        Matrix m = new Matrix(3, 1);
        m.set(0, 0, this.x_est.get(0, 0));
        m.set(1, 0, this.x_est.get(2, 0));
        m.set(2, 0, this.x_est.get(4, 0));
        return m;
    }

    @Override
    public Matrix getCurrentStateErrorCovariance3D() {
        Matrix m = new Matrix(3, 3);
        m.set(0, 0, this.P_est.get(0, 0));
        m.set(0, 1, this.P_est.get(0, 2));
        m.set(0, 2, this.P_est.get(0, 4));
        m.set(1, 0, this.P_est.get(2, 0));
        m.set(1, 1, this.P_est.get(2, 2));
        m.set(1, 2, this.P_est.get(2, 4));
        m.set(2, 0, this.P_est.get(4, 0));
        m.set(2, 1, this.P_est.get(4, 2));
        m.set(2, 2, this.P_est.get(4, 4));
        return m;
    }

    @Override
    public Matrix getCurrentPredictedState3D() {
        Matrix m = new Matrix(3, 1);
        m.set(0, 0, this.x_pre.get(0, 0));
        m.set(1, 0, this.x_pre.get(2, 0));
        m.set(2, 0, this.x_pre.get(4, 0));
        return m;
    }
}

