/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.plugin.PluginErrorReport;
import icy.main.Icy;
import icy.network.WebInterface;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.system.IcyHandledException;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IcyExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final double ERROR_ANTISPAM_TIME = 15000.0;
    private static IcyExceptionHandler exceptionHandler = new IcyExceptionHandler();
    private static long lastErrorDialog = 0L;
    private static long lastErrorReport = 0L;
    private static Set<String> reportedPlugins = new HashSet<String>();

    public static void init() {
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
    }

    public static void showErrorMessage(Throwable t, boolean printStackTrace) {
        IcyExceptionHandler.showErrorMessage(t, printStackTrace, true);
    }

    public static void showErrorMessage(Throwable t, boolean printStackTrace, boolean error) {
        String mess = IcyExceptionHandler.getErrorMessage(t, printStackTrace);
        if (!StringUtil.isEmpty(mess)) {
            if (error) {
                System.err.println(mess);
            } else {
                System.out.println(mess);
            }
        }
    }

    public static String getErrorMessage(Throwable t, boolean printStackTrace) {
        String result = "";
        Throwable throwable = t;
        while (throwable != null) {
            result = result + throwable.toString() + "\n";
            if (printStackTrace) {
                try {
                    for (StackTraceElement element : throwable.getStackTrace()) {
                        result = result + "\tat " + element.toString() + "\n";
                    }
                }
                catch (Throwable t2) {
                    result = result + "Error while trying to get exception stack trace...\n";
                }
            }
            if ((throwable = throwable.getCause()) == null) continue;
            result = result + "Caused by :\n";
        }
        return result;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        IcyExceptionHandler.handleException(t, e, true);
    }

    private static void handleException(Thread thread, PluginDescriptor plugin, String devId, Throwable t, boolean printStackStrace) {
        String errMess;
        long current = System.currentTimeMillis();
        String string = errMess = t.getMessage() != null ? t.getMessage() : "";
        if (t instanceof IcyHandledException) {
            String message = errMess + (t.getCause() == null ? "" : "\n" + t.getCause());
            MessageDialog.showDialog((String)message, (int)0);
            lastErrorDialog = System.currentTimeMillis();
        } else {
            String message = "";
            if (t instanceof OutOfMemoryError) {
                message = errMess.contains("Thread") ? "Out of resource error: cannot create new thread.\nYou should report this error as something goes wrong here !" : "The task could not be completed because there is not enough memory !\nTry to use 'virtual mode' (image caching) or increase increase the 'Maximum Memory' parameter in Preferences.";
            }
            if (!StringUtil.isEmpty(message)) {
                message = message + "\n";
            }
            message = message + IcyExceptionHandler.getErrorMessage(t, printStackStrace);
            if (t instanceof OutOfMemoryError || printStackStrace || (double)(current - lastErrorDialog) < 15000.0) {
                if (plugin != null) {
                    System.err.println("An error occured while plugin '" + plugin.getName() + "' was running :");
                } else if (!StringUtil.isEmpty(devId)) {
                    System.err.println("An error occured while a plugin was running :");
                }
                System.err.println(message);
            }
            if ((double)(current - lastErrorDialog) > 15000.0) {
                String title = t.toString();
                if (t instanceof OutOfMemoryError && !errMess.contains("Thread")) {
                    if (!Icy.getMainInterface().isHeadLess()) {
                        new FailedAnnounceFrame("Not enough memory to complete the process ! Try to use 'Virtual Mode' (image caching) or increase the 'Maximum Memory' parameter in Preferences.", 30);
                    }
                } else {
                    PluginErrorReport.report((PluginDescriptor)plugin, (String)devId, (String)title, (String)message);
                }
                lastErrorDialog = System.currentTimeMillis();
            }
        }
    }

    public static void handleException(PluginDescriptor pluginDesc, Throwable t, boolean printStackStrace) {
        IcyExceptionHandler.handleException(null, pluginDesc, null, t, printStackStrace);
    }

    public static void handleException(String devId, Throwable t, boolean printStackStrace) {
        IcyExceptionHandler.handleException(null, null, devId, t, printStackStrace);
    }

    public static void handleException(Throwable t, boolean printStackStrace) {
        IcyExceptionHandler.handleException((Thread)null, t, printStackStrace);
    }

    private static void handleException(Thread thread, Throwable t, boolean printStackStrace) {
        ArrayList plugins = PluginLoader.getPlugins();
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            StackTraceElement[] stackTrace;
            try {
                stackTrace = throwable.getStackTrace();
            }
            catch (Throwable t2) {
                stackTrace = new StackTraceElement[]{};
            }
            PluginDescriptor plugin = IcyExceptionHandler.findPluginFromStackTrace(plugins, stackTrace);
            if (plugin != null) {
                IcyExceptionHandler.handleException(thread, plugin, null, t, printStackStrace);
                return;
            }
            String devId = IcyExceptionHandler.findDevIdFromStackTrace(stackTrace);
            if (devId == null) continue;
            IcyExceptionHandler.handleException(thread, null, devId, t, printStackStrace);
            return;
        }
        IcyExceptionHandler.handleException(thread, null, null, t, printStackStrace);
    }

    @Deprecated
    public static void handlePluginException(PluginDescriptor pluginDesc, Throwable t, boolean printStackStrace) {
        IcyExceptionHandler.handleException(pluginDesc, t, printStackStrace);
    }

    private static PluginDescriptor findMatchingLocalPlugin(List<PluginDescriptor> plugins, String text) {
        String className = ClassUtil.getBaseClassName((String)text);
        File file = ClassUtil.getFile((String)className);
        if (file != null) {
            for (PluginDescriptor p : plugins) {
                String jarFileName = p.getJarFilename();
                if (StringUtil.isEmpty(jarFileName)) continue;
                File jarFile = new File(jarFileName);
                if (!StringUtil.equals(file.getAbsolutePath(), jarFile.getAbsolutePath())) continue;
                return p;
            }
        }
        while (!StringUtil.equals(className, "plugins") && !StringUtil.isEmpty(className)) {
            PluginDescriptor plugin = IcyExceptionHandler.findMatchingLocalPluginInternal(plugins, className);
            if (plugin != null) {
                return plugin;
            }
            className = ClassUtil.getPackageName((String)className);
        }
        return null;
    }

    private static PluginDescriptor findMatchingLocalPluginInternal(List<PluginDescriptor> plugins, String text) {
        PluginDescriptor result = null;
        for (PluginDescriptor plugin : plugins) {
            if (!plugin.getClassName().startsWith(text)) continue;
            if (result != null) {
                return null;
            }
            result = plugin;
        }
        return result;
    }

    private static PluginDescriptor findPluginFromStackTrace(List<PluginDescriptor> plugins, StackTraceElement[] st) {
        for (StackTraceElement trace : st) {
            PluginDescriptor plugin;
            String className = trace.getClassName();
            if (!className.startsWith("plugins.") || (plugin = IcyExceptionHandler.findMatchingLocalPlugin(plugins, className)) == null) continue;
            return plugin;
        }
        return null;
    }

    private static String findDevIdFromStackTrace(StackTraceElement[] st) {
        for (StackTraceElement trace : st) {
            String className = trace.getClassName();
            if (!className.startsWith("plugins.")) continue;
            return className.split("\\.")[1];
        }
        return null;
    }

    public static void report(PluginDescriptor plugin, String devId, String errorLog) {
        long current = System.currentTimeMillis();
        if ((double)(current - lastErrorReport) < 15000.0) {
            return;
        }
        if (plugin != null && reportedPlugins.contains(plugin.getClassName())) {
            return;
        }
        lastErrorReport = current;
        WebInterface.reportError((PluginDescriptor)plugin, (String)devId, (String)errorLog);
    }

    public static void report(PluginDescriptor plugin, String errorLog) {
        IcyExceptionHandler.report(plugin, null, errorLog);
    }

    public static void report(String errorLog) {
        IcyExceptionHandler.report(null, null, errorLog);
    }

    public static void report(String devId, String errorLog) {
        IcyExceptionHandler.report(null, devId, errorLog);
    }
}

