/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import java.util.ArrayList;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class FilterROIBySize
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarROIArray roiSet = new VarROIArray("ROI(s)", null);
    protected VarDouble minimumSize = new VarDouble("Min size (px)", 10.0);
    protected VarDouble maximumSize = new VarDouble("Max size (px)", 10000.0);
    protected VarBoolean incBorder = new VarBoolean("Include border pixels", Boolean.FALSE);
    protected VarROIArray output = new VarROIArray("ROI(s)");

    public void run() {
        ArrayList<ROI> result = new ArrayList<ROI>();
        double min = this.minimumSize.getValue();
        double max = this.maximumSize.getValue();
        boolean border = (Boolean)this.incBorder.getValue();
        for (ROI roi : this.roiSet) {
            if (roi == null) continue;
            double num = roi.getNumberOfPoints();
            if (border) {
                num += roi.getNumberOfContourPoints();
            }
            if (!(num >= min) || !(num <= max)) continue;
            result.add(roi);
        }
        this.output.setValue((Object)result.toArray(new ROI[result.size()]));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("roi", (Var)this.roiSet);
        inputMap.add("minSize", (Var)this.minimumSize);
        inputMap.add("maxSize", (Var)this.maximumSize);
        inputMap.add("incBorder", (Var)this.incBorder);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("out", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

