/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.gui;

import icy.gui.frame.progress.AnnounceFrame;
import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.nchenouard.particletracking.MHTparameterSet;

public class MotionModelPanel
extends JPanel {
    private static final long serialVersionUID = 30906998503570435L;
    DefaultMutableTreeNode node = new DefaultMutableTreeNode("Motion model");
    final String singleMotionString = "Single motion model";
    final String multipleMotionString = "Multiple motion models";
    final JComboBox filtersBox = new JComboBox<String>(new String[]{"Single motion model", "Multiple motion models"});
    final SingleMotionPanel singleMotionPanel = new SingleMotionPanel();
    final MultipleMotionPanel multipleMotionPanel = new MultipleMotionPanel();
    final CardLayout motionCardLayout = new CardLayout();
    final JPanel motionModelPanel = new JPanel(this.motionCardLayout);

    public MotionModelPanel() {
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pane.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel mPanel = new JPanel(new BorderLayout());
        mPanel.add((Component)this.motionModelPanel, "Center");
        this.motionModelPanel.add((Component)this.singleMotionPanel, "Single motion model");
        this.motionModelPanel.add((Component)this.multipleMotionPanel, "Multiple motion models");
        this.filtersBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionModelPanel.this.motionCardLayout.show(MotionModelPanel.this.motionModelPanel, MotionModelPanel.this.filtersBox.getSelectedItem().toString());
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)this.filtersBox, c);
        ++c.gridy;
        pane.add((Component)mPanel, c);
        this.add((Component)pane, "North");
    }

    public boolean isSingleMotion() {
        return this.filtersBox.getSelectedIndex() == 0;
    }

    public void setSingleMotion(boolean isSingleMotion) {
        if (isSingleMotion) {
            this.filtersBox.setSelectedIndex(0);
        } else {
            this.filtersBox.setSelectedIndex(1);
        }
        this.motionCardLayout.show(this.motionModelPanel, this.filtersBox.getSelectedItem().toString());
    }

    public void saveToXML(Node node) {
        Element nodeMotionModel = XMLUtil.setElement((Node)node, (String)"motionModel");
        if (nodeMotionModel != null) {
            XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"isSingleMotion", (boolean)this.isSingleMotion());
            if (this.isSingleMotion()) {
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"yxDisplacement_1", (double)this.singleMotionPanel.getDisplacementXY());
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"zDisplacement_1", (double)this.singleMotionPanel.getDisplacementZ());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"updateMotion_1", (boolean)this.singleMotionPanel.isUpdateMotion());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"isDirectedMotion_1", (boolean)this.singleMotionPanel.isDirectedMotion());
            } else {
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"yxDisplacement_1", (double)this.multipleMotionPanel.getSingleMotionPanels().get(0).getDisplacementXY());
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"zDisplacement_1", (double)this.multipleMotionPanel.getSingleMotionPanels().get(0).getDisplacementZ());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"updateMotion_1", (boolean)this.multipleMotionPanel.getSingleMotionPanels().get(0).isUpdateMotion());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"isDirectedMotion_1", (boolean)this.multipleMotionPanel.getSingleMotionPanels().get(0).isDirectedMotion());
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"yxDisplacement_2", (double)this.multipleMotionPanel.getSingleMotionPanels().get(1).getDisplacementXY());
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"zDisplacement_2", (double)this.multipleMotionPanel.getSingleMotionPanels().get(1).getDisplacementZ());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"updateCovariance_2", (boolean)this.multipleMotionPanel.getSingleMotionPanels().get(1).isUpdateMotion());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"isDirectedMotion_2", (boolean)this.multipleMotionPanel.getSingleMotionPanels().get(1).isDirectedMotion());
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)"isMostLikelyModel", (boolean)this.multipleMotionPanel.isUseMostLikelyModel());
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)"IMMinertia", (double)this.multipleMotionPanel.getInertia());
            }
        }
    }

    public void loadFromFromXML(Node node) {
        Element nodeMotion = XMLUtil.getElement((Node)node, (String)"motionModel");
        if (nodeMotion != null) {
            boolean isSingleMotion = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"isSingleMotion", (boolean)true);
            this.setSingleMotion(isSingleMotion);
            if (isSingleMotion) {
                this.singleMotionPanel.setDisplacementXY(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"yxDisplacement_1", (double)3.0));
                this.singleMotionPanel.setDisplacementZ(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"zDisplacement_1", (double)3.0));
                this.singleMotionPanel.setUpdateMotion(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"updateMotion_1", (boolean)false));
                this.singleMotionPanel.setDirectedMotion(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"isDirectedMotion_1", (boolean)false));
            } else {
                SingleMotionPanel panel = this.multipleMotionPanel.getSingleMotionPanels().get(0);
                panel.setDisplacementXY(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"yxDisplacement_1", (double)panel.getDisplacementXY()));
                panel.setDisplacementZ(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"zDisplacement_1", (double)panel.getDisplacementZ()));
                panel.setUpdateMotion(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"updateMotion_1", (boolean)panel.isUpdateMotion()));
                panel.setDirectedMotion(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"isDirectedMotion_1", (boolean)panel.isDirectedMotion()));
                panel = this.multipleMotionPanel.getSingleMotionPanels().get(1);
                panel.setDisplacementXY(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"yxDisplacement_2", (double)panel.getDisplacementXY()));
                panel.setDisplacementZ(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"zDisplacement_2", (double)panel.getDisplacementZ()));
                panel.setUpdateMotion(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"updateCovariance_2", (boolean)panel.isUpdateMotion()));
                panel.setDirectedMotion(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"isDirectedMotion_1", (boolean)panel.isDirectedMotion()));
                this.multipleMotionPanel.useMostLikelyModelBox.setSelected(XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)"isMostLikelyModel", (boolean)this.multipleMotionPanel.isUseMostLikelyModel()));
                this.multipleMotionPanel.inertiaTF.setText(Double.toString(XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)"IMMinertia", (double)this.multipleMotionPanel.getInertia())));
            }
        }
    }

    public void fillParameterSet(MHTparameterSet parameterSet) {
        parameterSet.isSingleMotion = this.isSingleMotion();
        if (this.isSingleMotion()) {
            parameterSet.displacementXY = this.singleMotionPanel.getDisplacementXY();
            parameterSet.displacementZ = this.singleMotionPanel.getDisplacementZ();
            parameterSet.isDirectedMotion = this.singleMotionPanel.isDirectedMotion();
            parameterSet.isUpdateMotion = this.singleMotionPanel.isUpdateMotion();
        } else {
            parameterSet.displacementXY = this.multipleMotionPanel.getSingleMotionPanels().get(0).getDisplacementXY();
            parameterSet.displacementZ = this.multipleMotionPanel.getSingleMotionPanels().get(0).getDisplacementZ();
            parameterSet.isDirectedMotion = this.multipleMotionPanel.getSingleMotionPanels().get(0).isDirectedMotion();
            parameterSet.isUpdateMotion = this.multipleMotionPanel.getSingleMotionPanels().get(0).isUpdateMotion();
            parameterSet.displacementXY2 = this.multipleMotionPanel.getSingleMotionPanels().get(1).getDisplacementXY();
            parameterSet.displacementZ2 = this.multipleMotionPanel.getSingleMotionPanels().get(1).getDisplacementZ();
            parameterSet.isDirectedMotion2 = this.multipleMotionPanel.getSingleMotionPanels().get(1).isDirectedMotion();
            parameterSet.isUpdateMotion2 = this.multipleMotionPanel.getSingleMotionPanels().get(1).isUpdateMotion();
            parameterSet.useMostLikelyModel = this.multipleMotionPanel.isUseMostLikelyModel();
            parameterSet.immInertia = this.multipleMotionPanel.getInertia();
        }
    }

    public void setParameters(MHTparameterSet parameterSet) {
        this.setSingleMotion(parameterSet.isSingleMotion);
        if (parameterSet.isSingleMotion) {
            this.singleMotionPanel.setDisplacementXY(parameterSet.displacementXY);
            this.singleMotionPanel.setDisplacementZ(parameterSet.displacementZ);
            this.singleMotionPanel.setUpdateMotion(parameterSet.isUpdateMotion);
            this.singleMotionPanel.setDirectedMotion(parameterSet.isDirectedMotion);
        } else {
            SingleMotionPanel panel = this.multipleMotionPanel.getSingleMotionPanels().get(0);
            panel.setDisplacementXY(parameterSet.displacementXY);
            panel.setDisplacementZ(parameterSet.displacementZ);
            panel.setUpdateMotion(parameterSet.isUpdateMotion);
            panel.setDirectedMotion(parameterSet.isDirectedMotion);
            panel = this.multipleMotionPanel.getSingleMotionPanels().get(1);
            panel.setDisplacementXY(parameterSet.displacementXY2);
            panel.setDisplacementZ(parameterSet.displacementZ2);
            panel.setUpdateMotion(parameterSet.isUpdateMotion2);
            panel.setDirectedMotion(parameterSet.isDirectedMotion2);
            this.multipleMotionPanel.useMostLikelyModelBox.setSelected(parameterSet.useMostLikelyModel);
            this.multipleMotionPanel.inertiaTF.setText(Double.toString(parameterSet.immInertia));
        }
    }

    class KFDirectedPanel
    extends JPanel {
        private static final long serialVersionUID = 906775079141737670L;
        protected final JSpinner spinnerXYVelocity = new JSpinner();
        protected final JSpinner spinnerZVelocity = new JSpinner();
        final JLabel labelXYVelocity = new JLabel("Expected displacement length in the x-y plane");
        final JLabel lavelZVelocity = new JLabel("Expected displacement length along the z-axis");

        public KFDirectedPanel() {
            KFDirectedPanel pane = this;
            GridBagLayout gbl = new GridBagLayout();
            pane.setLayout(gbl);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            this.spinnerXYVelocity.setModel(new SpinnerNumberModel((Number)3.0, new Double(0.5), null, new Double(0.5)));
            JPanel spinnerXYPanel = new JPanel();
            spinnerXYPanel.setLayout(new GridLayout(2, 1, 0, 0));
            spinnerXYPanel.add(this.labelXYVelocity);
            spinnerXYPanel.add(this.spinnerXYVelocity);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)spinnerXYPanel, c);
            this.spinnerZVelocity.setModel(new SpinnerNumberModel((Number)3.0, new Double(0.5), null, new Double(0.5)));
            JPanel spinnerZPanel = new JPanel();
            spinnerZPanel.setLayout(new GridLayout(2, 1, 0, 0));
            spinnerZPanel.add(this.lavelZVelocity);
            spinnerZPanel.add(this.spinnerZVelocity);
            c.gridx = 0;
            c.gridy = 1;
            pane.add((Component)spinnerZPanel, c);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this.spinnerXYVelocity.setEnabled(enable);
            this.spinnerZVelocity.setEnabled(enable);
            this.labelXYVelocity.setEnabled(enable);
            this.lavelZVelocity.setEnabled(enable);
        }
    }

    class KFRandomWalkPanel
    extends JPanel {
        private static final long serialVersionUID = -4839850887184803243L;
        protected final JSpinner spinnerXYDisplacement = new JSpinner();
        protected final JSpinner spinnerZDisplacement = new JSpinner();

        public KFRandomWalkPanel() {
            KFRandomWalkPanel pane = this;
            GridBagLayout gbl = new GridBagLayout();
            pane.setLayout(gbl);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            this.spinnerXYDisplacement.setModel(new SpinnerNumberModel((Number)3.0, new Double(0.5), null, new Double(0.5)));
            JPanel spinnerXYPanel = new JPanel();
            spinnerXYPanel.setLayout(new GridLayout(2, 1, 0, 0));
            spinnerXYPanel.add(new JLabel("Expected displacement length in the x-y plane"));
            spinnerXYPanel.add(this.spinnerXYDisplacement);
            c.gridx = 0;
            c.gridy = 0;
            pane.add((Component)spinnerXYPanel, c);
            this.spinnerZDisplacement.setModel(new SpinnerNumberModel((Number)3.0, new Double(0.5), null, new Double(0.5)));
            JPanel spinnerZPanel = new JPanel();
            spinnerZPanel.setLayout(new GridLayout(2, 1, 0, 0));
            spinnerZPanel.add(new JLabel("Expected displacement length along the z-axis"));
            spinnerZPanel.add(this.spinnerZDisplacement);
            c.gridx = 0;
            c.gridy = 1;
            pane.add((Component)spinnerZPanel, c);
        }
    }

    public class MultipleMotionPanel
    extends JPanel {
        private static final long serialVersionUID = 3914304683158900923L;
        final JButton addNewModelButton = new JButton("Add a new model to the mixture");
        final JButton removeModelButton = new JButton("Remove the last model");
        final JPanel modelsPane = new JPanel();
        final JScrollPane scrollPane = new JScrollPane(this.modelsPane);
        ArrayList<SingleMotionPanel> motionPanels = new ArrayList();
        int indexQueue = -1;
        NumberFormat inertiaFormat = NumberFormat.getNumberInstance();
        protected final JFormattedTextField inertiaTF = new JFormattedTextField(this.inertiaFormat);
        JCheckBox useMostLikelyModelBox = new JCheckBox("Use most likely model");

        public MultipleMotionPanel() {
            this.setBorder(new TitledBorder("Multiple motion settings"));
            MultipleMotionPanel pane = this;
            GridBagLayout gbl = new GridBagLayout();
            pane.setLayout(gbl);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)new JLabel("Inertia for motion model switch:"), c);
            ++c.gridy;
            this.add((Component)this.inertiaTF, c);
            this.inertiaTF.setText(Double.toString(0.8));
            ++c.gridy;
            this.add((Component)this.useMostLikelyModelBox, c);
            this.useMostLikelyModelBox.setSelected(true);
            ++c.gridy;
            this.modelsPane.setLayout(new BoxLayout(this.modelsPane, 3));
            SingleMotionPanel motionPanel = new SingleMotionPanel();
            motionPanel.setDirectedMotion(false);
            this.motionPanels.add(motionPanel);
            this.modelsPane.add(motionPanel);
            ++this.indexQueue;
            motionPanel = new SingleMotionPanel();
            motionPanel.setDirectedMotion(true);
            this.motionPanels.add(motionPanel);
            this.modelsPane.add(motionPanel);
            ++this.indexQueue;
            this.scrollPane.setPreferredSize(new Dimension(200, 400));
            this.add((Component)this.scrollPane, c);
        }

        public ArrayList<SingleMotionPanel> getSingleMotionPanels() {
            return new ArrayList<SingleMotionPanel>(this.motionPanels);
        }

        public double getInertia() {
            try {
                return this.inertiaFormat.parse(this.inertiaTF.getText()).doubleValue();
            }
            catch (ParseException e) {
                new AnnounceFrame("Invalid inertia value. Using default value:0.8");
                return 0.8;
            }
        }

        public boolean isUseMostLikelyModel() {
            return this.useMostLikelyModelBox.isSelected();
        }
    }

    public class SingleMotionPanel
    extends JPanel {
        private static final long serialVersionUID = 3216670506933002101L;
        final KFRandomWalkPanel diffusionPanel;
        final KFDirectedPanel directedPanel;
        final JCheckBox useDirectedMotionBox;
        final JCheckBox displacementReestimateBox;

        public SingleMotionPanel() {
            this.diffusionPanel = new KFRandomWalkPanel();
            this.directedPanel = new KFDirectedPanel();
            this.useDirectedMotionBox = new JCheckBox("Use directed motion");
            this.displacementReestimateBox = new JCheckBox("Re-estimate motion length online");
            SingleMotionPanel pane = this;
            GridBagLayout gbl = new GridBagLayout();
            pane.setLayout(gbl);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            this.diffusionPanel.setBorder(new TitledBorder("Diffusion"));
            pane.add((Component)this.diffusionPanel, c);
            c.gridx = 0;
            c.gridy = 1;
            this.useDirectedMotionBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SingleMotionPanel.this.directedPanel.setEnabled(SingleMotionPanel.this.useDirectedMotionBox.isSelected());
                }
            });
            this.useDirectedMotionBox.setSelected(false);
            this.directedPanel.setEnabled(this.useDirectedMotionBox.isSelected());
            pane.add((Component)this.useDirectedMotionBox, c);
            c.gridx = 0;
            c.gridy = 2;
            this.directedPanel.setBorder(new TitledBorder("Directed motion"));
            pane.add((Component)this.directedPanel, c);
            c.gridx = 0;
            c.gridy = 3;
            this.displacementReestimateBox.setSelected(false);
            pane.add((Component)this.displacementReestimateBox, c);
            this.setBorder(new TitledBorder("Motion settings"));
        }

        public boolean isDirectedMotion() {
            return this.useDirectedMotionBox.isSelected();
        }

        public void setDirectedMotion(boolean isDirectedMotion) {
            this.useDirectedMotionBox.setSelected(isDirectedMotion);
            this.directedPanel.setEnabled(this.useDirectedMotionBox.isSelected());
        }

        public double getDisplacementXY() {
            return ((SpinnerNumberModel)this.diffusionPanel.spinnerXYDisplacement.getModel()).getNumber().doubleValue();
        }

        public void setDisplacementXY(double d) {
            ((SpinnerNumberModel)this.diffusionPanel.spinnerXYDisplacement.getModel()).setValue(d);
        }

        public double getDisplacementZ() {
            return ((SpinnerNumberModel)this.diffusionPanel.spinnerZDisplacement.getModel()).getNumber().doubleValue();
        }

        public void setDisplacementZ(double d) {
            ((SpinnerNumberModel)this.diffusionPanel.spinnerZDisplacement.getModel()).setValue(d);
        }

        public boolean isUpdateMotion() {
            return this.displacementReestimateBox.isSelected();
        }

        public void setUpdateMotion(boolean isUpdateMotion) {
            this.displacementReestimateBox.setSelected(isUpdateMotion);
        }
    }
}

