/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import java.util.ArrayList;
import plugins.fab.spotDetector.Point3D;

public class DetectionSpot {
    Point3D massCenter = null;
    public ArrayList<Point3D> points = new ArrayList();
    public double meanIntensity = 0.0;
    public double minIntensity;
    public double maxIntensity;
    int t;

    public void setT(int t) {
        this.t = t;
    }

    public Point3D getMassCenter() {
        if (this.massCenter == null) {
            this.computeMassCenter();
        }
        return this.massCenter;
    }

    public int getT() {
        return this.t;
    }

    public void computeMassCenter() {
        this.massCenter = new Point3D();
        if (this.points.size() == 0) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Point3D p : this.points) {
            x += p.x;
            y += p.y;
            z += p.z;
        }
        this.massCenter.x = x /= (double)this.points.size();
        this.massCenter.y = y /= (double)this.points.size();
        this.massCenter.z = z /= (double)this.points.size();
    }

    public void setMassCenter(Point3D point3d) {
        this.massCenter.x = point3d.x;
        this.massCenter.y = point3d.y;
        this.massCenter.z = point3d.z;
    }
}

