/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.system.thread.ThreadUtil;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class ARGBImageBuilder {
    private static final int BLOC_SIZE = 262144;
    private final Processor processor = SystemUtil.is32bits() ? new Processor(Math.max(1, Math.min(SystemUtil.getNumberOfCPUs() - 1, 4))) : new Processor(Math.max(1, Math.min(SystemUtil.getNumberOfCPUs() - 1, 16)));
    private final List<int[][]> buffers;

    public ARGBImageBuilder() {
        this.processor.setThreadName("ARGB Image builder");
        this.processor.setPriority(4);
        this.buffers = new ArrayList<int[][]>();
    }

    private static BufferedImage getImage(IcyBufferedImage in, BufferedImage out) {
        if (out != null && ImageUtil.sameSize(in, out)) {
            return out;
        }
        return new BufferedImage(in.getWidth(), in.getHeight(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[][] requestBuffer(int numChannel) {
        if (numChannel <= 0) {
            return null;
        }
        List<int[][]> list = this.buffers;
        synchronized (list) {
            for (int index = this.buffers.size() - 1; index >= 0; --index) {
                if (this.buffers.get(index).length != numChannel) continue;
                return this.buffers.remove(index);
            }
        }
        return new int[numChannel][262144];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBuffer(int[][] buffer) {
        if (buffer == null) {
            return;
        }
        List<int[][]> list = this.buffers;
        synchronized (list) {
            this.buffers.add(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage buildARGBImage(IcyBufferedImage image, LUT lut, BufferedImage out) {
        int imageSize = image.getSizeX() * image.getSizeY();
        int step = imageSize / 262144;
        BufferedImage result = ARGBImageBuilder.getImage(image, out);
        int[] dest = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        ArrayList futures = new ArrayList();
        int offset = 0;
        try {
            for (int i = 0; i < step; ++i) {
                futures.add(this.addBloc(image, lut, dest, offset, 262144));
                offset += 262144;
            }
            if (offset < imageSize) {
                futures.add(this.addBloc(image, lut, dest, offset, imageSize - offset));
            }
            this.waitCompletion(futures);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List<int[][]> list = this.buffers;
        synchronized (list) {
            this.buffers.clear();
        }
        return result;
    }

    public BufferedImage buildARGBImage(IcyBufferedImage image, LUT lut) {
        return this.buildARGBImage(image, lut, null);
    }

    private Future<?> addBloc(IcyBufferedImage image, LUT lut, int[] dest, int offset, int length) {
        BlockBuilder builder = new BlockBuilder(image, lut, dest, offset, length);
        Future<?> result = this.processor.submit(builder);
        while (result == null) {
            ThreadUtil.sleep(1);
            result = this.processor.submit(builder);
        }
        return result;
    }

    private void waitCompletion(List<Future<?>> futures) {
        while (!futures.isEmpty()) {
            Future<?> f = futures.get(futures.size() - 1);
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("ARGBImageBuilder - Warning: " + e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futures.remove(f);
        }
    }

    public boolean isProcessing() {
        return this.processor.isProcessing();
    }

    public void waitCompletion() {
        this.processor.waitAll();
    }

    class BlockBuilder
    implements Runnable {
        private IcyBufferedImage image;
        private LUT lut;
        private int[] dest;
        private int offset;
        private int length;
        private int numChannel;

        BlockBuilder(IcyBufferedImage image, LUT lut, int[] dest, int offset, int length) {
            this.image = image;
            this.lut = lut == null ? image.createCompatibleLUT(false) : lut;
            this.dest = dest;
            this.offset = offset;
            this.length = length;
            this.numChannel = image.getSizeC();
            if (this.lut.getNumChannel() != this.numChannel) {
                throw new IllegalArgumentException("ARGBImageBuilder.prepare(...): LUT.numChannel != IMAGE.numChannel");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int[][] componentValues = null;
            try {
                componentValues = ARGBImageBuilder.this.requestBuffer(this.numChannel);
                if (componentValues != null) {
                    Scaler[] scalers = this.lut.getScalers();
                    boolean signed = this.image.getIcyColorModel().getDataType_().isSigned();
                    for (int comp = 0; comp < this.numChannel; ++comp) {
                        scalers[comp].scale(this.image.getDataXY(comp), this.offset, componentValues[comp], 0, this.length, signed);
                    }
                    this.lut.getColorSpace().fillARGBBuffer(componentValues, this.dest, this.offset, this.length);
                }
            }
            catch (Exception exception) {
            }
            finally {
                ARGBImageBuilder.this.releaseBuffer(componentValues);
            }
        }
    }
}

