/*
 * Decompiled with CFR 0.152.
 */
package icy.imagej;

import icy.gui.main.MainFrame;
import icy.gui.util.SwingUtil;
import icy.imagej.ToolbarWrapper;
import icy.main.Icy;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.ReflectionUtil;
import ij.ImageJ;
import ij.gui.ImageWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ImageJWrapper
extends ImageJ {
    private static final long serialVersionUID = -4361946959228494782L;
    public static final String PROPERTY_MENU = "menu";
    final JPanel swingPanel = new JPanel();
    JMenuBar swingMenuBar;
    final JPanel swingStatusPanel;
    final JLabel swingStatusLabel;
    final JProgressBar swingProgressBar;
    ToolbarWrapper swingToolBar;
    final List<ImageJActiveImageListener> listeners;
    MenuBar menuBarSave;

    public ImageJWrapper() {
        super(2);
        this.swingPanel.setLayout(new BorderLayout());
        this.swingMenuBar = null;
        this.updateMenu();
        this.swingToolBar = new ToolbarWrapper(this);
        this.swingPanel.add((Component)this.swingToolBar.getSwingComponent(), "Center");
        try {
            ReflectionUtil.getField(this.getClass(), "toolbar", true).set(this, this.swingToolBar);
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false);
            System.err.println("Cannot install ImageJ toolbar wrapper");
        }
        this.swingStatusPanel = new JPanel();
        this.swingStatusPanel.setLayout(new BorderLayout());
        this.swingStatusLabel = new JLabel();
        this.swingStatusLabel.setPreferredSize(new Dimension(420, 24));
        this.swingStatusLabel.setMaximumSize(new Dimension(420, 24));
        this.swingStatusLabel.setFocusable(true);
        this.swingStatusLabel.addKeyListener(this);
        this.swingStatusLabel.addMouseListener(this);
        this.swingStatusPanel.add((Component)this.swingStatusLabel, "Center");
        this.swingProgressBar = new JProgressBar(0, 1000);
        this.swingProgressBar.setBorder(BorderFactory.createEmptyBorder());
        this.swingProgressBar.setFocusable(true);
        this.swingProgressBar.setPreferredSize(new Dimension(120, 20));
        this.swingProgressBar.setMaximumSize(new Dimension(120, 20));
        this.swingProgressBar.setValue(1000);
        this.swingProgressBar.addKeyListener(this);
        this.swingProgressBar.addMouseListener(this);
        this.swingStatusPanel.add((Component)this.swingProgressBar, "East");
        this.swingPanel.add((Component)this.swingStatusPanel, "South");
        this.swingToolBar.setVisible(false);
        this.swingPanel.add((Component)this.swingToolBar, "East");
        this.swingPanel.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() == ImageJWrapper.this.swingToolBar) {
                    ImageJWrapper.this.swingPanel.remove(ImageJWrapper.this.swingToolBar.getSwingComponent());
                }
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() == ImageJWrapper.this.swingToolBar) {
                    ImageJWrapper.this.swingPanel.add(ImageJWrapper.this.swingToolBar.getSwingComponent());
                }
            }
        });
        this.swingPanel.validate();
        this.listeners = new ArrayList<ImageJActiveImageListener>();
    }

    @Override
    public void removeNotify() {
        if (SystemUtil.isUnix()) {
            this.swingPanel.remove(this.swingToolBar);
        }
        super.removeNotify();
    }

    void updateMenu() {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImageJWrapper.this.swingPanel != null) {
                    if (ImageJWrapper.this.swingMenuBar != null) {
                        ImageJWrapper.this.swingPanel.remove(ImageJWrapper.this.swingMenuBar);
                    }
                    ImageJWrapper.this.swingMenuBar = SwingUtil.getJMenuBar(ImageJWrapper.this.menuBarSave, true);
                    ImageJWrapper.this.swingPanel.add((Component)ImageJWrapper.this.swingMenuBar, "North");
                    ImageJWrapper.this.swingPanel.validate();
                }
            }
        }, true);
    }

    public void setActiveImage(ImageWindow iw) {
        this.fireActiveImageChanged(iw);
    }

    public void showSwingProgress(final int currentIndex, final int finalIndex) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                BoundedRangeModel model = ImageJWrapper.this.swingProgressBar.getModel();
                model.setMaximum(finalIndex);
                model.setValue(currentIndex);
            }
        });
    }

    public void showSwingStatus(String s) {
        this.swingStatusLabel.setText(s);
    }

    public JMenuBar getSwingMenuBar() {
        return this.swingMenuBar;
    }

    public JPanel getSwingPanel() {
        return this.swingPanel;
    }

    public JPanel getSwingStatusPanel() {
        return this.swingStatusPanel;
    }

    public JLabel getSwingStatusLabel() {
        return this.swingStatusLabel;
    }

    public JProgressBar getSwingProgressBar() {
        return this.swingProgressBar;
    }

    public void menuChanged() {
        this.updateMenu();
    }

    @Override
    public Point getLocationOnScreen() {
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        if (mainFrame != null) {
            return mainFrame.getLocationOnScreen();
        }
        return new Point(0, 0);
    }

    @Override
    public void setMenuBar(MenuBar mb) {
        this.menuBarSave = mb;
        this.menuChanged();
    }

    @Override
    public Image createImage(int width, int height) {
        return this.swingPanel.createImage(width, height);
    }

    public void addActiveImageListener(ImageJActiveImageListener listener) {
        this.listeners.add(listener);
    }

    public void removeActiveImageListener(ImageJActiveImageListener listener) {
        this.listeners.remove(listener);
    }

    public void fireActiveImageChanged(ImageWindow iw) {
        for (ImageJActiveImageListener listener : this.listeners) {
            listener.imageActived(iw);
        }
    }

    public static interface ImageJActiveImageListener {
        public void imageActived(ImageWindow var1);
    }
}

