/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.BooleanMask2D;
import icy.roi.edit.AbstractROIEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class Area2DChangeROIEdit
extends AbstractROIEdit {
    BooleanMask2D oldMask;
    BooleanMask2D newMask;

    public Area2DChangeROIEdit(ROI2DArea roi, BooleanMask2D oldMask, String name) {
        super(roi, name);
        this.oldMask = oldMask;
        this.newMask = roi.getBooleanMask(true);
    }

    public Area2DChangeROIEdit(ROI2DArea roi, BooleanMask2D oldMask) {
        this(roi, oldMask, "ROI mask changed");
    }

    public ROI2DArea getROI2DArea() {
        return (ROI2DArea)this.source;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.getROI2DArea().setAsBooleanMask(this.oldMask);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.getROI2DArea().setAsBooleanMask(this.newMask);
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.oldMask = null;
        this.newMask = null;
    }
}

