/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.system.IcyExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class XLSUtil {
    public static final String FILE_EXTENSION = "xls";
    public static final String FILE_DOT_EXTENSION = ".xls";

    public static WritableWorkbook createWorkbook(File file) throws IOException {
        return Workbook.createWorkbook((File)file);
    }

    public static WritableWorkbook createWorkbook(String filename) throws IOException {
        return XLSUtil.createWorkbook(new File(filename));
    }

    public static Workbook loadWorkbookForRead(File file) throws IOException, BiffException {
        return Workbook.getWorkbook((File)file);
    }

    public static WritableWorkbook loadWorkbookForWrite(File file) throws IOException, BiffException {
        if (!file.exists()) {
            return XLSUtil.createWorkbook(file);
        }
        return Workbook.createWorkbook((File)file, (Workbook)Workbook.getWorkbook((File)file));
    }

    @Deprecated
    public static WritableWorkbook loadWorkbook(File file) throws IOException, BiffException {
        if (!file.exists()) {
            return XLSUtil.createWorkbook(file);
        }
        WritableWorkbook result = Workbook.createWorkbook((File)file, (Workbook)Workbook.getWorkbook((File)file));
        result.write();
        return result;
    }

    public static void saveAndClose(WritableWorkbook workbook) throws IOException, WriteException {
        workbook.write();
        workbook.close();
    }

    public static WritableSheet getPage(WritableWorkbook workbook, String title) {
        WritableSheet result = workbook.getSheet(title);
        if (result == null) {
            result = workbook.createSheet(title, workbook.getNumberOfSheets() + 1);
        }
        return result;
    }

    public static WritableSheet createNewPage(WritableWorkbook workbook, String title) {
        if (workbook.getSheet(title) == null) {
            return workbook.createSheet(title, workbook.getNumberOfSheets() + 1);
        }
        int counter = 2;
        String pageName;
        while (workbook.getSheet(pageName = title + " " + counter) != null) {
            ++counter;
        }
        return workbook.createSheet(pageName, workbook.getNumberOfSheets() + 1);
    }

    public static void clear(WritableWorkbook workbook) {
        while (workbook.getNumberOfSheets() > 0) {
            workbook.removeSheet(workbook.getNumberOfSheets() - 1);
        }
    }

    public static void clearPage(WritableSheet sheet, String name) {
        while (sheet.getRows() > 0) {
            sheet.removeRow(sheet.getRows() - 1);
        }
    }

    public static void setPageName(WritableSheet sheet, String name) {
        sheet.setName(name);
    }

    public static boolean addImage(WritableSheet sheet, WritableImage image) {
        try {
            sheet.addImage(image);
            return true;
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return false;
        }
    }

    public static boolean setCellString(WritableSheet sheet, int x, int y, String value, Colour background) {
        WritableCellFormat wcf = new WritableCellFormat();
        try {
            wcf.setBackground(background);
        }
        catch (WriteException e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
        }
        Label label = new Label(x, y, value, (CellFormat)wcf);
        try {
            sheet.addCell((WritableCell)label);
            return true;
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return false;
        }
    }

    public static boolean setCellString(WritableSheet sheet, int x, int y, String value) {
        Label label = new Label(x, y, value);
        try {
            sheet.addCell((WritableCell)label);
            return true;
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return false;
        }
    }

    public static boolean setCellNumber(WritableSheet sheet, int x, int y, double value, Colour background) {
        WritableCellFormat wcf = new WritableCellFormat();
        try {
            wcf.setBackground(background);
        }
        catch (WriteException e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
        }
        Number number = new Number(x, y, value, (CellFormat)wcf);
        try {
            sheet.addCell((WritableCell)number);
            return true;
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return false;
        }
    }

    public static boolean setCellNumber(WritableSheet sheet, int x, int y, double value) {
        Number number = new Number(x, y, value);
        try {
            sheet.addCell((WritableCell)number);
            return true;
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return false;
        }
    }

    public static boolean setFromCSV(WritableSheet sheet, String csvContent) {
        BufferedReader br = new BufferedReader(new StringReader(csvContent));
        int y = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int x = 0;
                for (String col : line.split("\t")) {
                    XLSUtil.setCellString(sheet, x, y, col);
                    ++x;
                }
                ++y;
            }
            return true;
        }
        catch (IOException e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return false;
        }
    }
}

