/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScope;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPUtil;

@Immutable
public abstract class HTTPAuthUtil {
    static boolean authscopeCompatible(AuthScope ss, AuthScope ms) {
        String mss;
        assert (ss.getScheme() != null && ms.getScheme() != null);
        if (!ss.getHost().equalsIgnoreCase(ms.getHost())) {
            return false;
        }
        if (ss.getPort() != ms.getPort()) {
            return false;
        }
        String sss = ss.getScheme().toLowerCase();
        if (!sss.equals(mss = ms.getScheme().toLowerCase())) {
            if (sss.endsWith("s")) {
                sss = sss.substring(0, sss.length() - 1);
            }
            if (mss.endsWith("s")) {
                mss = mss.substring(0, mss.length() - 1);
            }
            if (!sss.equals(mss)) {
                return false;
            }
        }
        return true;
    }

    static AuthScope authscopeUpgrade(AuthScope ss, AuthScope ms) {
        assert (HTTPAuthUtil.authscopeCompatible(ss, ms));
        String sss = ss.getScheme().toLowerCase();
        String mss = ms.getScheme().toLowerCase();
        String upgrade = sss;
        if (sss.startsWith("http") && mss.startsWith("http") && (sss.equals("https") || mss.equals("https"))) {
            upgrade = "https";
        }
        AuthScope host = new AuthScope(ss.getHost(), ss.getPort(), AuthScope.ANY_REALM, upgrade);
        return host;
    }

    static AuthScope uriToAuthScope(String surl) throws HTTPException {
        try {
            URI uri = HTTPUtil.parseToURI(surl);
            return HTTPAuthUtil.uriToAuthScope(uri);
        }
        catch (URISyntaxException e) {
            throw new HTTPException(e);
        }
    }

    static AuthScope uriToAuthScope(URI uri) {
        assert (uri != null);
        return new AuthScope(uri.getHost(), uri.getPort(), AuthScope.ANY_REALM, uri.getScheme());
    }

    static URI authscopeToURI(AuthScope authScope) throws HTTPException {
        try {
            URI url = new URI(authScope.getScheme(), null, authScope.getHost(), authScope.getPort(), "", null, null);
            return url;
        }
        catch (URISyntaxException mue) {
            throw new HTTPException(mue);
        }
    }

    static HttpHost authscopeToHost(AuthScope scope) {
        return new HttpHost(scope.getHost(), scope.getPort(), scope.getScheme());
    }

    static AuthScope hostToAuthScope(HttpHost host) {
        return new AuthScope(host.getHostName(), host.getPort(), AuthScope.ANY_REALM, host.getSchemeName());
    }

    public static AuthScope bestmatch(AuthScope scope, Set<AuthScope> scopelist) {
        Object creds = null;
        int bestMatchFactor = -1;
        AuthScope bestMatch = null;
        for (AuthScope current : scopelist) {
            int factor = scope.match(current);
            if (factor <= bestMatchFactor) continue;
            bestMatchFactor = factor;
            bestMatch = current;
        }
        return bestMatch;
    }
}

