/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker;

import icy.file.Loader;
import icy.file.Saver;
import icy.gui.main.GlobalSequenceListener;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.nchenouard.kymographtracker.KymographTrackingResults;

public class KymographExtractionResult
implements SequenceListener,
GlobalSequenceListener {
    ROI roi;
    Sequence sourceSequence;
    private Sequence kymograph;
    private Sequence anterogradeKymograph;
    private Sequence retrogradeKymograph;
    ArrayList<ROI> kymoROIs = new ArrayList();
    ArrayList<ROI> anteroKymoROIs = new ArrayList();
    ArrayList<ROI> retroKymoROIs = new ArrayList();
    boolean anterogradeRetrogradeSeparation;
    ArrayList<double[]> samplingPositions;
    KymographTrackingResults trackingResults;
    KymographTrackingResults anterogradeTrackingResults;
    KymographTrackingResults retrogradeTrackingResults;
    public static String KYMO_RESULT = "KymographTrackingResults";
    public static String SEQUENCE_NAME = "SequenceName";
    public static String SAMPLING_POSITIONS = "SamplingPositions";
    public static String SAMPLING_X = "SamplingPositionsX";
    public static String SAMPLING_Y = "SamplingPositionsY";
    public static String IS_ANTERO_RETRO_SPLIT = "AnteroRetroSplit";
    public static String BIDIRECTIONAL_TRACKING = "BidirectionalTracking";
    public static String ANTEROGRADE_TRACKING = "AnterogradeTracking";
    public static String RETROGRADE_TRACKING = "RetrogradeTracking";
    public static String TRACKING_RESULTS = "KymoTrackingResults";
    public static String KYMO_SEQUENCE_NAME = "KymoSequenceName";
    public static String NULL_ELEMENT = "null";

    public KymographExtractionResult() {
        Icy.getMainInterface().addGlobalSequenceListener((GlobalSequenceListener)this);
    }

    public void saveToXML(Element node, File saveDir, int idx) {
        Element nodeKymoResults = XMLUtil.addElement((Node)node, (String)KYMO_RESULT);
        if (this.sourceSequence == null || this.sourceSequence.getName() == null) {
            XMLUtil.setAttributeValue((Element)nodeKymoResults, (String)SEQUENCE_NAME, (String)NULL_ELEMENT);
        } else {
            XMLUtil.setAttributeValue((Element)nodeKymoResults, (String)SEQUENCE_NAME, (String)this.sourceSequence.getName());
        }
        XMLUtil.setAttributeBooleanValue((Element)nodeKymoResults, (String)IS_ANTERO_RETRO_SPLIT, (boolean)this.anterogradeRetrogradeSeparation);
        Element samplingNode = XMLUtil.setElement((Node)nodeKymoResults, (String)SAMPLING_POSITIONS);
        String samplingPos = "";
        for (double[] d : this.samplingPositions) {
            samplingPos = samplingPos.concat(Double.toString(d[0]) + ", ");
        }
        XMLUtil.setAttributeValue((Element)samplingNode, (String)SAMPLING_X, (String)samplingPos);
        samplingPos = "";
        for (double[] d : this.samplingPositions) {
            samplingPos = samplingPos.concat(Double.toString(d[1]) + ", ");
        }
        XMLUtil.setAttributeValue((Element)samplingNode, (String)SAMPLING_Y, (String)samplingPos);
        Element bidirectionalNode = XMLUtil.setElement((Node)nodeKymoResults, (String)BIDIRECTIONAL_TRACKING);
        if (this.kymograph == null || this.kymograph.getName() == null) {
            XMLUtil.setAttributeValue((Element)bidirectionalNode, (String)KYMO_SEQUENCE_NAME, (String)NULL_ELEMENT);
        } else if (this.kymograph.getFilename() == null || this.kymograph.getFilename().isEmpty()) {
            File fKymo = new File(saveDir.getAbsolutePath().concat("/" + this.sourceSequence.getName() + "_kymo" + idx + ".tif"));
            Saver.save((Sequence)this.kymograph, (File)fKymo);
            XMLUtil.setAttributeValue((Element)bidirectionalNode, (String)KYMO_SEQUENCE_NAME, (String)fKymo.getName());
        }
        if (this.trackingResults == null) {
            KymographTrackingResults.generateDefaultNode(bidirectionalNode);
        } else {
            this.trackingResults.saveToXML(bidirectionalNode);
        }
        Element anterogradeNode = XMLUtil.setElement((Node)nodeKymoResults, (String)ANTEROGRADE_TRACKING);
        if (this.anterogradeKymograph == null || this.anterogradeKymograph.getName() == null) {
            XMLUtil.setAttributeValue((Element)anterogradeNode, (String)KYMO_SEQUENCE_NAME, (String)NULL_ELEMENT);
        } else {
            File fKymo = new File(saveDir.getAbsolutePath().concat("/" + this.sourceSequence.getName() + "_anteroKymo.tif"));
            Saver.save((Sequence)this.anterogradeKymograph, (File)fKymo);
            XMLUtil.setAttributeValue((Element)anterogradeNode, (String)KYMO_SEQUENCE_NAME, (String)fKymo.getName());
        }
        if (this.anterogradeTrackingResults == null) {
            KymographTrackingResults.generateDefaultNode(anterogradeNode);
        } else {
            this.anterogradeTrackingResults.saveToXML(anterogradeNode);
        }
        Element retrogradeNode = XMLUtil.setElement((Node)nodeKymoResults, (String)RETROGRADE_TRACKING);
        if (this.retrogradeKymograph == null || this.retrogradeKymograph.getName() == null) {
            XMLUtil.setAttributeValue((Element)retrogradeNode, (String)KYMO_SEQUENCE_NAME, (String)NULL_ELEMENT);
        } else {
            File fKymo = new File(saveDir.getAbsolutePath().concat("/" + this.sourceSequence.getName() + "_retroKymo.tif"));
            Saver.save((Sequence)this.retrogradeKymograph, (File)fKymo);
            XMLUtil.setAttributeValue((Element)retrogradeNode, (String)KYMO_SEQUENCE_NAME, (String)fKymo.getName());
        }
        if (this.retrogradeTrackingResults == null) {
            KymographTrackingResults.generateDefaultNode(retrogradeNode);
        } else {
            this.retrogradeTrackingResults.saveToXML(retrogradeNode);
        }
    }

    public static ArrayList<KymographExtractionResult> loadResultsFromXML(Element resultsElement, Sequence sourceSequence, File resultsDir) {
        ArrayList<KymographExtractionResult> results = new ArrayList<KymographExtractionResult>();
        ArrayList elements = XMLUtil.getElements((Node)resultsElement, (String)KYMO_RESULT);
        for (Element e : elements) {
            ArrayList<Point2D.Double> samplingPositionList;
            KymographExtractionResult r = new KymographExtractionResult();
            r.sourceSequence = sourceSequence;
            r.anterogradeRetrogradeSeparation = XMLUtil.getAttributeBooleanValue((Element)e, (String)IS_ANTERO_RETRO_SPLIT, (boolean)r.anterogradeRetrogradeSeparation);
            Element samplingNode = XMLUtil.getElement((Node)e, (String)SAMPLING_POSITIONS);
            if (samplingNode != null) {
                String samplingPos = XMLUtil.getAttributeValue((Element)samplingNode, (String)SAMPLING_X, (String)"");
                String[] ss = samplingPos.split(",");
                ArrayList<Double> xList = new ArrayList<Double>();
                for (int i = 0; i < ss.length; ++i) {
                    if (ss[i].trim().isEmpty()) continue;
                    xList.add(Double.valueOf(ss[i]));
                }
                samplingPos = XMLUtil.getAttributeValue((Element)samplingNode, (String)SAMPLING_Y, (String)"");
                ss = samplingPos.split(",");
                ArrayList<Double> yList = new ArrayList<Double>();
                for (int i = 0; i < ss.length; ++i) {
                    if (ss[i].trim().isEmpty()) continue;
                    yList.add(Double.valueOf(ss[i]));
                }
                r.samplingPositions = new ArrayList();
                samplingPositionList = new ArrayList<Point2D.Double>();
                for (int i = 0; i < xList.size(); ++i) {
                    r.samplingPositions.add(new double[]{(Double)xList.get(i), (Double)yList.get(i)});
                    samplingPositionList.add(new Point2D.Double((Double)xList.get(i), (Double)yList.get(i)));
                }
            } else {
                System.out.println("Could not load sampling positions for for KymographExtractionResult object, node " + SAMPLING_POSITIONS + " not found in XML tree");
                return null;
            }
            ROI2DPolyLine roi = new ROI2DPolyLine(samplingPositionList);
            r.roi = roi;
            sourceSequence.addROI(r.roi);
            Element bidirectionalNode = XMLUtil.getElement((Node)e, (String)BIDIRECTIONAL_TRACKING);
            if (bidirectionalNode != null) {
                String kymoSequenceName = XMLUtil.getAttributeValue((Element)bidirectionalNode, (String)KYMO_SEQUENCE_NAME, (String)NULL_ELEMENT);
                if (!kymoSequenceName.equals(NULL_ELEMENT)) {
                    Sequence kymoSequence = Loader.loadSequence((String)(resultsDir.getAbsolutePath() + "/" + kymoSequenceName), (int)0, (boolean)true);
                    r.setKymograph(kymoSequence);
                    r.roi.setName(kymoSequenceName);
                }
                r.trackingResults = KymographTrackingResults.loadFromXML(bidirectionalNode, sourceSequence, r.roi.getName() + "_tracks");
            } else {
                System.out.println("Could not load bidirectional results for KymographExtractionResult object, node " + BIDIRECTIONAL_TRACKING + " not found in XML tree");
            }
            Element anterogradeNode = XMLUtil.getElement((Node)e, (String)ANTEROGRADE_TRACKING);
            if (anterogradeNode != null) {
                String kymoSequenceName = XMLUtil.getAttributeValue((Element)anterogradeNode, (String)KYMO_SEQUENCE_NAME, (String)NULL_ELEMENT);
                if (!kymoSequenceName.equals(NULL_ELEMENT)) {
                    r.setAnterogradeKymograph(Loader.loadSequence((String)(resultsDir.getAbsolutePath() + "/" + kymoSequenceName), (int)0, (boolean)true));
                    r.roi.setName(kymoSequenceName);
                }
                r.anterogradeTrackingResults = KymographTrackingResults.loadFromXML(anterogradeNode, sourceSequence, "anterogradeKymoTracks");
            } else {
                System.out.println("Could not load anterograde results for KymographExtractionResult object, node " + ANTEROGRADE_TRACKING + " not found in XML tree");
            }
            Element retrogradeNode = XMLUtil.getElement((Node)e, (String)RETROGRADE_TRACKING);
            if (retrogradeNode != null) {
                String kymoSequenceName = XMLUtil.getAttributeValue((Element)retrogradeNode, (String)KYMO_SEQUENCE_NAME, (String)NULL_ELEMENT);
                if (!kymoSequenceName.equals(NULL_ELEMENT)) {
                    r.setRetrogradeKymograph(Loader.loadSequence((String)(resultsDir.getAbsolutePath() + "/" + kymoSequenceName), (int)0, (boolean)true));
                    r.roi.setName(kymoSequenceName);
                }
                r.retrogradeTrackingResults = KymographTrackingResults.loadFromXML(retrogradeNode, sourceSequence, "retrogradeKymoTracks");
            } else {
                System.out.println("Could not load retrograde results for KymographExtractionResult object, node " + RETROGRADE_TRACKING + " not found in XML tree");
            }
            results.add(r);
        }
        return results;
    }

    public Sequence getKymograph() {
        return this.kymograph;
    }

    public void setKymograph(Sequence kymograph) {
        this.kymoROIs.clear();
        this.kymograph = kymograph;
        if (this.kymograph != null) {
            this.kymograph.addListener((SequenceListener)this);
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI && (sequenceEvent.getType() == SequenceEvent.SequenceEventType.ADDED || sequenceEvent.getType() == SequenceEvent.SequenceEventType.REMOVED)) {
            Sequence sequence = sequenceEvent.getSequence();
            if (sequence == this.kymograph) {
                this.kymoROIs.clear();
                this.kymoROIs.addAll(sequence.getROI2Ds());
            }
            if (sequence == this.anterogradeKymograph) {
                this.anteroKymoROIs.clear();
                this.anteroKymoROIs.addAll(sequence.getROIs());
            }
            if (sequence == this.retrogradeKymograph) {
                this.retroKymoROIs.clear();
                this.retroKymoROIs.addAll(sequence.getROIs());
            }
        }
    }

    public void sequenceClosed(Sequence sequence) {
    }

    public Sequence getAnterogradeKymograph() {
        return this.anterogradeKymograph;
    }

    public void setAnterogradeKymograph(Sequence anterogradeKymograph) {
        this.anteroKymoROIs.clear();
        this.anterogradeKymograph = anterogradeKymograph;
        if (this.anterogradeKymograph != null) {
            this.anterogradeKymograph.addListener((SequenceListener)this);
        }
    }

    public Sequence getRetrogradeKymograph() {
        return this.retrogradeKymograph;
    }

    public void setRetrogradeKymograph(Sequence retrogradeKymograph) {
        this.retroKymoROIs.clear();
        this.retrogradeKymograph = retrogradeKymograph;
        if (this.retrogradeKymograph != null) {
            this.retrogradeKymograph.addListener((SequenceListener)this);
        }
    }

    public void sequenceOpened(Sequence sequence) {
        if (sequence != null) {
            ArrayList<ROI> toAddRois;
            ArrayList currentRois;
            if (sequence == this.kymograph) {
                currentRois = sequence.getROIs();
                toAddRois = new ArrayList<ROI>(this.kymoROIs);
                for (ROI roi : toAddRois) {
                    if (currentRois.contains(roi)) continue;
                    sequence.addROI(roi);
                }
                this.kymoROIs.clear();
                this.kymoROIs.addAll(sequence.getROI2Ds());
            }
            if (sequence == this.retrogradeKymograph) {
                currentRois = sequence.getROIs();
                toAddRois = new ArrayList<ROI>(this.retroKymoROIs);
                for (ROI roi : toAddRois) {
                    if (currentRois.contains(roi)) continue;
                    sequence.addROI(roi);
                }
                this.retroKymoROIs.clear();
                this.retroKymoROIs.addAll(sequence.getROI2Ds());
            }
            if (sequence == this.anterogradeKymograph) {
                currentRois = sequence.getROIs();
                toAddRois = new ArrayList<ROI>(this.anteroKymoROIs);
                for (ROI roi : toAddRois) {
                    if (currentRois.contains(roi)) continue;
                    sequence.addROI(roi);
                }
                this.anteroKymoROIs.clear();
                this.anteroKymoROIs.addAll(sequence.getROI2Ds());
            }
        }
    }
}

