/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker;

import icy.main.Icy;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.nchenouard.kymographtracker.ActionPanel;
import plugins.nchenouard.kymographtracker.KymographExtractionResult;
import plugins.nchenouard.kymographtracker.KymographTrackingResults;
import plugins.nchenouard.kymographtracker.Util;
import plugins.nchenouard.pathtracing.InteractiveMultipleDjikstraTracingESC;
import plugins.nchenouard.pathtracing.PathEvent;
import plugins.nchenouard.spot.Detection;

class KymographTrackerPanel
extends ActionPanel
implements SwimmingPoolListener,
InteractiveMultipleDjikstraTracingESC.PathListener {
    private static final long serialVersionUID = -3195348117784660674L;
    ArrayList<KymographExtractionResult> results = new ArrayList();
    Sequence selectedSequence = null;
    JTable table;
    JTable tableTracks;
    KymographResultsTableModel kymographTableModel;
    KymographTracksTableModel tracksTableModel;
    JTextArea titleLabel;
    String titleMessage = "Kymographs in the SwimmingPool for the selected sequence:";
    String titleEmptyMessage = "No Kymograph in the SwimmingPool for the selected sequence. Use the methods in the extraction tab first.";
    JButton removeButton;
    JButton buildTracksButton;
    JButton convertToTracksButton;
    JButton showButton;
    double alpha = 0.01;

    public KymographTrackerPanel() {
        this.description = "Kymograph analysis and tracking";
        this.node = new DefaultMutableTreeNode(this.description);
        this.setBorder(new TitledBorder(this.description));
        this.setLayout(new BorderLayout());
        final JTabbedPane tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        this.titleLabel = new JTextArea(this.titleMessage);
        JPanel extractionPanel = new JPanel(new BorderLayout());
        tabbedPane.add((Component)extractionPanel, "Track creation");
        final JPanel explorationPanel = new JPanel(new BorderLayout());
        tabbedPane.add((Component)explorationPanel, "Track visualization");
        this.kymographTableModel = new KymographResultsTableModel();
        this.table = new JTable(this.kymographTableModel);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn col = this.table.getColumnModel().getColumn(i);
            col.setPreferredWidth(100);
        }
        this.table.setSelectionMode(2);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BorderLayout());
        tmpPanel.add((Component)this.table.getTableHeader(), "First");
        tmpPanel.add((Component)this.table, "Center");
        JScrollPane scrollPane = new JScrollPane(tmpPanel);
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        extractionPanel.add((Component)scrollPane, "Center");
        JPanel southPanel1 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        JEditorPane extractionDescriptionPane = new JEditorPane();
        extractionDescriptionPane.setContentType("text/html");
        extractionDescriptionPane.setEditable(false);
        extractionDescriptionPane.setText("Create tracks in the kymographs selected above using ROIs by either directly <strong>creating ROIs</strong> or <strong>tracing paths</strong> in kymograph images, and then <strong>converting ROIs to tracks</strong>.</ul>");
        extractionDescriptionPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        extractionDescriptionPane.setEditable(false);
        southPanel1.add((Component)extractionDescriptionPane, c);
        ++c.gridy;
        this.buildTracksButton = new JButton("Trace tracks as paths");
        southPanel1.add((Component)this.buildTracksButton, c);
        this.buildTracksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KymographTrackerPanel.this.initTracers();
            }
        });
        ++c.gridy;
        this.convertToTracksButton = new JButton("Convert ROIs to tracks");
        southPanel1.add((Component)this.convertToTracksButton, c);
        this.convertToTracksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KymographTrackerPanel.this.convertROIsToTracks();
                tabbedPane.setSelectedComponent(explorationPanel);
            }
        });
        ++c.gridy;
        this.showButton = new JButton("Show kymographs");
        southPanel1.add((Component)this.showButton, c);
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KymographTrackerPanel.this.showKymographs();
            }
        });
        ++c.gridy;
        this.removeButton = new JButton("Delete kymograph");
        southPanel1.add((Component)this.removeButton, c);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KymographTrackerPanel.this.deleteKymographs();
            }
        });
        ++c.gridy;
        extractionPanel.add((Component)southPanel1, "South");
        this.tracksTableModel = new KymographTracksTableModel();
        this.tableTracks = new JTable(this.tracksTableModel);
        for (int i = 0; i < this.tableTracks.getColumnCount(); ++i) {
            TableColumn col = this.tableTracks.getColumnModel().getColumn(i);
            col.setPreferredWidth(50);
        }
        this.tableTracks.setSelectionMode(2);
        explorationPanel.add((Component)new JScrollPane(this.tableTracks), "Center");
        JPanel southPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridheight = 1;
        c2.gridwidth = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.insets = new Insets(2, 2, 2, 2);
        JButton deleteTracksButton = new JButton("Delete tracks");
        deleteTracksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KymographTrackerPanel.this.deleteSelectedTracks();
            }
        });
        southPanel2.add((Component)deleteTracksButton, c2);
        ++c2.gridy;
        JButton show2DTracksButton = new JButton("Show 2D tracks");
        show2DTracksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KymographTrackerPanel.this.show2DTracks();
            }
        });
        southPanel2.add((Component)show2DTracksButton, c2);
        ++c2.gridy;
        explorationPanel.add((Component)southPanel2, "South");
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
        this.refreshResults();
    }

    public void enableGUI(boolean enable) {
    }

    void showKymographs() {
        int numSelectedRows = this.table.getSelectedRowCount();
        if (numSelectedRows < 1) {
            JOptionPane.showMessageDialog(this, "Please select some kymographs to process in the results table.", "Warning", 2);
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<KymographExtractionResult> toShow = new ArrayList<KymographExtractionResult>();
        for (int i : selectedRows) {
            toShow.add(this.kymographTableModel.getResult(i));
        }
        Object object = toShow.iterator();
        while (object.hasNext()) {
            KymographExtractionResult kymo = (KymographExtractionResult)object.next();
            if (!Icy.getMainInterface().getSequences().contains(kymo.getKymograph())) {
                Icy.getMainInterface().addSequence(kymo.getKymograph());
            }
            if (kymo.getAnterogradeKymograph() != null && !Icy.getMainInterface().getSequences().contains(kymo.getAnterogradeKymograph())) {
                Icy.getMainInterface().addSequence(kymo.getAnterogradeKymograph());
            }
            if (kymo.getRetrogradeKymograph() == null || Icy.getMainInterface().getSequences().contains(kymo.getRetrogradeKymograph())) continue;
            Icy.getMainInterface().addSequence(kymo.getRetrogradeKymograph());
        }
    }

    void initTracers() {
        int numSelectedRows = this.table.getSelectedRowCount();
        if (numSelectedRows < 1) {
            JOptionPane.showMessageDialog(this, "Please select some kymographs to process in the results table.", "Warning", 2);
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<KymographExtractionResult> toConvert = new ArrayList<KymographExtractionResult>();
        for (int i : selectedRows) {
            toConvert.add(this.kymographTableModel.getResult(i));
        }
        Object object = toConvert.iterator();
        while (object.hasNext()) {
            KymographExtractionResult kymo = (KymographExtractionResult)object.next();
            if (!Icy.getMainInterface().getSequences().contains(kymo.getKymograph())) {
                Icy.getMainInterface().addSequence(kymo.getKymograph());
            }
            InteractiveMultipleDjikstraTracingESC tracer = new InteractiveMultipleDjikstraTracingESC(kymo.getKymograph(), this.alpha, true);
            kymo.getKymograph().addOverlay((Overlay)tracer);
            if (kymo.getAnterogradeKymograph() != null) {
                if (!Icy.getMainInterface().getSequences().contains(kymo.getAnterogradeKymograph())) {
                    Icy.getMainInterface().addSequence(kymo.getAnterogradeKymograph());
                }
                InteractiveMultipleDjikstraTracingESC anteroTracer = new InteractiveMultipleDjikstraTracingESC(kymo.getAnterogradeKymograph(), this.alpha, true);
                kymo.getAnterogradeKymograph().addOverlay((Overlay)anteroTracer);
                anteroTracer.addPathLister(this);
            }
            if (kymo.getRetrogradeKymograph() != null) {
                if (!Icy.getMainInterface().getSequences().contains(kymo.getRetrogradeKymograph())) {
                    Icy.getMainInterface().addSequence(kymo.getRetrogradeKymograph());
                }
                InteractiveMultipleDjikstraTracingESC retroTracer = new InteractiveMultipleDjikstraTracingESC(kymo.getRetrogradeKymograph(), this.alpha, true);
                kymo.getRetrogradeKymograph().addOverlay((Overlay)retroTracer);
                retroTracer.addPathLister(this);
            }
            tracer.addPathLister(this);
        }
    }

    void convertROIsToTracks() {
        int numSelectedRows = this.table.getSelectedRowCount();
        if (numSelectedRows < 1) {
            JOptionPane.showMessageDialog(this, "Please select some kymographs to process in the results table.", "Warning", 2);
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<KymographExtractionResult> toConvert = new ArrayList<KymographExtractionResult>();
        for (int i : selectedRows) {
            toConvert.add(this.kymographTableModel.getResult(i));
        }
        Object object = toConvert.iterator();
        while (object.hasNext()) {
            TrackSegment track;
            ArrayList<double[]> positions;
            KymographExtractionResult kymo = (KymographExtractionResult)object.next();
            if (kymo.getKymograph() != null) {
                kymo.trackingResults = new KymographTrackingResults();
                if (kymo.trackingResults.tracks1D == null) {
                    kymo.trackingResults.tracks1D = new ArrayList();
                }
                if (kymo.trackingResults.tracks2D == null) {
                    kymo.trackingResults.tracks2D = new TrackGroup(kymo.sourceSequence);
                    kymo.trackingResults.tracks2D.setDescription(kymo.roi.getName() + "_tracks");
                    Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)kymo.trackingResults.tracks2D));
                }
                for (ROI2D roi : kymo.getKymograph().getROI2Ds()) {
                    if (!(roi instanceof ROI2DShape)) continue;
                    positions = this.getUnitStepPositions((ROI2DShape)roi);
                    kymo.trackingResults.tracks1D.add(positions);
                    track = this.computeTrackFromKymograph(kymo, positions);
                    kymo.trackingResults.tracks2D.addTrackSegment(track);
                }
            }
            if (kymo.getAnterogradeKymograph() != null) {
                kymo.anterogradeTrackingResults = new KymographTrackingResults();
                if (kymo.anterogradeTrackingResults.tracks1D == null) {
                    kymo.anterogradeTrackingResults.tracks1D = new ArrayList();
                }
                if (kymo.anterogradeTrackingResults.tracks2D == null) {
                    kymo.anterogradeTrackingResults.tracks2D = new TrackGroup(kymo.sourceSequence);
                    kymo.anterogradeTrackingResults.tracks2D.setDescription(kymo.roi.getName() + "_anteroTracks");
                    Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)kymo.anterogradeTrackingResults.tracks2D));
                }
                for (ROI2D roi : kymo.getAnterogradeKymograph().getROI2Ds()) {
                    if (!(roi instanceof ROI2DShape)) continue;
                    positions = this.getUnitStepPositions((ROI2DShape)roi);
                    kymo.anterogradeTrackingResults.tracks1D.add(positions);
                    track = this.computeTrackFromKymograph(kymo, positions);
                    kymo.anterogradeTrackingResults.tracks2D.addTrackSegment(track);
                }
            }
            if (kymo.getRetrogradeKymograph() != null) {
                kymo.retrogradeTrackingResults = new KymographTrackingResults();
                if (kymo.retrogradeTrackingResults.tracks1D == null) {
                    kymo.retrogradeTrackingResults.tracks1D = new ArrayList();
                }
                if (kymo.retrogradeTrackingResults.tracks2D == null) {
                    kymo.retrogradeTrackingResults.tracks2D = new TrackGroup(kymo.sourceSequence);
                    kymo.retrogradeTrackingResults.tracks2D.setDescription(kymo.roi.getName() + "_retroTracks");
                    Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)kymo.retrogradeTrackingResults.tracks2D));
                }
                for (ROI2D roi : kymo.getRetrogradeKymograph().getROI2Ds()) {
                    if (!(roi instanceof ROI2DShape)) continue;
                    positions = this.getUnitStepPositions((ROI2DShape)roi);
                    kymo.retrogradeTrackingResults.tracks1D.add(positions);
                    track = this.computeTrackFromKymograph(kymo, positions);
                    kymo.retrogradeTrackingResults.tracks2D.addTrackSegment(track);
                }
            }
            this.tracksTableModel.refreshTable();
        }
    }

    private TrackSegment computeTrackFromKymograph(KymographExtractionResult kymo, ArrayList<double[]> positions) {
        TrackSegment ts = new TrackSegment();
        ArrayList<double[]> samplingPositions = kymo.samplingPositions;
        for (double[] p : positions) {
            double c = p[1];
            int c0 = (int)Math.floor(c);
            int c1 = (int)Math.ceil(c);
            if (c1 >= samplingPositions.size() || c0 >= samplingPositions.size()) continue;
            if (c0 == c1) {
                double x = samplingPositions.get(c0)[0];
                double y = samplingPositions.get(c0)[1];
                ts.addDetection(new Detection(x, y, 0.0, (int)Math.round(p[0])));
                continue;
            }
            double x0 = samplingPositions.get(c0)[0];
            double y0 = samplingPositions.get(c0)[1];
            double x1 = samplingPositions.get(c1)[0];
            double y1 = samplingPositions.get(c1)[1];
            double x = x0 + (c - (double)c0) * (x1 - x0);
            double y = y0 + (c - (double)c0) * (y1 - y0);
            ts.addDetection(new Detection(x, y, 0.0, (int)Math.round(p[0])));
        }
        return ts;
    }

    public ArrayList<double[]> getUnitStepPositions(ROI2DShape roi) {
        PathIterator pathIterator = roi.getPathIterator(null);
        double[] coords = new double[6];
        ArrayList<double[]> positions = new ArrayList<double[]>();
        while (!pathIterator.isDone()) {
            int segType = pathIterator.currentSegment(coords);
            switch (segType) {
                case 4: {
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    positions.add(new double[]{coords[0], coords[1]});
                    break;
                }
                case 0: {
                    positions.add(new double[]{coords[0], coords[1]});
                    break;
                }
            }
            pathIterator.next();
        }
        ArrayList<double[]> averagedPositions = new ArrayList<double[]>();
        double prevY = -1.7976931348623157E308;
        double sumX = 0.0;
        int cntX = 0;
        for (double[] p : positions) {
            if (p[1] == prevY) {
                sumX += p[0];
                ++cntX;
                continue;
            }
            if (cntX > 0) {
                averagedPositions.add(new double[]{sumX / (double)cntX, prevY});
            }
            prevY = p[1];
            sumX = p[0];
            cntX = 1;
        }
        if (cntX > 0) {
            averagedPositions.add(new double[]{sumX / (double)cntX, prevY});
        }
        positions = this.resamplePositions(averagedPositions);
        return positions;
    }

    public ArrayList<double[]> resamplePositions(ArrayList<double[]> positions) {
        ArrayList<double[]> resampledPositions = new ArrayList<double[]>();
        for (double[] p : positions) {
            resampledPositions.add(new double[]{p[0], Math.round(p[1])});
        }
        ArrayList<double[]> resampledPositions2 = new ArrayList<double[]>();
        if (!positions.isEmpty()) {
            if (((double[])resampledPositions.get(0))[1] > ((double[])resampledPositions.get(positions.size() - 1))[1]) {
                ArrayList tmp = new ArrayList();
                for (int i = 0; i < resampledPositions.size(); ++i) {
                    tmp.add(resampledPositions.get(resampledPositions.size() - i - 1));
                }
                resampledPositions = tmp;
            }
            int t = (int)((double[])resampledPositions.get(0))[1];
            double prevPos = ((double[])resampledPositions.get(0))[0];
            resampledPositions2.add(new double[]{t, prevPos});
            int numSameT = 1;
            for (int i = 1; i < resampledPositions.size(); ++i) {
                if (((double[])resampledPositions.get(i))[1] == (double)(t + 1)) {
                    resampledPositions2.add(new double[]{((double[])resampledPositions.get(i))[1], ((double[])resampledPositions.get(i))[0]});
                    ++t;
                    prevPos = ((double[])resampledPositions.get(i))[0];
                    numSameT = 1;
                    continue;
                }
                if (((double[])resampledPositions.get(i))[1] > (double)(t + 1)) {
                    double nextPos = ((double[])resampledPositions.get(i))[0];
                    double nextT = ((double[])resampledPositions.get(i))[1];
                    int t2 = t + 1;
                    while ((double)t2 < nextT) {
                        resampledPositions2.add(new double[]{t2, prevPos + (nextPos - prevPos) * (double)(t2 - t) / (nextT - (double)t)});
                        ++t2;
                    }
                    resampledPositions2.add(new double[]{(int)nextT, nextPos});
                    t = (int)nextT;
                    prevPos = nextPos;
                    numSameT = 1;
                    continue;
                }
                if (((double[])resampledPositions.get(i))[1] != (double)t) continue;
                double[] prevPosition = resampledPositions2.get(resampledPositions2.size() - 1);
                prevPosition[1] = (prevPosition[1] * (double)(++numSameT - 1) + ((double[])resampledPositions.get(i))[0]) / (double)numSameT;
                prevPos = prevPosition[1];
            }
        }
        return resampledPositions2;
    }

    void deleteKymographs() {
        int numSelectedRows = this.table.getSelectedRowCount();
        if (numSelectedRows < 1) {
            JOptionPane.showMessageDialog(this, "Please select some kymographs to process in the results table.", "Warning", 2);
            return;
        }
        Object[] options = new Object[]{"Delete selected kymographs", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "This will permanently delete the selected kymograph.\n Do you really want to proceed?", "Kymograph deletion", 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<KymographExtractionResult> toRemove = new ArrayList<KymographExtractionResult>();
        for (int i : selectedRows) {
            toRemove.add(this.kymographTableModel.getResult(i));
        }
        Object object = toRemove.iterator();
        block1: while (object.hasNext()) {
            KymographExtractionResult r = (KymographExtractionResult)object.next();
            ArrayList swimmingOjects = Icy.getMainInterface().getSwimmingPool().getObjects(KymographExtractionResult.class);
            for (SwimmingObject o : swimmingOjects) {
                if (o.getObject() != r) continue;
                Icy.getMainInterface().getSwimmingPool().remove(o);
                continue block1;
            }
        }
    }

    void deleteSelectedTracks() {
        int numSelectedRows = this.tableTracks.getSelectedRowCount();
        if (numSelectedRows < 1) {
            JOptionPane.showMessageDialog(this, "Please select some tracks in the results table.", "Warning", 2);
            return;
        }
        Object[] options = new Object[]{"Delete selected tracks", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "This will permanently delete the selected tracks.\n Do you really want to proceed?", "Kymograph deletion", 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<TrackSegment> toRemove = new ArrayList<TrackSegment>();
        for (int i : selectedRows) {
            toRemove.add(this.tracksTableModel.getTrackSegmentAt(i));
        }
        Object object = toRemove.iterator();
        while (object.hasNext()) {
            TrackSegment ts = (TrackSegment)object.next();
            this.tracksTableModel.removeTrackSegment(ts);
        }
    }

    void show2DTracks() {
        TrackManager tm = new TrackManager();
        tm.setDisplaySequence(this.selectedSequence);
    }

    @Override
    protected void changeSelectedSequence(Sequence sequence) {
        this.selectedSequence = sequence;
        this.refreshResults();
    }

    protected void refreshResults() {
        this.results.clear();
        this.kymographTableModel.clearTable();
        this.tracksTableModel.clearTable();
        if (this.selectedSequence != null) {
            for (SwimmingObject obj : Icy.getMainInterface().getSwimmingPool().getObjects(KymographExtractionResult.class)) {
                KymographExtractionResult result = (KymographExtractionResult)obj.getObject();
                if (result.sourceSequence != this.selectedSequence) continue;
                this.results.add(result);
                this.kymographTableModel.addResult(result);
                this.tracksTableModel.addResult(result);
            }
        }
        this.refreshGUI();
    }

    protected void refreshGUI() {
        if (this.results.isEmpty()) {
            this.titleLabel.setText(this.titleEmptyMessage);
            this.enableGUI(false);
        } else {
            this.enableGUI(true);
            this.titleLabel.setText(this.titleEmptyMessage);
        }
        this.table.updateUI();
    }

    public void swimmingPoolChangeEvent(SwimmingPoolEvent event) {
        if (event.getResult().getObject() instanceof KymographExtractionResult) {
            KymographExtractionResult result = (KymographExtractionResult)event.getResult().getObject();
            if (result.sourceSequence == this.selectedSequence) {
                switch (event.getType()) {
                    case ELEMENT_ADDED: {
                        this.results.add(result);
                        this.kymographTableModel.addResult(result);
                        this.tracksTableModel.addResult(result);
                        break;
                    }
                    case ELEMENT_REMOVED: {
                        this.results.remove(result);
                        this.kymographTableModel.removeResult(result);
                        this.tracksTableModel.removeResult(result);
                    }
                }
                this.refreshGUI();
            }
        }
    }

    @Override
    public void refreshPath(PathEvent event, InteractiveMultipleDjikstraTracingESC source, double[][] path) {
        if (event == PathEvent.FINAL_PATH) {
            Sequence sequence = null;
            for (Sequence seq : Icy.getMainInterface().getSequences()) {
                if (!seq.getOverlays().contains((Object)source)) continue;
                sequence = seq;
            }
            if (sequence == null) {
                return;
            }
            ArrayList<double[][]> paths = source.getOptimalPathCopy();
            ROI roi = Util.convertPathToROI(sequence, paths);
            int cntROI = 1;
            boolean notFound = false;
            String name = "Path_" + cntROI;
            while (!notFound) {
                notFound = true;
                name = "Track_" + cntROI;
                for (ROI r : sequence.getROIs()) {
                    if (!r.getName().equals(name)) continue;
                    notFound = false;
                }
                ++cntROI;
            }
            roi.setName(name);
            sequence.addROI(roi);
        }
    }

    class KymographTracksTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7098962063097100347L;
        String[] columnNames = new String[]{"Track ID", "Kymograph name", "Direction", "Mean speed (pixel/frame)"};
        ArrayList<String[]> tableData = new ArrayList();
        ArrayList<TrackSegment> trackSegments = new ArrayList();
        ArrayList<KymographExtractionResult> tableResults = new ArrayList();

        KymographTracksTableModel() {
        }

        protected void refreshTable() {
            this.clearTable();
            for (KymographExtractionResult result : this.tableResults) {
                ArrayList<double[]> positions1D;
                String[] line;
                TrackSegment ts;
                int i;
                if (result.trackingResults != null && result.trackingResults.tracks2D != null) {
                    for (i = 0; i < result.trackingResults.tracks2D.getTrackSegmentList().size(); ++i) {
                        ts = (TrackSegment)result.trackingResults.tracks2D.getTrackSegmentList().get(i);
                        line = new String[this.getColumnCount()];
                        line[0] = String.valueOf(ts.getId());
                        line[1] = result.getKymograph().getName();
                        line[2] = "bidirectional";
                        positions1D = result.trackingResults.tracks1D.get(i);
                        line[3] = String.valueOf((positions1D.get(positions1D.size() - 1)[1] - positions1D.get(0)[1]) / (double)positions1D.size());
                        this.tableData.add(line);
                        this.trackSegments.add(ts);
                    }
                }
                if (result.anterogradeTrackingResults != null) {
                    for (i = 0; i < result.anterogradeTrackingResults.tracks2D.getTrackSegmentList().size(); ++i) {
                        ts = (TrackSegment)result.anterogradeTrackingResults.tracks2D.getTrackSegmentList().get(i);
                        line = new String[this.getColumnCount()];
                        line[0] = String.valueOf(ts.getId());
                        line[1] = result.getKymograph().getName();
                        line[2] = "anterograde";
                        positions1D = result.anterogradeTrackingResults.tracks1D.get(i);
                        line[3] = String.valueOf((positions1D.get(positions1D.size() - 1)[1] - positions1D.get(0)[1]) / (double)positions1D.size());
                        this.tableData.add(line);
                        this.trackSegments.add(ts);
                    }
                }
                if (result.retrogradeTrackingResults == null) continue;
                for (i = 0; i < result.retrogradeTrackingResults.tracks2D.getTrackSegmentList().size(); ++i) {
                    ts = (TrackSegment)result.retrogradeTrackingResults.tracks2D.getTrackSegmentList().get(i);
                    line = new String[this.getColumnCount()];
                    line[0] = String.valueOf(ts.getId());
                    line[1] = result.getKymograph().getName();
                    line[2] = "retrograde";
                    positions1D = result.retrogradeTrackingResults.tracks1D.get(i);
                    line[3] = String.valueOf((positions1D.get(positions1D.size() - 1)[1] - positions1D.get(0)[1]) / (double)positions1D.size());
                    this.tableData.add(line);
                    this.trackSegments.add(ts);
                }
            }
            this.fireTableDataChanged();
        }

        public void removeResult(KymographExtractionResult result) {
            int idx = this.tableResults.indexOf(result);
            if (idx >= 0) {
                this.tableResults.remove(idx);
            }
            this.refreshTable();
        }

        public TrackSegment getTrackSegmentAt(int i) {
            if (i < this.trackSegments.size()) {
                return this.trackSegments.get(i);
            }
            throw new IllegalArgumentException("Index exceeds table size");
        }

        protected void addResult(KymographExtractionResult result) {
            this.tableResults.add(result);
            this.refreshTable();
        }

        public void clearTable() {
            this.tableData.clear();
            this.trackSegments.clear();
        }

        protected void removeTrackSegment(TrackSegment ts) {
            for (KymographExtractionResult result : this.tableResults) {
                if (result.trackingResults != null && result.trackingResults.tracks2D != null) {
                    result.trackingResults.tracks2D.removeTrackSegment(ts);
                }
                if (result.anterogradeTrackingResults != null && result.anterogradeTrackingResults.tracks2D != null) {
                    result.anterogradeTrackingResults.tracks2D.removeTrackSegment(ts);
                }
                if (result.retrogradeTrackingResults == null || result.retrogradeTrackingResults.tracks2D == null) continue;
                result.retrogradeTrackingResults.tracks2D.removeTrackSegment(ts);
            }
            this.refreshTable();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class<String> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            if (this.tableData.size() <= arg0) {
                return null;
            }
            return this.tableData.get(arg0)[arg1];
        }
    }

    class KymographResultsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1614208982278312037L;
        String[] columnNames = new String[]{"ROI name", "Kymograph names", "Anterograde/retrograde splitting", "Path length", "First endpoint", "Last endpoint"};
        ArrayList<String[]> tableData = new ArrayList();
        ArrayList<KymographExtractionResult> tableResults = new ArrayList();

        KymographResultsTableModel() {
        }

        protected void addResult(KymographExtractionResult result) {
            this.tableResults.add(result);
            String[] line = new String[this.getColumnCount()];
            line[0] = result.roi == null ? "null" : result.roi.getName();
            line[1] = result.getKymograph() == null ? "null" : result.getKymograph().getName();
            if (result.anterogradeRetrogradeSeparation) {
                line[1] = line[1].concat("; " + result.getAnterogradeKymograph().getName());
                line[1] = line[1].concat("; " + result.getRetrogradeKymograph().getName());
            }
            line[2] = String.valueOf(result.anterogradeRetrogradeSeparation);
            line[3] = String.valueOf(result.getKymograph().getSizeX());
            if (result.samplingPositions != null && !result.samplingPositions.isEmpty()) {
                line[4] = "{" + result.samplingPositions.get(0)[0] + ", " + result.samplingPositions.get(0)[1] + "}";
                line[5] = "{" + result.samplingPositions.get(result.samplingPositions.size() - 1)[0] + ", " + result.samplingPositions.get(result.samplingPositions.size() - 1)[1] + "}";
            } else {
                line[4] = "{,}";
                line[5] = "{,}";
            }
            this.tableData.add(line);
            this.fireTableRowsInserted(this.tableData.size(), this.tableData.size());
        }

        public void clearTable() {
            this.tableResults.clear();
            this.tableData.clear();
        }

        protected void removeResult(KymographExtractionResult result) {
            int idx = this.tableResults.indexOf(result);
            if (idx >= 0) {
                this.tableResults.remove(idx);
                this.tableData.remove(idx);
            }
            this.fireTableRowsDeleted(idx, idx);
        }

        protected KymographExtractionResult getResult(int rowIndex) {
            return this.tableResults.get(rowIndex);
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class<String> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            if (this.tableData.size() <= arg0) {
                return null;
            }
            return this.tableData.get(arg0)[arg1];
        }
    }
}

