/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.CellReferenceHelper;
import jxl.biff.DataValidation;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkbookMethods;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Drawing;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.common.Assert;
import jxl.common.Logger;
import jxl.format.CellFormat;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadDateFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SheetCopier;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableSheetImpl;

class WritableSheetCopier {
    private static Logger logger = Logger.getLogger(SheetCopier.class);
    private WritableSheetImpl fromSheet;
    private WritableSheetImpl toSheet;
    private WorkbookSettings workbookSettings;
    private TreeSet fromColumnFormats;
    private TreeSet toColumnFormats;
    private MergedCells fromMergedCells;
    private MergedCells toMergedCells;
    private RowRecord[] fromRows;
    private ArrayList fromRowBreaks;
    private ArrayList fromColumnBreaks;
    private ArrayList toRowBreaks;
    private ArrayList toColumnBreaks;
    private DataValidation fromDataValidation;
    private DataValidation toDataValidation;
    private SheetWriter sheetWriter;
    private ArrayList fromDrawings;
    private ArrayList toDrawings;
    private ArrayList toImages;
    private WorkspaceInformationRecord fromWorkspaceOptions;
    private PLSRecord fromPLSRecord;
    private PLSRecord toPLSRecord;
    private ButtonPropertySetRecord fromButtonPropertySet;
    private ButtonPropertySetRecord toButtonPropertySet;
    private ArrayList fromHyperlinks;
    private ArrayList toHyperlinks;
    private ArrayList validatedCells;
    private int numRows;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private boolean chartOnly;
    private FormattingRecords formatRecords;
    private HashMap xfRecords;
    private HashMap fonts;
    private HashMap formats;

    public WritableSheetCopier(WritableSheet f, WritableSheet t) {
        this.fromSheet = (WritableSheetImpl)f;
        this.toSheet = (WritableSheetImpl)t;
        this.workbookSettings = this.toSheet.getWorkbook().getSettings();
        this.chartOnly = false;
    }

    void setColumnFormats(TreeSet fcf, TreeSet tcf) {
        this.fromColumnFormats = fcf;
        this.toColumnFormats = tcf;
    }

    void setMergedCells(MergedCells fmc, MergedCells tmc) {
        this.fromMergedCells = fmc;
        this.toMergedCells = tmc;
    }

    void setRows(RowRecord[] r) {
        this.fromRows = r;
    }

    void setValidatedCells(ArrayList vc) {
        this.validatedCells = vc;
    }

    void setRowBreaks(ArrayList frb, ArrayList trb) {
        this.fromRowBreaks = frb;
        this.toRowBreaks = trb;
    }

    void setColumnBreaks(ArrayList fcb, ArrayList tcb) {
        this.fromColumnBreaks = fcb;
        this.toColumnBreaks = tcb;
    }

    void setDrawings(ArrayList fd, ArrayList td, ArrayList ti) {
        this.fromDrawings = fd;
        this.toDrawings = td;
        this.toImages = ti;
    }

    void setHyperlinks(ArrayList fh, ArrayList th) {
        this.fromHyperlinks = fh;
        this.toHyperlinks = th;
    }

    void setWorkspaceOptions(WorkspaceInformationRecord wir) {
        this.fromWorkspaceOptions = wir;
    }

    void setDataValidation(DataValidation dv) {
        this.fromDataValidation = dv;
    }

    void setPLSRecord(PLSRecord plsr) {
        this.fromPLSRecord = plsr;
    }

    void setButtonPropertySetRecord(ButtonPropertySetRecord bpsr) {
        this.fromButtonPropertySet = bpsr;
    }

    void setSheetWriter(SheetWriter sw) {
        this.sheetWriter = sw;
    }

    DataValidation getDataValidation() {
        return this.toDataValidation;
    }

    PLSRecord getPLSRecord() {
        return this.toPLSRecord;
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    ButtonPropertySetRecord getButtonPropertySet() {
        return this.toButtonPropertySet;
    }

    public void copySheet() {
        this.shallowCopyCells();
        Iterator cfit = this.fromColumnFormats.iterator();
        while (cfit.hasNext()) {
            ColumnInfoRecord cv = new ColumnInfoRecord((ColumnInfoRecord)cfit.next());
            this.toColumnFormats.add(cv);
        }
        Range[] merged = this.fromMergedCells.getMergedCells();
        for (int i = 0; i < merged.length; ++i) {
            this.toMergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i], this.toSheet));
        }
        try {
            RowRecord row = null;
            RowRecord newRow = null;
            for (int i = 0; i < this.fromRows.length; ++i) {
                row = this.fromRows[i];
                if (row == null || row.isDefaultHeight() && !row.isCollapsed()) continue;
                newRow = this.toSheet.getRowRecord(i);
                newRow.setRowDetails(row.getRowHeight(), row.matchesDefaultFontHeight(), row.isCollapsed(), row.getOutlineLevel(), row.getGroupStart(), row.getStyle());
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        this.toRowBreaks = new ArrayList(this.fromRowBreaks);
        this.toColumnBreaks = new ArrayList(this.fromColumnBreaks);
        if (this.fromDataValidation != null) {
            this.toDataValidation = new DataValidation(this.fromDataValidation, (ExternalSheet)this.toSheet.getWorkbook(), (WorkbookMethods)this.toSheet.getWorkbook(), this.toSheet.getWorkbook().getSettings());
        }
        this.sheetWriter.setCharts(this.fromSheet.getCharts());
        for (Object o : this.fromDrawings) {
            if (!(o instanceof Drawing)) continue;
            WritableImage wi = new WritableImage((Drawing)o, this.toSheet.getWorkbook().getDrawingGroup());
            this.toDrawings.add(wi);
            this.toImages.add(wi);
        }
        this.sheetWriter.setWorkspaceOptions(this.fromWorkspaceOptions);
        if (this.fromPLSRecord != null) {
            this.toPLSRecord = new PLSRecord(this.fromPLSRecord);
        }
        if (this.fromButtonPropertySet != null) {
            this.toButtonPropertySet = new ButtonPropertySetRecord(this.fromButtonPropertySet);
        }
        Iterator i = this.fromHyperlinks.iterator();
        while (i.hasNext()) {
            WritableHyperlink hr = new WritableHyperlink((WritableHyperlink)i.next(), this.toSheet);
            this.toHyperlinks.add(hr);
        }
    }

    private WritableCell shallowCopyCell(Cell cell) {
        CellType ct = cell.getType();
        CellValue newCell = null;
        if (ct == CellType.LABEL) {
            newCell = new Label((LabelCell)cell);
        } else if (ct == CellType.NUMBER) {
            newCell = new Number((NumberCell)cell);
        } else if (ct == CellType.DATE) {
            newCell = new DateTime((DateCell)cell);
        } else if (ct == CellType.BOOLEAN) {
            newCell = new Boolean((BooleanCell)cell);
        } else if (ct == CellType.NUMBER_FORMULA) {
            newCell = new ReadNumberFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.STRING_FORMULA) {
            newCell = new ReadStringFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.BOOLEAN_FORMULA) {
            newCell = new ReadBooleanFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.DATE_FORMULA) {
            newCell = new ReadDateFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.FORMULA_ERROR) {
            newCell = new ReadErrorFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.EMPTY && cell.getCellFormat() != null) {
            newCell = new Blank(cell);
        }
        return newCell;
    }

    private WritableCell deepCopyCell(Cell cell) {
        CellFormat cf;
        int index;
        WritableCellFormat wcf;
        WritableCell c = this.shallowCopyCell(cell);
        if (c == null) {
            return c;
        }
        if (c instanceof ReadFormulaRecord) {
            boolean crossSheetReference;
            ReadFormulaRecord rfr = (ReadFormulaRecord)c;
            boolean bl = crossSheetReference = !rfr.handleImportedCellReferences(this.fromSheet.getWorkbook(), this.fromSheet.getWorkbook(), this.workbookSettings);
            if (crossSheetReference) {
                try {
                    logger.warn("Formula " + rfr.getFormula() + " in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported because it references another " + " sheet from the source workbook");
                }
                catch (FormulaException e) {
                    logger.warn("Formula  in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported:  " + e.getMessage());
                }
                c = new Formula(cell.getColumn(), cell.getRow(), "\"ERROR\"");
            }
        }
        if ((wcf = (WritableCellFormat)this.xfRecords.get(new Integer(index = ((XFRecord)(cf = c.getCellFormat())).getXFIndex()))) == null) {
            wcf = this.copyCellFormat(cf);
        }
        c.setCellFormat(wcf);
        return c;
    }

    void shallowCopyCells() {
        int cells = this.fromSheet.getRows();
        Cell[] row = null;
        Cell cell = null;
        for (int i = 0; i < cells; ++i) {
            row = this.fromSheet.getRow(i);
            for (int j = 0; j < row.length; ++j) {
                cell = row[j];
                WritableCell c = this.shallowCopyCell(cell);
                try {
                    if (c == null) continue;
                    this.toSheet.addCell(c);
                    if (!(c.getCellFeatures() != null & c.getCellFeatures().hasDataValidation())) continue;
                    this.validatedCells.add(c);
                    continue;
                }
                catch (WriteException e) {
                    Assert.verify(false);
                }
            }
        }
        this.numRows = this.toSheet.getRows();
    }

    void deepCopyCells() {
        int cells = this.fromSheet.getRows();
        Cell[] row = null;
        Cell cell = null;
        for (int i = 0; i < cells; ++i) {
            row = this.fromSheet.getRow(i);
            for (int j = 0; j < row.length; ++j) {
                cell = row[j];
                WritableCell c = this.deepCopyCell(cell);
                try {
                    if (c == null) continue;
                    this.toSheet.addCell(c);
                    if (!(c.getCellFeatures() != null & c.getCellFeatures().hasDataValidation())) continue;
                    this.validatedCells.add(c);
                    continue;
                }
                catch (WriteException e) {
                    Assert.verify(false);
                }
            }
        }
    }

    private WritableCellFormat copyCellFormat(CellFormat cf) {
        try {
            XFRecord xfr = (XFRecord)cf;
            WritableCellFormat f = new WritableCellFormat((CellFormat)xfr);
            this.formatRecords.addStyle(f);
            int xfIndex = xfr.getXFIndex();
            this.xfRecords.put(new Integer(xfIndex), f);
            int fontIndex = xfr.getFontIndex();
            this.fonts.put(new Integer(fontIndex), new Integer(f.getFontIndex()));
            int formatIndex = xfr.getFormatRecord();
            this.formats.put(new Integer(formatIndex), new Integer(f.getFormatRecord()));
            return f;
        }
        catch (NumFormatRecordsException e) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            return WritableWorkbook.NORMAL_STYLE;
        }
    }

    public int getMaxColumnOutlineLevel() {
        return this.maxColumnOutlineLevel;
    }

    public int getMaxRowOutlineLevel() {
        return this.maxRowOutlineLevel;
    }
}

