/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import loci.poi.poifs.filesystem.BATManaged;
import loci.poi.poifs.storage.BATBlock;
import loci.poi.poifs.storage.BlockWritable;
import loci.poi.poifs.storage.HeaderBlockWriter;
import loci.poi.util.IntList;

public class BlockAllocationTableWriter
implements BlockWritable,
BATManaged {
    private IntList _entries = new IntList();
    private BATBlock[] _blocks = new BATBlock[0];
    private int _start_block = -2;

    public int createBlocks(int size) {
        int xbat_blocks = 0;
        int bat_blocks = 0;
        while (true) {
            int calculated_bat_blocks = BATBlock.calculateStorageRequirements(bat_blocks + xbat_blocks + this._entries.size(), size);
            int calculated_xbat_blocks = HeaderBlockWriter.calculateXBATStorageRequirements(calculated_bat_blocks, size);
            if (bat_blocks == calculated_bat_blocks && xbat_blocks == calculated_xbat_blocks) break;
            bat_blocks = calculated_bat_blocks;
            xbat_blocks = calculated_xbat_blocks;
        }
        int startBlock = this.allocateSpace(bat_blocks);
        this.allocateSpace(xbat_blocks);
        this.simpleCreateBlocks(size);
        return startBlock;
    }

    public int allocateSpace(int blockCount) {
        int startBlock = this._entries.size();
        if (blockCount > 0) {
            int limit = blockCount - 1;
            int index = startBlock + 1;
            for (int k = 0; k < limit; ++k) {
                this._entries.add(index++);
            }
            this._entries.add(-2);
        }
        return startBlock;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    void simpleCreateBlocks(int size) {
        this._blocks = BATBlock.createBATBlocks(this._entries.toArray(), size);
    }

    @Override
    public void writeBlocks(OutputStream stream) throws IOException {
        for (int j = 0; j < this._blocks.length; ++j) {
            this._blocks[j].writeBlocks(stream);
        }
    }

    @Override
    public int countBlocks() {
        return this._blocks.length;
    }

    @Override
    public void setStartBlock(int start_block) {
        this._start_block = start_block;
    }
}

