/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.StackStatistics;
import java.awt.Rectangle;

public class Stack_Statistics
implements PlugIn {
    @Override
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        int measurements = Analyzer.getMeasurements();
        Analyzer.setMeasurements(measurements | 0x100);
        StackStatistics stats = new StackStatistics(imp);
        Analyzer.setMeasurements(measurements);
        ResultsTable rt = Analyzer.getResultsTable();
        rt.incrementCounter();
        Roi roi = imp.getRoi();
        if (roi != null && !roi.isArea()) {
            imp.deleteRoi();
            roi = null;
        }
        double stackVoxels = 0.0;
        double images = imp.getStackSize();
        if (roi == null) {
            stackVoxels = (double)(imp.getWidth() * imp.getHeight()) * images;
        } else if (roi.getType() == 0) {
            Rectangle r = roi.getBounds();
            stackVoxels = (double)(r.width * r.height) * images;
        } else {
            Analyzer.setMeasurements(measurements & 0xFFFFFEFF);
            StackStatistics stats2 = new StackStatistics(imp);
            Analyzer.setMeasurements(measurements);
            stackVoxels = stats2.longPixelCount;
        }
        Calibration cal = imp.getCalibration();
        String units = cal.getUnits();
        double scale = cal.pixelWidth * cal.pixelHeight * cal.pixelDepth;
        rt.addValue("Voxels", (double)stats.longPixelCount);
        if (scale != 1.0) {
            rt.addValue("Volume(" + units + "^3)", (double)stats.longPixelCount * scale);
        }
        rt.addValue("%Volume", (double)stats.longPixelCount * 100.0 / stackVoxels);
        rt.addValue("Mean", stats.mean);
        rt.addValue("StdDev", stats.stdDev);
        rt.addValue("Min", stats.min);
        rt.addValue("Max", stats.max);
        rt.addValue("Mode", stats.dmode);
        rt.addValue("Median", stats.median);
        rt.show("Results");
    }
}

