/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.painter.Anchor2D;
import icy.painter.OverlayEvent;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DShape;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkSphereSource;

public class ROI2DPoint
extends ROI2DShape {
    public static final String ID_POSITION = "position";
    private final Anchor2D position;

    @Deprecated
    public ROI2DPoint(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DPoint(Point2D position) {
        super(new Line2D.Double());
        this.position = this.createAnchor(position);
        this.position.setSelected(true);
        this.addPoint(this.position);
        this.setIcon(ResourceUtil.ICON_ROI_POINT);
    }

    public ROI2DPoint(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DPoint(double x, double y) {
        this(new Point2D.Double(x, y));
    }

    public ROI2DPoint() {
        this(new Point2D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Point2D";
    }

    @Override
    protected ROI2DShape.ROI2DShapePainter createPainter() {
        return new ROI2DPointPainter();
    }

    @Deprecated
    public Rectangle2D getRectangle() {
        Point2D pt = this.getPoint();
        return new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
    }

    public Line2D getLine() {
        return (Line2D)this.shape;
    }

    public Point2D getPoint() {
        return this.position.getPosition();
    }

    @Override
    public void controlPointOverlayChanged(OverlayEvent event) {
        if (event.getType() == OverlayEvent.OverlayEventType.PAINTER_CHANGED) {
            if (this.hasSelectedPoint()) {
                this.setFocused(true);
            }
            this.getOverlay().painterChanged();
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public boolean contains(ROI roi) {
        return false;
    }

    @Override
    public boolean intersects(ROI r) {
        if (r instanceof ROI2DPoint) {
            return this.onSamePos((ROI2DPoint)r, false) && ((ROI2DPoint)r).getPoint().equals(this.getPoint());
        }
        return super.intersects(r);
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke")) break;
                ((ROI2DShape.ROI2DShapePainter)this.getOverlay()).needRebuild = true;
                break;
            }
            case SELECTION_CHANGED: {
                if (!this.isSelected()) break;
                this.position.setSelected(true);
                break;
            }
        }
        super.onChanged(object);
    }

    @Override
    protected void updateShape() {
        Point2D pt = this.getPoint();
        double x = pt.getX();
        double y = pt.getY();
        this.getLine().setLine(x, y, x, y);
        super.updateShape();
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor2D pt) {
        if (canvas != null) {
            canvas.getSequence().removeROI(this);
            return true;
        }
        return false;
    }

    @Override
    public double computeNumberOfContourPoints() {
        return 0.0;
    }

    @Override
    public double computeNumberOfPoints() {
        return 0.0;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.position.loadPositionFromXML(XMLUtil.getElement(node, ID_POSITION));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.position.savePositionToXML(XMLUtil.setElement(node, ID_POSITION));
        return true;
    }

    public class ROI2DPointPainter
    extends ROI2DShape.ROI2DShapePainter {
        vtkSphereSource vtkSource;

        public ROI2DPointPainter() {
            super(ROI2DPoint.this);
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            if (this.vtkSource != null) {
                this.vtkSource.Delete();
            }
        }

        @Override
        protected boolean isSmall(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            return !ROI2DPoint.this.isSelected();
        }

        @Override
        protected boolean isTiny(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            return !ROI2DPoint.this.isSelected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                Graphics2D g2 = (Graphics2D)g.create();
                if (ROI2DPoint.this.isSelected() && !this.isReadOnly()) {
                    List list = ROI2DPoint.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DPoint.this.controlPoints) {
                            pt.paint(g2, sequence, canvas);
                        }
                    }
                } else {
                    Point2D pos = ROI2DPoint.this.getPoint();
                    double ray = this.getAdjustedStroke(canvas);
                    Ellipse2D.Double ellipse = new Ellipse2D.Double(pos.getX() - ray, pos.getY() - ray, ray * 2.0, ray * 2.0);
                    g2.setColor(this.getDisplayColor());
                    g2.fill(ellipse);
                }
                g2.dispose();
            } else {
                super.drawROI(g, sequence, canvas);
            }
        }

        @Override
        protected void initVtkObjects() {
            super.initVtkObjects();
            this.vtkSource = new vtkSphereSource();
            this.vtkSource.SetRadius(this.getStroke());
            this.vtkSource.SetThetaResolution(12);
            this.vtkSource.SetPhiResolution(12);
            if (this.actor != null) {
                this.actor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            this.polyMapper = new vtkPolyDataMapper();
            this.polyMapper.SetInputConnection(this.vtkSource.GetOutputPort());
            this.actor = new vtkActor();
            this.actor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            this.actor.GetProperty().SetColor((double)col.getRed() / 255.0, (double)col.getGreen() / 255.0, (double)col.getBlue() / 255.0);
        }

        @Override
        protected void rebuildVtkObjects() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel2 = canvas.getVtkPanel();
            if (vtkPanel2 == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            Point2D pos = ROI2DPoint.this.getPoint();
            double curZ = ROI2DPoint.this.getZ();
            if (curZ == -1.0) {
                curZ = (double)seq.getSizeZ() / 2.0;
            }
            vtkPanel2.lock();
            try {
                this.vtkSource.SetRadius(this.getStroke() * this.scaling[0]);
                this.vtkSource.SetCenter(pos.getX() * this.scaling[0], pos.getY() * this.scaling[1], (curZ + 0.5) * this.scaling[2]);
                this.polyMapper.Update();
            }
            finally {
                vtkPanel2.unlock();
            }
            this.painterChanged();
        }

        @Override
        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel2;
            if (this.actor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            IcyVtkPanel icyVtkPanel = vtkPanel2 = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel2 != null) {
                vtkPanel2.lock();
            }
            try {
                this.actor.GetProperty().SetColor(r, g, b);
            }
            finally {
                if (vtkPanel2 != null) {
                    vtkPanel2.unlock();
                }
            }
            this.painterChanged();
        }
    }
}

