/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.rieszwavelets;

import icy.gui.component.pool.SwimmingObjectChooser;
import icy.swimmingPool.SwimmingObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import plugins.nchenouard.isotropicwavelets.WaveletFilterSet;
import plugins.nchenouard.rieszwavelets.HarmonicTypes;
import plugins.nchenouard.rieszwavelets.RieszConfig;
import plugins.nchenouard.rieszwavelets.RieszGeneralization;
import plugins.nchenouard.rieszwavelets.RieszWaveletCoefficients;
import plugins.nchenouard.rieszwavelets.RieszWaveletConfig;
import plugins.nchenouard.rieszwavelets.SequenceAnalysisResults;
import plugins.nchenouard.rieszwavelets.StandardRieszFrames;

public class CoefficientSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 7698432379479738937L;
    CoefficientsTableModel coeffTableModel;
    JTable coefficientTable;
    SwimmingObjectChooser resultsBox;

    public CoefficientSelectionPanel() {
        this.setLayout(new BorderLayout());
        this.resultsBox = new SwimmingObjectChooser(SequenceAnalysisResults.class);
        this.add((Component)this.resultsBox, "North");
        this.resultsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                CoefficientSelectionPanel.this.updateResultsTable();
            }
        });
        this.coeffTableModel = new CoefficientsTableModel();
        this.coefficientTable = new JTable(this.coeffTableModel);
        JScrollPane scrollTablePane = new JScrollPane(this.coefficientTable);
        this.add((Component)scrollTablePane, "Center");
    }

    void updateResultsTable() {
        Object selectedItem = this.resultsBox.getSelectedItem();
        if (selectedItem != null) {
            SequenceAnalysisResults results = (SequenceAnalysisResults)((SwimmingObject)selectedItem).getObject();
            this.coeffTableModel.setResults(results);
        } else {
            this.coeffTableModel.setResults(null);
        }
    }

    public class CoefficientsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4810024326298005026L;
        SequenceAnalysisResults results = null;
        String[] columnNames = new String[]{"Sequence name", "Frames", "Generalization", "Harmonics", "Harmonics type", "Scales", "Wavelet profile", "Filter high frequencies", "Isotropic padding", "Padding X", "Padding Y"};
        String[] valueList = new String[]{"", "", "", "", "", "", "", "", "", "", ""};

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        /*
         * WARNING - void declaration
         */
        public void setResults(SequenceAnalysisResults r) {
            this.results = r;
            if (this.results == null) {
                for (int i = 0; i < this.valueList.length; ++i) {
                    this.valueList[i] = "";
                }
            } else {
                void var14_28;
                this.valueList[0] = this.results.getSequenceName();
                this.valueList[1] = Integer.toString(this.results.getAllAnalyzedTimesResults().size());
                RieszWaveletCoefficients rwc = this.results.getAllResults().get(0);
                RieszWaveletConfig config = rwc.getConfig();
                WaveletFilterSet filters = config.getWaveletFilterSet();
                ArrayList<RieszGeneralization> rieszGeneralizationList = rwc.getGeneralizationList();
                ArrayList<StandardRieszFrames> rieszFrameList = new ArrayList<StandardRieszFrames>();
                for (RieszGeneralization rg : rieszGeneralizationList) {
                    rieszFrameList.add(rg.getRieszFrame());
                }
                boolean sameItem = true;
                StandardRieszFrames rieszFrame = (StandardRieszFrames)((Object)rieszFrameList.get(0));
                for (Object srf : rieszFrameList) {
                    if (srf == rieszFrame) continue;
                    sameItem = false;
                    break;
                }
                String rieszFrameString = "";
                if (sameItem) {
                    rieszFrameString = rieszFrame.toString();
                } else {
                    for (StandardRieszFrames srf : rieszFrameList) {
                        rieszFrameString = rieszFrameString.concat(srf.toString() + "; ");
                    }
                }
                this.valueList[2] = rieszFrameString;
                ArrayList<RieszConfig> rieszConfigList = config.getRieszConfigurations();
                ArrayList<int[]> harmonicList = new ArrayList<int[]>();
                ArrayList<HarmonicTypes> harmonicsTypeList = new ArrayList<HarmonicTypes>();
                for (RieszConfig rieszConfig : rieszConfigList) {
                    harmonicList.add(rieszConfig.harmonics);
                    harmonicsTypeList.add(rieszConfig.harmonicType);
                }
                sameItem = true;
                int[] harmonics = (int[])harmonicList.get(0);
                block5: for (int[] h : harmonicList) {
                    if (harmonics.length != h.length) {
                        sameItem = false;
                        break;
                    }
                    for (int i = 0; i < h.length; ++i) {
                        if (h[i] == harmonics[i]) continue;
                        sameItem = false;
                        continue block5;
                    }
                }
                String string = "";
                if (sameItem) {
                    void var14_20;
                    String string2 = "[";
                    for (int j = 0; j < harmonics.length; ++j) {
                        String string3 = (String)var14_20 + harmonics[j] + ", ";
                    }
                    String string4 = (String)var14_20 + "]";
                } else {
                    for (int[] h : harmonicList) {
                        void var14_25;
                        void var14_23;
                        String string5 = (String)var14_23 + "[";
                        for (int j = 0; j < harmonics.length; ++j) {
                            String string6 = (String)var14_25 + h[j] + ", ";
                        }
                        String string7 = (String)var14_25 + "]; ";
                    }
                }
                this.valueList[3] = var14_28;
                sameItem = true;
                HarmonicTypes harmonicsType = (HarmonicTypes)((Object)harmonicsTypeList.get(0));
                for (HarmonicTypes ht : harmonicsTypeList) {
                    if (ht == harmonicsType) continue;
                    sameItem = false;
                    break;
                }
                String harmonicTypeString = "";
                if (sameItem) {
                    harmonicTypeString = harmonicsType.toString();
                } else {
                    for (HarmonicTypes ht : harmonicsTypeList) {
                        harmonicTypeString = harmonicTypeString.concat(ht.toString() + "; ");
                    }
                }
                this.valueList[4] = harmonicTypeString;
                this.valueList[5] = Integer.toString(filters.getNumScales());
                this.valueList[6] = filters.getWaveletType().toString();
                this.valueList[7] = Boolean.toString(filters.isPrefilter());
                this.valueList[8] = Boolean.toString(filters.isIsotropicPadding());
                this.valueList[9] = Integer.toString(rwc.getPadX());
                this.valueList[10] = Integer.toString(rwc.getPadY());
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            return this.valueList[arg1];
        }
    }
}

