/*
 * Decompiled with CFR 0.152.
 */
package icy.update;

import icy.common.Version;
import icy.file.FileUtil;
import icy.file.xml.XMLPersistent;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementDescriptor
implements XMLPersistent {
    private static final String ID_NAME = "name";
    private static final String ID_VERSION = "version";
    private static final String ID_FILES = "files";
    private static final String ID_FILE = "file";
    private static final String ID_LINK = "link";
    private static final String ID_EXECUTE = "execute";
    private static final String ID_WRITE = "write";
    private static final String ID_DIRECTORY = "directory";
    private static final String ID_FILENUMBER = "fileNumber";
    private static final String ID_DATEMODIF = "datemodif";
    private static final String ID_LOCALPATH = "localpath";
    private static final String ID_ONLINEPATH = "onlinepath";
    private static final String ID_CHANGESLOG = "changeslog";
    private String name;
    private Version version;
    private final ArrayList<ElementFile> files;
    private String changelog;

    public ElementDescriptor(Node node) {
        this.files = new ArrayList();
        this.loadFromXML(node);
    }

    public ElementDescriptor(ElementDescriptor element) {
        this.name = element.name;
        this.version = new Version(element.version.toString());
        this.changelog = element.changelog;
        this.files = new ArrayList();
        for (ElementFile f : element.files) {
            this.files.add(new ElementFile(f));
        }
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.name = XMLUtil.getElementValue(node, ID_NAME, "");
        this.version = new Version(XMLUtil.getElementValue(node, ID_VERSION, ""));
        this.changelog = XMLUtil.getElementValue(node, ID_CHANGESLOG, "");
        ArrayList<Node> nodesFile = XMLUtil.getChildren(XMLUtil.getElement(node, ID_FILES), ID_FILE);
        if (nodesFile != null) {
            for (Node n : nodesFile) {
                ElementFile elementFile = new ElementFile(n);
                if (elementFile.isEmpty()) continue;
                this.files.add(elementFile);
            }
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        return this.saveToNode(node, true);
    }

    public boolean saveToNode(Node node, boolean onlineSave) {
        if (node == null) {
            return false;
        }
        XMLUtil.addElement(node, ID_NAME, this.name);
        XMLUtil.addElement(node, ID_VERSION, this.version.toString());
        if (onlineSave) {
            XMLUtil.addElement(node, ID_CHANGESLOG, this.changelog);
        }
        Element filesNode = XMLUtil.addElement(node, ID_FILES);
        for (ElementFile elementFile : this.files) {
            elementFile.saveToNode(XMLUtil.addElement(filesNode, ID_FILE), onlineSave);
        }
        return true;
    }

    public ElementFile getElementFile(String localPath) {
        for (ElementFile file : this.files) {
            if (file.getLocalPath().compareToIgnoreCase(localPath) != 0) continue;
            return file;
        }
        return null;
    }

    public boolean hasLocalPath(String localPath) {
        return this.getElementFile(localPath) != null;
    }

    public boolean addElementFile(ElementFile file) {
        return this.files.add(file);
    }

    public boolean removeElementFile(ElementFile file) {
        return this.files.remove(file);
    }

    public void removeElementFile(String localPath) {
        this.removeElementFile(this.getElementFile(localPath));
    }

    public boolean validate() {
        boolean result = true;
        int i = this.files.size() - 1;
        while (i >= 0) {
            ElementFile elementFile = this.files.get(i);
            File file = new File(elementFile.getLocalPath());
            if (file.exists()) {
                elementFile.setDateModif(file.lastModified());
                if (file.isDirectory()) {
                    elementFile.setDirectory(true);
                    elementFile.setFileNumber(FileUtil.getFiles(file, null, true, false, false).length);
                }
            } else {
                this.files.remove(i);
                result = false;
            }
            --i;
        }
        return result;
    }

    public boolean isValid() {
        for (ElementFile file : this.files) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getFilesNumber() {
        return this.files.size();
    }

    public ArrayList<ElementFile> getFiles() {
        return this.files;
    }

    public ElementFile getFile(int index) {
        return this.files.get(index);
    }

    public String getChangelog() {
        return this.changelog;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean isSame(ElementDescriptor element, boolean compareFileOnlinePath) {
        if (element == null) {
            return false;
        }
        if (!this.name.equals(element.name)) {
            return false;
        }
        if (!this.version.equals(element.version)) {
            return false;
        }
        if (this.files.size() != element.files.size()) {
            return false;
        }
        for (ElementFile file : this.files) {
            ElementFile elementFile = element.getElementFile(file.getLocalPath());
            if (elementFile == null) {
                return false;
            }
            if (elementFile.isSame(file, compareFileOnlinePath, true)) continue;
            return false;
        }
        return true;
    }

    public static ElementDescriptor getUpdateElement(ElementDescriptor localElement, ElementDescriptor onlineElement) {
        if (onlineElement == null) {
            return null;
        }
        ElementDescriptor result = new ElementDescriptor(onlineElement);
        if (localElement == null) {
            return result;
        }
        if (!StringUtil.equals(result.name, localElement.name)) {
            return result;
        }
        boolean compareValidDateOnly = result.version.equals(localElement.version);
        int i = result.files.size() - 1;
        while (i >= 0) {
            ElementFile onlineFile = result.files.get(i);
            ElementFile localFile = localElement.getElementFile(onlineFile.getLocalPath());
            if (localFile != null && onlineFile.isSame(localFile, false, compareValidDateOnly)) {
                result.files.remove(i);
            }
            --i;
        }
        if (result.files.isEmpty()) {
            return null;
        }
        return result;
    }

    public void update(ElementDescriptor updateElement) {
        this.version = updateElement.version;
        for (ElementFile updateFile : updateElement.files) {
            ElementFile localFile = this.getElementFile(updateFile.getLocalPath());
            if (localFile == null) {
                this.files.add(updateFile);
                continue;
            }
            localFile.setDateModif(updateFile.getDateModif());
            localFile.setExecutable(updateFile.isExecutable());
            localFile.setLink(updateFile.isLink());
            localFile.setWritable(updateFile.isWritable());
            localFile.setDirectory(updateFile.isDirectory());
        }
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.version;
    }

    public class ElementFile
    implements XMLPersistent {
        private String localPath;
        private String onlinePath;
        private boolean link;
        private boolean executable;
        private boolean writable;
        private boolean directory;
        private long dateModif;
        private int fileNumber;

        public ElementFile(Node node) {
            this.loadFromXML(node);
        }

        public ElementFile(ElementFile elementFile) {
            this.localPath = elementFile.localPath;
            this.onlinePath = elementFile.onlinePath;
            this.dateModif = elementFile.dateModif;
            this.link = elementFile.link;
            this.executable = elementFile.executable;
            this.writable = elementFile.writable;
            this.directory = elementFile.directory;
            this.fileNumber = elementFile.fileNumber;
        }

        @Override
        public boolean loadFromXML(Node node) {
            if (node == null) {
                return false;
            }
            this.localPath = XMLUtil.getElementValue(node, ElementDescriptor.ID_LOCALPATH, "");
            this.onlinePath = XMLUtil.getElementValue(node, ElementDescriptor.ID_ONLINEPATH, "");
            this.dateModif = XMLUtil.getElementLongValue(node, ElementDescriptor.ID_DATEMODIF, 0L);
            this.link = XMLUtil.getElementBooleanValue(node, ElementDescriptor.ID_LINK, false);
            this.executable = XMLUtil.getElementBooleanValue(node, ElementDescriptor.ID_EXECUTE, false);
            this.writable = XMLUtil.getElementBooleanValue(node, ElementDescriptor.ID_WRITE, false);
            this.directory = XMLUtil.getElementBooleanValue(node, ElementDescriptor.ID_DIRECTORY, false);
            this.fileNumber = XMLUtil.getElementIntValue(node, ElementDescriptor.ID_FILENUMBER, 1);
            return true;
        }

        @Override
        public boolean saveToXML(Node node) {
            return this.saveToNode(node, true);
        }

        boolean saveToNode(Node node, boolean onlineSave) {
            if (node == null) {
                return false;
            }
            XMLUtil.addElement(node, ElementDescriptor.ID_LOCALPATH, this.localPath);
            if (onlineSave) {
                XMLUtil.addElement(node, ElementDescriptor.ID_ONLINEPATH, this.onlinePath);
                XMLUtil.addElement(node, ElementDescriptor.ID_DATEMODIF, Long.toString(this.dateModif));
                if (this.link) {
                    XMLUtil.addElement(node, ElementDescriptor.ID_LINK, Boolean.toString(this.link));
                }
                if (this.executable) {
                    XMLUtil.addElement(node, ElementDescriptor.ID_EXECUTE, Boolean.toString(this.executable));
                }
                if (this.writable) {
                    XMLUtil.addElement(node, ElementDescriptor.ID_WRITE, Boolean.toString(this.writable));
                }
                if (this.directory) {
                    XMLUtil.addElement(node, ElementDescriptor.ID_DIRECTORY, Boolean.toString(this.directory));
                    XMLUtil.addElement(node, ElementDescriptor.ID_FILENUMBER, Integer.toString(this.fileNumber));
                }
            }
            return true;
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty(this.localPath) && StringUtil.isEmpty(this.onlinePath);
        }

        public boolean exists() {
            return FileUtil.exists(this.localPath);
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public String getOnlinePath() {
            return this.onlinePath;
        }

        public long getDateModif() {
            return this.dateModif;
        }

        public boolean isLink() {
            return this.link;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public int getFileNumber() {
            return this.fileNumber;
        }

        public void setDateModif(long dateModif) {
            this.dateModif = dateModif;
        }

        public void setLink(boolean link) {
            this.link = link;
        }

        public void setExecutable(boolean executable) {
            this.executable = executable;
        }

        public void setWritable(boolean writable) {
            this.writable = writable;
        }

        public void setDirectory(boolean directory) {
            this.directory = directory;
        }

        public void setFileNumber(int fileNumber) {
            this.fileNumber = fileNumber;
        }

        public boolean isSame(ElementFile elementFile, boolean compareOnlinePath, boolean compareValidDateOnly) {
            if (elementFile == null) {
                return false;
            }
            if (!StringUtil.equals(elementFile.localPath, this.localPath)) {
                return false;
            }
            if (compareOnlinePath && !StringUtil.equals(elementFile.onlinePath, this.onlinePath)) {
                return false;
            }
            if (elementFile.fileNumber != -1 && this.fileNumber != -1 && elementFile.fileNumber != this.fileNumber) {
                return false;
            }
            if (elementFile.dateModif == 0L || this.dateModif == 0L) {
                return compareValidDateOnly;
            }
            return elementFile.dateModif == this.dateModif;
        }

        public String toString() {
            return FileUtil.getFileName(this.localPath);
        }
    }
}

