/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.thresholder;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.roi.LabelExtractor;
import plugins.adufour.thresholder.KMeans;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class Thresholder
extends EzPlug
implements Block {
    private EzVarSequence in = new EzVarSequence("Input");
    private EzVarChannel channel = new EzVarChannel("channel", (Var)this.in.getVariable(), false);
    private EzVarEnum<ThresholdMethod> method = new EzVarEnum("Method", (Enum[])ThresholdMethod.values(), (Enum)ThresholdMethod.MANUAL);
    private EzVarInteger nbClasses = new EzVarInteger("K-means classes", 2, 255, 1);
    private EzVarDoubleArrayNative thresholds = new EzVarDoubleArrayNative("Manual thresholds", (double[][])new double[][]{{100.0, 200.0}}, true);
    private EzVarBoolean pct = new EzVarBoolean("Treat as percentiles", false);
    private EzVarBoolean timeDependent = new EzVarBoolean("Process frames independently", false);
    private EzVarEnum<ThresholdOutput> outputType = new EzVarEnum("Output as", (Enum[])ThresholdOutput.values(), (Enum)ThresholdOutput.SEQUENCE);
    private EzVarBoolean filterBySize = new EzVarBoolean("Filter by size", false);
    private EzVarInteger minSize = new EzVarInteger("Min size (px)", 100, 1, 200000000, 1);
    private EzVarInteger maxSize = new EzVarInteger("Max size (px)", 10000, 1, 200000000, 1);
    private EzVarBoolean inPlace = new EzVarBoolean("Overwrite input", false);
    private VarSequence outLabels = new VarSequence("Binary output", null);
    private VarROIArray outROI = new VarROIArray("ROI");
    private boolean blockMode = false;

    public void initialize() {
        super.addEzComponent((EzComponent)this.in);
        super.addEzComponent((EzComponent)this.channel);
        super.addEzComponent(this.method);
        this.method.addVisibilityTriggerTo((EzComponent)this.nbClasses, (Object[])new ThresholdMethod[]{ThresholdMethod.K_MEANS});
        super.addEzComponent((EzComponent)this.nbClasses);
        this.method.addVisibilityTriggerTo((EzComponent)this.thresholds, (Object[])new ThresholdMethod[]{ThresholdMethod.MANUAL});
        super.addEzComponent((EzComponent)this.thresholds);
        this.method.addVisibilityTriggerTo((EzComponent)this.pct, (Object[])new ThresholdMethod[]{ThresholdMethod.MANUAL});
        super.addEzComponent((EzComponent)this.pct);
        this.method.addVisibilityTriggerTo((EzComponent)this.timeDependent, (Object[])new ThresholdMethod[]{ThresholdMethod.K_MEANS});
        super.addEzComponent((EzComponent)this.timeDependent);
        super.addEzComponent(this.outputType);
        super.addEzComponent((EzComponent)this.filterBySize);
        this.outputType.addVisibilityTriggerTo((EzComponent)this.filterBySize, (Object[])new ThresholdOutput[]{ThresholdOutput.MULTI_ROI});
        EzGroup sizeFilterGroup = new EzGroup("Size filter", new EzComponent[]{this.minSize, this.maxSize});
        super.addEzComponent((EzComponent)sizeFilterGroup);
        this.filterBySize.addVisibilityTriggerTo((EzComponent)sizeFilterGroup, (Object[])new Boolean[]{true});
        this.outputType.addVisibilityTriggerTo((EzComponent)this.inPlace, (Object[])new ThresholdOutput[]{ThresholdOutput.SEQUENCE});
        super.addEzComponent((EzComponent)this.inPlace);
    }

    public void execute() {
        Sequence sOUT;
        Sequence inSeq = (Sequence)this.in.getValue(true);
        int c = (Integer)this.channel.getValue();
        if (c >= inSeq.getSizeC()) {
            throw new VarException(this.channel.getVariable(), "\"" + inSeq.getName() + "\" has no channel \"" + c + "\"");
        }
        ThresholdMethod algorithm = (ThresholdMethod)((Object)this.method.getValue());
        Object _thrs = new double[inSeq.getSizeT()][];
        switch ((ThresholdMethod)((Object)this.method.getValue())) {
            case MANUAL: {
                double[] thrs = (double[])this.thresholds.getValue(true);
                if (thrs.length == 0) {
                    throw new VarException(this.thresholds.getVariable(), "No threshold(s) indicated");
                }
                if (((Boolean)this.pct.getValue()).booleanValue()) {
                    for (double thr : thrs) {
                        if (!(thr < 0.0) && !(thr > 100.0)) continue;
                        throw new VarException(this.pct.getVariable(), "Percentile(s) must be between 0 and 100");
                    }
                    if (!((Boolean)this.timeDependent.getValue()).booleanValue()) {
                        thrs = Arrays.copyOf(thrs, thrs.length);
                        inSeq.loadAllData();
                        double min = inSeq.getChannelMin(c);
                        double max = inSeq.getChannelMax(c);
                        for (int i = 0; i < thrs.length; ++i) {
                            thrs[i] = min + thrs[i] * (max - min) / 100.0;
                        }
                    }
                }
                for (int t = 0; t < inSeq.getSizeT(); ++t) {
                    _thrs[t] = Arrays.copyOf(thrs, thrs.length);
                    if (!((Boolean)this.pct.getValue()).booleanValue() || !((Boolean)this.timeDependent.getValue()).booleanValue()) continue;
                    inSeq.getImage(t, 0).loadData();
                    double min = inSeq.getImage(t, 0).getChannelMin(c);
                    double max = inSeq.getImage(t, 0).getChannelMax(c);
                    for (int z = 1; z < inSeq.getSizeZ(); ++z) {
                        inSeq.getImage(t, z).loadData();
                        double[] sliceBounds = inSeq.getImage(t, z).getChannelBounds(c);
                        if (sliceBounds[0] < min) {
                            min = sliceBounds[0];
                        }
                        if (!(sliceBounds[1] > max)) continue;
                        max = sliceBounds[1];
                    }
                    for (int i = 0; i < _thrs[t].length; ++i) {
                        _thrs[t][i] = min + _thrs[t][i] * (max - min) / 100.0;
                    }
                }
                break;
            }
            case K_MEANS: {
                _thrs = KMeans.computeKMeansThresholds(inSeq, c, (Boolean)this.timeDependent.getValue(), ((Integer)this.nbClasses.getValue()).shortValue(), 255);
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)algorithm) + " method");
            }
        }
        if (this.blockMode) {
            if (this.outLabels.isReferenced()) {
                sOUT = Thresholder.threshold(inSeq, c, _thrs, false);
                sOUT.setName(inSeq.getName() + "_thresholded");
                this.outLabels.setValue(sOUT);
            }
            if (this.outROI.isReferenced()) {
                this.outROI.setValue((Object)Thresholder.threshold(inSeq, c, _thrs));
            }
        } else {
            switch ((ThresholdOutput)((Object)this.outputType.getValue())) {
                case SEQUENCE: {
                    sOUT = Thresholder.threshold(inSeq, c, _thrs, (boolean)((Boolean)this.inPlace.getValue()));
                    String newName = inSeq.getName() + " thresholded";
                    if (!((Boolean)this.timeDependent.getValue()).booleanValue()) {
                        newName = newName + " at value" + (_thrs[0].length == 1 ? " " : "s ");
                        newName = newName + _thrs[0][0];
                        for (int i = 1; i < _thrs[0].length; ++i) {
                            newName = newName + ";" + _thrs[0][i];
                        }
                    }
                    sOUT.setName(newName);
                    if (((Boolean)this.inPlace.getValue()).booleanValue()) {
                        sOUT.dataChanged();
                        break;
                    }
                    this.addSequence(sOUT);
                    break;
                }
                case ROI: {
                    ROI[] rois;
                    inSeq.removeAllROI();
                    for (ROI roi : rois = Thresholder.threshold(inSeq, c, _thrs)) {
                        double size = roi.getNumberOfPoints();
                        if (((Boolean)this.filterBySize.getValue()).booleanValue() && (!(size >= (double)((Integer)this.minSize.getValue()).intValue()) || !(size <= (double)((Integer)this.maxSize.getValue()).intValue()))) continue;
                        inSeq.addROI(roi);
                    }
                    break;
                }
                case MULTI_ROI: {
                    inSeq.removeAllROI();
                    sOUT = Thresholder.threshold(inSeq, c, _thrs, (boolean)((Boolean)this.inPlace.getValue()));
                    List rois = LabelExtractor.extractLabels((Sequence)sOUT, (LabelExtractor.ExtractionType)LabelExtractor.ExtractionType.ALL_LABELS_VS_BACKGROUND, (double)0.0);
                    for (ROI roi : rois) {
                        double size = roi.getNumberOfPoints();
                        if (((Boolean)this.filterBySize.getValue()).booleanValue() && (!(size >= (double)((Integer)this.minSize.getValue()).intValue()) || !(size <= (double)((Integer)this.maxSize.getValue()).intValue()))) continue;
                        inSeq.addROI(roi);
                    }
                    break;
                }
            }
        }
    }

    public static Sequence threshold(Sequence input, int c, double[] thresholds, boolean inPlace) {
        double[][] thresholdsT = new double[input.getSizeT()][];
        for (int t = 0; t < thresholdsT.length; ++t) {
            thresholdsT[t] = thresholds;
        }
        return Thresholder.threshold(input, c, thresholdsT, inPlace);
    }

    public static Sequence threshold(Sequence input, int c, double[][] thresholdsInT, boolean inPlace) {
        if (input == null) {
            throw new IllegalArgumentException("Thresholder: no input sequence given");
        }
        if (c >= input.getSizeC()) {
            throw new IllegalArgumentException("Thresholder: input sequence has no channel #" + c);
        }
        Sequence output = inPlace ? input : new Sequence();
        DataType dataType = input.getDataType_();
        int length = input.getSizeX() * input.getSizeY();
        output.beginUpdate();
        int maxClass = 0;
        for (int t = 0; t < input.getSizeT(); ++t) {
            double[] thresholdValues = thresholdsInT[t];
            if (thresholdValues == null || thresholdValues.length == 0) {
                throw new IllegalArgumentException("Thresholder: no thresholds given");
            }
            double thr0 = thresholdValues[0];
            int maxThresholdIndex = thresholdValues.length - 1;
            if (thresholdValues.length > maxClass) {
                maxClass = thresholdValues.length;
            }
            for (int z = 0; z < input.getSizeZ(); ++z) {
                IcyBufferedImage outSlice;
                Object _in2D = input.getDataXY(t, z, c);
                if (inPlace) {
                    outSlice = input.getImage(t, z);
                } else {
                    outSlice = new IcyBufferedImage(input.getSizeX(), input.getSizeY(), 1, dataType);
                    output.setImage(t, z, (BufferedImage)outSlice);
                }
                Object _out2D = outSlice.getDataXY(inPlace ? c : 0);
                block2: for (int i = 0; i < length; ++i) {
                    double val;
                    double d = val = _in2D == null ? 0.0 : Array1DUtil.getValue((Object)_in2D, (int)i, (DataType)dataType);
                    if (val < thr0) {
                        if (!inPlace) continue;
                        Array1DUtil.setValue((Object)_out2D, (int)i, (DataType)dataType, (double)0.0);
                        continue;
                    }
                    if (maxThresholdIndex == 0) {
                        Array1DUtil.setValue((Object)_out2D, (int)i, (DataType)dataType, (double)1.0);
                        continue;
                    }
                    for (int thr = maxThresholdIndex; thr > 0; --thr) {
                        if (!(val >= thresholdValues[thr])) continue;
                        Array1DUtil.setValue((Object)_out2D, (int)i, (DataType)dataType, (double)(thr + 1));
                        continue block2;
                    }
                    Array1DUtil.setValue((Object)_out2D, (int)i, (DataType)dataType, (double)1.0);
                }
                outSlice.setDataXY(inPlace ? c : 0, _out2D);
            }
        }
        output.endUpdate();
        output.getColorModel().setComponentAbsBounds(inPlace ? c : 0, 0.0, (double)maxClass);
        output.getColorModel().setComponentUserBounds(inPlace ? c : 0, 0.0, (double)maxClass);
        return output;
    }

    public static ROI[] threshold(Sequence input, int c, double[] thresholds) {
        double[][] thresholdsT = new double[input.getSizeT()][];
        for (int t = 0; t < thresholdsT.length; ++t) {
            thresholdsT[t] = thresholds;
        }
        return Thresholder.threshold(input, c, thresholdsT);
    }

    public static ROI[] threshold(Sequence input, int c, double[][] thresholdsOverTime) {
        if (input == null) {
            throw new IllegalArgumentException("Thresholder: no input sequence given");
        }
        if (c >= input.getSizeC()) {
            throw new IllegalArgumentException("Thresholder: input sequence has no channel #" + c);
        }
        int sizeT = input.getSizeT();
        int sizeX = input.getSizeX();
        int sizeY = input.getSizeY();
        int sliceSize = sizeX * sizeY;
        ArrayList<Object> output = new ArrayList<Object>(sizeT);
        DataType dataType = input.getDataType_();
        for (int t = 0; t < sizeT; ++t) {
            double[] thresholds = thresholdsOverTime[t];
            if (thresholds == null || thresholds.length == 0) {
                throw new IllegalArgumentException("Thresholder: no thresholds given");
            }
            int depth = input.getSizeZ(t);
            int lastThresholdIndex = thresholds.length - 1;
            BooleanMask2D[][] masks = new BooleanMask2D[depth][thresholds.length];
            double thr0 = thresholds[0];
            boolean[] isValidSlice = new boolean[depth];
            for (int z = 0; z < depth; ++z) {
                for (int thr = 0; thr < thresholds.length; ++thr) {
                    masks[z][thr] = new BooleanMask2D(new Rectangle(sizeX, sizeY), new boolean[sliceSize]);
                }
                BooleanMask2D[] masks2D = masks[z];
                Object _in2D = input.getDataXY(t, z, c);
                block3: for (int i = 0; i < sliceSize; ++i) {
                    double val = Array1DUtil.getValue((Object)_in2D, (int)i, (DataType)dataType);
                    if (val < thr0) continue;
                    if (lastThresholdIndex > 0) {
                        for (int thr = lastThresholdIndex; thr > 0; --thr) {
                            if (!(val >= thresholds[thr])) continue;
                            masks2D[thr].mask[i] = true;
                            if (isValidSlice[z]) continue block3;
                            isValidSlice[z] = true;
                            continue block3;
                        }
                    }
                    masks2D[0].mask[i] = true;
                    if (isValidSlice[z]) continue;
                    isValidSlice[z] = true;
                }
            }
            for (int thr = 0; thr < thresholds.length; ++thr) {
                ROI3DArea area3D = null;
                ROI2DArea area2D = null;
                for (int z = 0; z < depth; ++z) {
                    if (!isValidSlice[z]) continue;
                    area2D = new ROI2DArea(masks[z][thr]);
                    if (depth > 1) {
                        if (area3D == null) {
                            area3D = new ROI3DArea();
                            area3D.setName("Threshold: " + thresholds[thr]);
                            area3D.setT(sizeT == 1 ? -1 : t);
                        }
                        area3D.setSlice(z, (ROI2D)area2D, false);
                        continue;
                    }
                    area2D.setName("Threshold: " + thresholds[thr]);
                    area2D.setT(sizeT == 1 ? -1 : t);
                }
                if (area3D != null) {
                    output.add(area3D);
                    continue;
                }
                if (area2D == null) continue;
                output.add(area2D);
            }
        }
        return output.toArray(new ROI[output.size()]);
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        this.blockMode = true;
        this.in.getVariable().setOptional(true);
        inputMap.add("Input", (Var)this.in.getVariable());
        inputMap.add("channel", this.channel.getVariable());
        inputMap.add("Manual thresholds", this.thresholds.getVariable());
        inputMap.add("Treat as percentiles", this.pct.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.outLabels);
        outputMap.add("ROI", (Var)this.outROI);
    }

    private static enum ThresholdOutput {
        SEQUENCE("Labeled sequence"),
        ROI("Single ROI"),
        MULTI_ROI("Multiple ROI");

        final String description;

        private ThresholdOutput(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static enum ThresholdMethod {
        MANUAL,
        K_MEANS;

    }
}

