/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContrastMethodEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContrastMethodEnumHandler.class);
    private static final Hashtable<String, String> patterns = ContrastMethodEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Brightfield\\s*", "Brightfield");
        p.put("^\\s*Phase\\s*", "Phase");
        p.put("^\\s*DIC\\s*", "DIC");
        p.put("^\\s*HoffmanModulation\\s*", "HoffmanModulation");
        p.put("^\\s*ObliqueIllumination\\s*", "ObliqueIllumination");
        p.put("^\\s*PolarizedLight\\s*", "PolarizedLight");
        p.put("^\\s*Darkfield\\s*", "Darkfield");
        p.put("^\\s*Fluorescence\\s*", "Fluorescence");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return ContrastMethod.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"ContrastMethod", (Object)value);
        return ContrastMethod.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return ContrastMethod.class;
    }
}

