/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.intensity;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import plugins.kernel.roi.descriptor.intensity.ROIIntensityDescriptorsPlugin;

public class ROIMaxIntensityDescriptor
extends ROIDescriptor {
    public static final String ID = "Max intensity";

    public ROIMaxIntensityDescriptor() {
        super(ID, "Max Intensity", Double.class);
    }

    @Override
    public String getDescription() {
        return "Maximum intensity";
    }

    @Override
    public boolean separateChannel() {
        return true;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIMaxIntensityDescriptor.computeMaxIntensity(roi, sequence);
    }

    public static double computeMaxIntensity(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        try {
            return ROIIntensityDescriptorsPlugin.computeIntensityDescriptors((ROI)roi, (Sequence)sequence, (boolean)false).max;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.valueOf(ROIMaxIntensityDescriptor.class.getSimpleName()) + ": cannot compute descriptors for '" + roi.getName() + "'", e);
        }
    }
}

