/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.file.FileUtil;
import icy.main.Icy;
import icy.preferences.GeneralPreferences;
import icy.system.thread.ThreadUtil;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SaveDialog {
    public static String chooseFile(String title, String defaultDir, String defaultName, String extension) {
        SaveDialogRunner runner = new SaveDialogRunner(title, defaultDir, defaultName, extension);
        if (Icy.getMainInterface().isHeadLess()) {
            return null;
        }
        ThreadUtil.invokeNow(runner);
        return runner.result;
    }

    public static String chooseFile(String title, String defaultDir, String defaultName) {
        return SaveDialog.chooseFile(title, defaultDir, defaultName, null);
    }

    public static String chooseFile(String defaultDir, String defaultName) {
        return SaveDialog.chooseFile("Save file...", defaultDir, defaultName);
    }

    public static String chooseFile() {
        return SaveDialog.chooseFile(null, null);
    }

    public static String chooseFileForResult(String title, String defaultName, String extension) {
        String dir = GeneralPreferences.getResultFolder();
        FileUtil.createDir(dir);
        String result = SaveDialog.chooseFile(title, dir, defaultName, extension);
        if (result != null) {
            GeneralPreferences.setResultFolder(FileUtil.getDirectory(result));
        }
        return result;
    }

    public static String chooseFileForResult(String defaultName, String extension) {
        return SaveDialog.chooseFileForResult("Save file...", defaultName, extension);
    }

    public static String chooseFileForResult(String defaultName) {
        return SaveDialog.chooseFileForResult("Save file...", defaultName, null);
    }

    private static class SaveDialogRunner
    implements Runnable {
        private final String title;
        private final String defaultDir;
        private final String defaultName;
        private final String extension;
        private JFileChooser dialog;
        String result;

        public SaveDialogRunner(String title, String defaultDir, String defaultName, String extension) {
            this.title = title;
            this.defaultDir = defaultDir;
            this.defaultName = defaultName;
            this.extension = extension;
        }

        @Override
        public void run() {
            int ret;
            int returnVal;
            this.result = null;
            String defaultFileName = this.defaultName != null && this.extension != null ? FileUtil.setExtension(this.defaultName, this.extension) : this.defaultName;
            if (this.dialog == null) {
                this.dialog = new JFileChooser();
            }
            this.dialog.setDialogTitle(this.title);
            if (this.defaultDir != null) {
                this.dialog.setCurrentDirectory(new File(this.defaultDir));
            }
            if (defaultFileName != null) {
                this.dialog.setSelectedFile(new File(defaultFileName));
            }
            if ((returnVal = this.dialog.showSaveDialog(null)) != 0) {
                return;
            }
            File f = this.dialog.getSelectedFile();
            if (f.exists() && (ret = JOptionPane.showConfirmDialog(this.dialog, "The file " + f.getName() + " already exists. \nWould you like to replace it ?", "Replace ?", 0, 2)) != 0) {
                return;
            }
            this.result = f.getAbsolutePath();
        }
    }
}

