/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.proj4.EquidistantAzimuthalProjection;

public class AzimuthalEquidistant
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "azimuthal_equidistant";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        this.readStandardParams(ds, ctv);
        if (this.earth == null) {
            this.earth = this.earth_radius > 0.0 ? new Earth(this.earth_radius * 1000.0) : new Earth();
        }
        EquidistantAzimuthalProjection proj = new EquidistantAzimuthalProjection(this.lat0, this.lon0, this.false_easting, this.false_northing, this.earth);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

