/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.geom.Voxel3DComparable;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.Chrono;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.Logger.IJStatus;
import mcib3d.utils.ThreadUtil;

public abstract class ImageInt
extends ImageHandler {
    public ImageInt(ImagePlus img) {
        super(img);
    }

    public ImageInt(ImageStack img) {
        super(img);
    }

    public ImageInt(String title, int sizeX, int sizeY, int sizeZ) {
        super(title, sizeX, sizeY, sizeZ);
    }

    public ImageInt(ImageHandler im, boolean scaling) {
        super(im.title, im.sizeX, im.sizeY, im.sizeZ, im.offsetX, im.offsetY, im.offsetZ);
    }

    protected ImageInt(String title, int sizeX, int sizeY, int sizeZ, int offsetX, int offsetY, int offsetZ) {
        super(title, sizeX, sizeY, sizeZ, offsetX, offsetY, offsetZ);
    }

    public static ImageInt wrap(ImagePlus imp) {
        switch (imp.getBitDepth()) {
            case 8: {
                return new ImageByte(imp);
            }
            case 16: {
                return new ImageShort(imp);
            }
            case 32: {
                return new ImageShort(ImageHandler.wrap(imp), true);
            }
        }
        return null;
    }

    public static ImageInt wrap(ImageStack stack) {
        switch (stack.getBitDepth()) {
            case 8: {
                return new ImageByte(stack);
            }
            case 16: {
                return new ImageShort(stack);
            }
            case 32: {
                return new ImageShort(ImageHandler.wrap(stack), true);
            }
        }
        return null;
    }

    public abstract void setPixel(int var1, int var2, int var3, int var4);

    public abstract void setPixel(int var1, int var2, int var3);

    public abstract void setPixelCross3D(int var1, int var2, int var3, int var4);

    public abstract void draw(Object3D var1, int var2);

    public abstract int getPixelInt(int var1, int var2);

    public abstract int getPixelInt(int var1, int var2, int var3);

    public abstract int getPixelInt(int var1);

    @Override
    public abstract float getPixel(Point3D var1);

    public abstract int getPixelInt(Point3D var1);

    @Override
    public abstract float getPixelInterpolated(Point3D var1);

    public abstract int getPixelIntInterpolated(Point3D var1);

    public TreeMap<Integer, int[]> getBounds(boolean addBorder) {
        TreeMap<Integer, int[]> bounds = new TreeMap<Integer, int[]>();
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int x = 0; x < this.sizeX; ++x) {
                    int value = this.getPixelInt(x + y * this.sizeX, z);
                    if (value == 0) continue;
                    int[] bds = bounds.get(value);
                    if (bds != null) {
                        if (x < bds[0]) {
                            bds[0] = x;
                        } else if (x > bds[1]) {
                            bds[1] = x;
                        }
                        if (y < bds[2]) {
                            bds[2] = y;
                        } else if (y > bds[3]) {
                            bds[3] = y;
                        }
                        if (z < bds[4]) {
                            bds[4] = z;
                        } else if (z > bds[5]) {
                            bds[5] = z;
                        }
                        bds[6] = bds[6] + 1;
                        continue;
                    }
                    int[] nb = new int[]{x, x, y, y, z, z, 1};
                    bounds.put(value, nb);
                }
            }
        }
        if (addBorder) {
            for (int[] bds : bounds.values()) {
                bds[0] = bds[0] - 1;
                bds[1] = bds[1] + 1;
                bds[2] = bds[2] - 1;
                bds[3] = bds[3] + 1;
                bds[4] = bds[4] - 1;
                bds[5] = bds[5] + 1;
            }
        }
        return bounds;
    }

    public ArrayList<Integer> getUniqueValues(int th) {
        boolean[] vals = new boolean[(int)(this.getMax() + 1.0)];
        Arrays.fill(vals, false);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int c = 0; c < this.sizeXYZ; ++c) {
            int pix = this.getPixelInt(c);
            if (pix <= th || vals[pix]) continue;
            vals[pix] = true;
            list.add(pix);
        }
        return list;
    }

    public ArrayList<Integer> getUniqueValues() {
        return this.getUniqueValues(-1);
    }

    @Override
    public abstract ImageInt crop3D(String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract ImageByte crop3DBinary(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract boolean shiftIndexes(TreeMap<Integer, int[]> var1);

    public abstract ImageInt[] crop3D(TreeMap<Integer, int[]> var1);

    @Override
    public abstract ImageInt crop3DMask(String var1, ImageInt var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public ImageByte[] crop3DBinary(TreeMap<Integer, int[]> bounds) {
        ImageByte[] ihs = new ImageByte[bounds.size()];
        ArrayList<Integer> keys = new ArrayList<Integer>(bounds.keySet());
        for (int idx = 0; idx < ihs.length; ++idx) {
            int label = keys.get(idx);
            int[] bds = bounds.get(label);
            ihs[idx] = this.crop3DBinary(this.title + ":" + label, label, bds[0], bds[1], bds[2], bds[3], bds[4], bds[5]);
        }
        return ihs;
    }

    public ImageByte[] crop3DBinary() {
        TreeMap<Integer, int[]> bounds = this.getBounds(false);
        return this.crop3DBinary(bounds);
    }

    @Override
    public ImageInt cropRadius(int xc, int yc, int zc, int rx, int ry, int rz, boolean mean, boolean sphere) {
        int x0 = Math.max(0, xc - rx);
        int y0 = Math.max(0, yc - ry);
        int z0 = Math.max(0, zc - rz);
        int x1 = Math.min(this.sizeX, xc + rx);
        int y1 = Math.min(this.sizeY, yc + ry);
        int z1 = Math.min(this.sizeZ, zc + rz);
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        double rz2 = rz * rz;
        int moy = 0;
        if (mean) {
            ImageStats s = this.getImageStats(null);
            moy = (int)s.getMean();
        }
        ImageInt res = this instanceof ImageByte ? new ImageByte("crop" + this.title, x1 - x0 + 1, y1 - y0 + 1, z1 - z0 + 1) : new ImageShort("crop" + this.title, x1 - x0 + 1, y1 - y0 + 1, z1 - z0 + 1);
        for (int z = zc - rz; z <= z1; ++z) {
            for (int x = xc - rx; x <= x1; ++x) {
                for (int y = yc - ry; y <= y1; ++y) {
                    if (sphere) {
                        double r = (double)((x - xc) * (x - xc)) / rx2 + (double)((y - yc) * (y - yc)) / ry2 + (double)((z - zc) * (z - zc)) / rz2;
                        if (r <= 1.0) {
                            res.setPixel(x - xc + rx, y - yc + ry, z - zc + rz, this.getPixelInt(x, y, z));
                            continue;
                        }
                        res.setPixel(x - xc + rx, y - yc + ry, z - zc + rz, moy);
                        continue;
                    }
                    res.setPixel(x - xc + rx, y - yc + ry, z - zc + rz, this.getPixelInt(x, y, z));
                }
            }
        }
        return res;
    }

    public Object3DVoxels[] getObjects3D() {
        ImageLabeller imageLabeller = new ImageLabeller();
        Object3DVoxels[] object3DVoxelses = new Object3DVoxels[imageLabeller.getNbObjectsTotal(this)];
        return imageLabeller.getObjects(this).toArray(object3DVoxelses);
    }

    public Object3DVoxels getObjectMask() {
        ArrayList<Voxel3D> vox = new ArrayList<Voxel3D>();
        int value = (int)this.getMinAboveValue(0.0f);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int x = 0; x < this.sizeX; ++x) {
                    if (this.getPixel(x, y, z) == 0.0f) continue;
                    vox.add(new Voxel3D(x, y, z, value));
                }
            }
        }
        Object3DVoxels obj = new Object3DVoxels(vox);
        obj.setResXY(this.getScaleXY());
        obj.setResZ(this.getScaleZ());
        obj.setLabelImage(this);
        return obj;
    }

    public Objects3DPopulation getObjects3DPopulation() {
        return new Objects3DPopulation(this.getObjects3D(), this.getCalibration());
    }

    public Object3DVoxels getObject3DBackground(ImageInt mask) {
        ArrayList<Voxel3D> al = new ArrayList<Voxel3D>();
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f || this.getPixel(xy, z) != 0.0f) continue;
                al.add(new Voxel3D(xy % this.sizeX, xy / this.sizeX, z, 0.0f));
            }
        }
        if (al.isEmpty()) {
            return new Object3DVoxels(0);
        }
        return new Object3DVoxels(al);
    }

    public ImageFloat getDistanceMapInsideMask(int nbCPUs) {
        return EDT.run(this, 0.0f, false, nbCPUs);
    }

    public ImageByte erode(float erodeRadius, int nbCPUs) {
        ImageFloat dm = this.getDistanceMapInsideMask(nbCPUs);
        return dm.threshold(erodeRadius, false, true);
    }

    public void replacePixelsValue(int val, int rep) {
        for (int k = 0; k < this.sizeXYZ; ++k) {
            if (this.getPixel(k) != (float)val) continue;
            this.setPixel(k, (float)rep);
        }
    }

    public void replacePixelsValue(int val1, int rep1, int val2, int rep2) {
        for (int k = 0; k < this.sizeXYZ; ++k) {
            if (this.getPixel(k) == (float)val1) {
                this.setPixel(k, (float)rep1);
                continue;
            }
            if (this.getPixel(k) != (float)val2) continue;
            this.setPixel(k, (float)rep2);
        }
    }

    public void replacePixelsValue(int[] values, int[] replace) {
        block0: for (int k = 0; k < this.sizeXYZ; ++k) {
            int pix = this.getPixelInt(k);
            for (int i = 0; i < values.length; ++i) {
                if (pix != values[i]) continue;
                this.setPixel(k, (float)replace[i]);
                continue block0;
            }
        }
    }

    public void replacePixelsValue(int[] values, int replace) {
        block0: for (int k = 0; k < this.sizeXYZ; ++k) {
            int pix = this.getPixelInt(k);
            for (int i = 0; i < values.length; ++i) {
                if (pix != values[i]) continue;
                this.setPixel(k, (float)replace);
                continue block0;
            }
        }
    }

    public boolean isBinary(int background) {
        float mi1 = this.getMinAboveValue(background);
        float mi2 = this.getMinAboveValue(mi1);
        return mi2 == Float.MAX_VALUE;
    }

    public boolean isBinary() {
        return this.isBinary(0);
    }

    @Override
    public abstract ImageInt resample(int var1, int var2, int var3, int var4);

    @Override
    public abstract ImageInt resample(int var1, int var2);

    public abstract ImageByte toMask();

    public ImageByte toCenterMask() {
        Object3DVoxels[] os;
        ImageByte res = new ImageByte("mask", this.sizeX, this.sizeY, this.sizeZ);
        res.setScale(this);
        res.setOffset(this);
        for (Object3DVoxels o : os = this.getObjects3D()) {
            res.setPixel(o.getCenterAsPoint(), 255.0f);
        }
        return res;
    }

    public abstract int countMaskVolume();

    public ImageInt addImage(ImageInt other) {
        if (!this.sameDimensions(other)) {
            return null;
        }
        ImageInt res = this instanceof ImageByte && other instanceof ImageByte ? (ImageInt)this.createSameDimensions() : new ImageShort("add", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, (float)(this.getPixelInt(i) + other.getPixelInt(i)));
        }
        return res;
    }

    public ImageInt diffAbsImage(ImageHandler other) {
        if (!this.sameDimensions(other)) {
            return null;
        }
        ImageInt res = this instanceof ImageByte && other instanceof ImageByte ? (ImageInt)this.createSameDimensions() : new ImageShort("diff", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, Math.abs(this.getPixel(i) - other.getPixel(i)));
        }
        return res;
    }

    @Override
    public abstract ImageInt duplicate();

    public ImageInt substractImage(ImageInt other) {
        if (!this.sameDimensions(other)) {
            return null;
        }
        ImageInt res = this instanceof ImageByte && other instanceof ImageByte ? (ImageInt)this.createSameDimensions() : new ImageShort("add", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, (float)(this.getPixelInt(i) - other.getPixelInt(i)));
        }
        return res;
    }

    public ImageInt invertMask(ImageInt mask) {
        ImageByte res = new ImageByte("mask", mask.sizeX, mask.sizeY, mask.sizeZ);
        int value = -1;
        for (int z = 0; z < res.sizeZ; ++z) {
            for (int xy = 0; xy < res.sizeXY; ++xy) {
                if (mask.getPixelInt(xy, z) == 0 || this.getPixelInt(xy, z) != 0) continue;
                res.setPixel(xy, z, value);
            }
        }
        return res;
    }

    public boolean hasOneValueInt(int f) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixelInt(i) != f) continue;
            return true;
        }
        return false;
    }

    public Voxel3D firstVoxelValueInt(int f) {
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    if (this.getPixelInt(i, j, k) != f) continue;
                    return new Voxel3D(i, j, k, f);
                }
            }
        }
        return null;
    }

    public void filterGeneric(ImageInt out, float radx, float rady, float radz, int zmin, int zmax, int filter) {
        this.filterGeneric(out, radx, rady, radz, zmin, zmax, filter, null, null);
    }

    public void filterGeneric(ImageInt out, float radx, float rady, float radz, int zmin, int zmax, int filter, Chrono timer, AbstractLog log) {
        int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = FastFilters3D.getNbFromKernel(ker);
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    ArrayUtil tab = this.getNeighborhoodKernel(ker, nb, i, j, k, radx, rady, radz);
                    if (filter == 0) {
                        out.setPixel(i, j, k, (int)(tab.getMean() + 0.5));
                    } else if (filter == 1) {
                        out.setPixel(i, j, k, (int)tab.medianSort());
                    }
                    if (filter == 2) {
                        out.setPixel(i, j, k, (int)tab.getMinimum());
                    }
                    if (filter == 3) {
                        out.setPixel(i, j, k, (int)tab.getMaximum());
                    }
                    if (filter == 8) {
                        out.setPixel(i, j, k, (int)(tab.getVariance2() + 0.5));
                    }
                    if (filter != 4) continue;
                    int value = this.getPixelInt(i, j, k);
                    if (tab.isMaximum(value)) {
                        out.setPixel(i, j, k, value);
                        continue;
                    }
                    out.setPixel(i, j, k, 0);
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            log.log("3D filtering : " + ti);
        }
    }

    public ArrayList<Voxel3DComparable> getListMaxima(float radx, float rady, float radz, int zmin, int zmax) {
        return this.getListMaxima(radx, rady, radz, zmin, zmax, null, null);
    }

    public ArrayList<Voxel3DComparable> getListMaxima(float radx, float rady, float radz, int zmin, int zmax, Chrono timer, AbstractLog log) {
        ArrayList<Voxel3DComparable> res = new ArrayList<Voxel3DComparable>();
        int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = FastFilters3D.getNbFromKernel(ker);
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    int value;
                    ArrayUtil tab = this.getNeighborhoodKernel(ker, nb, i, j, k, radx, rady, radz);
                    if (!tab.isMaximum(value = this.getPixelInt(i, j, k))) continue;
                    res.add(new Voxel3DComparable(i, j, k, value, 1.0));
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            log.log("3D maxima : " + ti);
        }
        return res;
    }

    public void filterGeneric(ImageInt out, Object3DVoxels obj, int zmin, int zmax, int filter) {
        this.filterGeneric(out, obj, zmin, zmax, filter, null, null);
    }

    public void filterGeneric(ImageInt out, Object3DVoxels obj, int zmin, int zmax, int filter, Chrono timer, AbstractLog log) {
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        int[] ker = FastFilters3D.createKernelFromObject(obj);
        int nb = FastFilters3D.getNbFromKernel(ker);
        float[] rad = FastFilters3D.getRadiiFromObject(obj);
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            IJ.showStatus((String)("3D filter : " + (k + 1) + "/" + zmax));
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    ArrayUtil tab = this.getNeighborhoodKernel(ker, nb, i, j, k, rad[0], rad[1], rad[2]);
                    if (filter == 0) {
                        out.setPixel(i, j, k, (int)(tab.getMean() + 0.5));
                    } else if (filter == 1) {
                        out.setPixel(i, j, k, (int)tab.medianSort());
                    }
                    if (filter == 2) {
                        out.setPixel(i, j, k, (int)tab.getMinimum());
                    }
                    if (filter == 3) {
                        out.setPixel(i, j, k, (int)tab.getMaximum());
                    }
                    if (filter == 8) {
                        out.setPixel(i, j, k, (int)(tab.getVariance2() + 0.5));
                    }
                    if (filter != 4) continue;
                    int value = this.getPixelInt(i, j, k);
                    if (tab.isMaximum(value)) {
                        out.setPixel(i, j, k, value);
                        continue;
                    }
                    out.setPixel(i, j, k, 0);
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            log.log("3D filtering : " + ti);
        }
    }

    public ImageInt sobelFilter() {
        ImageInt res = (ImageInt)this.createSameDimensions();
        double[] edgeX = new double[]{-1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -4.0, 0.0, 4.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0};
        double[] edgeY = new double[]{-1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, -2.0, -4.0, -2.0, 0.0, 0.0, 0.0, 2.0, 4.0, 2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0};
        double[] edgeZ = new double[]{-1.0, -2.0, -1.0, -2.0, -4.0, -2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 1.0};
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    double ez;
                    double ey;
                    ArrayUtil nei = this.getNeighborhood3x3x3(i, j, k);
                    double ex = nei.convolve(edgeX, 1.0);
                    double edge = Math.sqrt(ex * ex + (ey = nei.convolve(edgeY, 1.0)) * ey + (ez = nei.convolve(edgeZ, 1.0)) * ez);
                    if (edge > 65535.0 && this.getType() == 1) {
                        edge = 65535.0;
                    }
                    if (edge > 255.0 && this.getType() == 0) {
                        edge = 255.0;
                    }
                    res.setPixel(i, j, k, (int)edge);
                }
            }
        }
        return res;
    }

    public void adaptiveFilter(ImageInt filtered, float radx, float rady, float radz, int zmin, int zmax, Chrono timer, AbstractLog show) {
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = 0;
        for (int i = 0; i < ker.length; ++i) {
            nb += ker[i];
        }
        int nb2 = nb;
        float radX2 = radx;
        float radY2 = rady;
        float radZ2 = radz;
        ArrayUtil[] tab = new ArrayUtil[7];
        int dep = 1;
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    tab[0] = this.getNeighborhoodKernel(ker, nb2, i, j, k, radX2, radY2, radZ2);
                    tab[1] = this.getNeighborhoodKernel(ker, nb2, i + dep, j, k, radX2, radY2, radZ2);
                    tab[2] = this.getNeighborhoodKernel(ker, nb2, i - dep, j, k, radX2, radY2, radZ2);
                    tab[3] = this.getNeighborhoodKernel(ker, nb2, i, j + dep, k, radX2, radY2, radZ2);
                    tab[4] = this.getNeighborhoodKernel(ker, nb2, i, j - dep, k, radX2, radY2, radZ2);
                    tab[5] = this.getNeighborhoodKernel(ker, nb2, i, j, k + dep, radX2, radY2, radZ2);
                    tab[6] = this.getNeighborhoodKernel(ker, nb2, i, j, k - dep, radX2, radY2, radZ2);
                    double mes = 0.0;
                    double mins = 3.4028234663852886E38;
                    for (int c = 0; c < 7; ++c) {
                        double me = tab[c].getMean();
                        double si = tab[c].getStdDev();
                        if (!(si < mins)) continue;
                        mins = si;
                        mes = me;
                    }
                    filtered.setPixel(i, j, k, (int)mes);
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            show.log("3D filtering : " + ti);
        }
    }

    @Deprecated
    public ImageInt adaptiveFilter(float radx, float rady, float radz, int nbcpus) {
        final ImageInt adaptimg2 = (ImageInt)this.createSameDimensions();
        int nbToProcess = this.sizeZ;
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final IJStatus show = new IJStatus();
        final int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = 0;
        for (int i = 0; i < ker.length; ++i) {
            nb += ker[i];
        }
        final int nb2 = nb;
        final float radX2 = radx;
        final float radY2 = rady;
        final float radZ2 = radz;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = ThreadUtil.createThreadArray(nbcpus);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    ArrayUtil[] tab = new ArrayUtil[7];
                    int dep = 1;
                    int k = ai.getAndIncrement();
                    while (k < ImageInt.this.sizeZ) {
                        String ti;
                        for (int j = 0; j < ImageInt.this.sizeY; ++j) {
                            for (int i = 0; i < ImageInt.this.sizeX; ++i) {
                                tab[0] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i, j, k, radX2, radY2, radZ2);
                                tab[1] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i + dep, j, k, radX2, radY2, radZ2);
                                tab[2] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i - dep, j, k, radX2, radY2, radZ2);
                                tab[3] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i, j + dep, k, radX2, radY2, radZ2);
                                tab[4] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i, j - dep, k, radX2, radY2, radZ2);
                                tab[5] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i, j, k + dep, radX2, radY2, radZ2);
                                tab[6] = ImageInt.this.getNeighborhoodKernel(ker, nb2, i, j, k - dep, radX2, radY2, radZ2);
                                double mes = 0.0;
                                double mins = 3.4028234663852886E38;
                                for (int c = 0; c < 7; ++c) {
                                    double me = tab[c].getMean();
                                    double si = tab[c].getStdDev();
                                    if (!(si < mins)) continue;
                                    mins = si;
                                    mes = me;
                                }
                                adaptimg2.setPixel(i, j, k, (int)mes);
                            }
                        }
                        if (time != null && (ti = time.getFullInfo(1)) != null) {
                            show.log("3D adaptive : " + ti);
                        }
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threads);
        return adaptimg2;
    }
}

