package plugins.tprovoost.painting.shapes;

import java.awt.Point;
import java.awt.geom.Ellipse2D;

import plugins.tprovoost.painting.PaintingTools;

public class Oval extends PaintingShape
{

    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public Oval(PaintingTools tools, int x1, int y1, int x2, int y2)
    {
        this(tools, x1, y1, x2, y2, false);
    }

    public Oval(PaintingTools tools, int x1, int y1, int x2, int y2, boolean fill)
    {
        super(tools);

        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.fill = fill;

        int RX1;
        int RY1;
        int RX2;
        int RY2;
        if (x1 < x2)
        {
            RX1 = x1;
            RX2 = x2;
        }
        else
        {
            RX1 = x2;
            RX2 = x1;
        }
        if (y1 < y2)
        {
            RY1 = y1;
            RY2 = y2;
        }
        else
        {
            RY1 = y2;
            RY2 = y1;
        }
        int w = RX2 - RX1;
        int h = RY2 - RY1;
        shape = new Ellipse2D.Double(RX1, RY1, w, h);
    }

    public int getX1()
    {
        return x1;
    }

    public void setX1(int x1)
    {
        this.x1 = x1;
    }

    public int getY1()
    {
        return y1;
    }

    public void setY1(int y1)
    {
        this.y1 = y1;
    }

    @Override
    public void update(Point p)
    {
        x2 = p.x;
        y2 = p.y;

        int RX1;
        int RY1;
        int RX2;
        int RY2;
        if (x1 < x2)
        {
            RX1 = x1;
            RX2 = x2;
        }
        else
        {
            RX1 = x2;
            RX2 = x1;
        }
        if (y1 < y2)
        {
            RY1 = y1;
            RY2 = y2;
        }
        else
        {
            RY1 = y2;
            RY2 = y1;
        }
        int w = RX2 - RX1;
        int h = RY2 - RY1;
        ((Ellipse2D) shape).setFrame(RX1, RY1, w, h);
    }
}
