/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.kernel.roi.descriptor.property.ROIColorDescriptor;
import plugins.kernel.roi.descriptor.property.ROIIconDescriptor;
import plugins.kernel.roi.descriptor.property.ROIIdDescriptor;
import plugins.kernel.roi.descriptor.property.ROINameDescriptor;
import plugins.kernel.roi.descriptor.property.ROIOpacityDescriptor;
import plugins.kernel.roi.descriptor.property.ROIReadOnlyDescriptor;

public class ROIPropertyDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_ID = "Id";
    public static final String ID_ICON = "Icon";
    public static final String ID_NAME = "Name";
    public static final String ID_COLOR = "Color";
    public static final String ID_OPACITY = "Opacity";
    public static final String ID_READONLY = "Read only";
    public static final ROIIdDescriptor idDescriptor = new ROIIdDescriptor();
    public static final ROIIconDescriptor iconDescriptor = new ROIIconDescriptor();
    public static final ROINameDescriptor nameDescriptor = new ROINameDescriptor();
    public static final ROIColorDescriptor colorDescriptor = new ROIColorDescriptor();
    public static final ROIOpacityDescriptor opacityDescriptor = new ROIOpacityDescriptor();
    public static final ROIReadOnlyDescriptor readOnlyDescriptor = new ROIReadOnlyDescriptor();

    @Override
    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(idDescriptor);
        result.add(iconDescriptor);
        result.add(nameDescriptor);
        result.add(colorDescriptor);
        result.add(opacityDescriptor);
        result.add(readOnlyDescriptor);
        return result;
    }

    @Override
    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        try {
            result.put(idDescriptor, ROIIdDescriptor.getId(roi));
            result.put(iconDescriptor, ROIIconDescriptor.getIcon(roi));
            result.put(nameDescriptor, ROINameDescriptor.getName(roi));
            result.put(colorDescriptor, ROIColorDescriptor.getColor(roi));
            result.put(opacityDescriptor, Float.valueOf(ROIOpacityDescriptor.getOpacity(roi)));
            result.put(readOnlyDescriptor, ROIReadOnlyDescriptor.getReadOnly(roi));
        }
        catch (Exception e) {
            String mess = String.valueOf(this.getClass().getSimpleName()) + ": cannot compute descriptors for '" + roi.getName() + "'";
            throw new UnsupportedOperationException(mess, e);
        }
        return result;
    }
}

