/*
 * Decompiled with CFR 0.152.
 */
package icy.common;

import icy.common.CollapsibleEvent;
import icy.common.listener.ChangeListener;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;

public class UpdateEventHandler {
    ChangeListener parent;
    private boolean awtDispatch;
    private int updateCnt;
    private final LinkedHashMap<CollapsibleEvent, CollapsibleEvent> pendingChanges;

    public UpdateEventHandler(ChangeListener parent, boolean awtDispatch) {
        this.parent = parent;
        this.awtDispatch = awtDispatch;
        this.updateCnt = 0;
        this.pendingChanges = new LinkedHashMap();
    }

    public UpdateEventHandler(ChangeListener parent) {
        this(parent, false);
    }

    public boolean isAwtDispatch() {
        return this.awtDispatch;
    }

    public void setAwtDispatch(boolean awtDispatch) {
        this.awtDispatch = awtDispatch;
    }

    public Collection<CollapsibleEvent> getPendingChanges() {
        return this.pendingChanges.values();
    }

    public void beginUpdate() {
        ++this.updateCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        --this.updateCnt;
        if (this.updateCnt <= 0) {
            ArrayList<CollapsibleEvent> events;
            LinkedHashMap<CollapsibleEvent, CollapsibleEvent> linkedHashMap = this.pendingChanges;
            synchronized (linkedHashMap) {
                events = new ArrayList<CollapsibleEvent>(this.pendingChanges.values());
                this.pendingChanges.clear();
            }
            for (CollapsibleEvent event : events) {
                this.dispatchOnChanged(event);
            }
        }
    }

    public boolean isUpdating() {
        return this.updateCnt > 0;
    }

    public boolean hasPendingChanges() {
        return !this.pendingChanges.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPendingChange(CollapsibleEvent change) {
        CollapsibleEvent previousChange;
        LinkedHashMap<CollapsibleEvent, CollapsibleEvent> linkedHashMap = this.pendingChanges;
        synchronized (linkedHashMap) {
            previousChange = this.pendingChanges.get(change);
            if (previousChange == null) {
                this.pendingChanges.put(change, change);
            }
        }
        if (previousChange != null) {
            previousChange.collapse(change);
        }
    }

    public void changed(CollapsibleEvent event) {
        if (this.isUpdating()) {
            this.addPendingChange(event);
        } else {
            this.dispatchOnChanged(event);
        }
    }

    protected void dispatchOnChanged(CollapsibleEvent event) {
        final CollapsibleEvent e = event;
        if (this.awtDispatch) {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    UpdateEventHandler.this.parent.onChanged(e);
                }
            });
        } else {
            this.parent.onChanged(e);
        }
    }
}

