/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class ExtSSTInfoSubRecord
extends Record {
    public static final int INFO_SIZE = 8;
    public static final short sid = 4095;
    private int field_1_stream_pos;
    private short field_2_bucket_sst_offset;
    private short field_3_zero;

    public ExtSSTInfoSubRecord() {
    }

    public ExtSSTInfoSubRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_stream_pos = in.readInt();
        this.field_2_bucket_sst_offset = in.readShort();
        this.field_3_zero = in.readShort();
    }

    public void setStreamPos(int pos) {
        this.field_1_stream_pos = pos;
    }

    public void setBucketRecordOffset(short offset) {
        this.field_2_bucket_sst_offset = offset;
    }

    public int getStreamPos() {
        return this.field_1_stream_pos;
    }

    public short getBucketSSTOffset() {
        return this.field_2_bucket_sst_offset;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTSST]\n");
        buffer.append("    .streampos      = ").append(Integer.toHexString(this.getStreamPos())).append("\n");
        buffer.append("    .bucketsstoffset= ").append(Integer.toHexString(this.getBucketSSTOffset())).append("\n");
        buffer.append("    .zero           = ").append(Integer.toHexString(this.field_3_zero)).append("\n");
        buffer.append("[/EXTSST]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putInt(data, 0 + offset, this.getStreamPos());
        LittleEndian.putShort(data, 4 + offset, this.getBucketSSTOffset());
        LittleEndian.putShort(data, 6 + offset, (short)0);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 8;
    }

    @Override
    public short getSid() {
        return 4095;
    }
}

