/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int3D;
import mitiv.array.Int4D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.FlatInt3D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt4D;
import mitiv.array.impl.StriddenInt3D;
import mitiv.array.impl.StriddenInt4D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.IntGenerator;

public class FlatInt4D
extends Int4D {
    static final int order = 1;
    final int[] data;
    final int dim1dim2;
    final int dim1dim2dim3;

    public FlatInt4D(int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
        this.data = new int[this.number];
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
    }

    public FlatInt4D(int[] dims) {
        super(dims);
        this.data = new int[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatInt4D(Shape shape) {
        super(shape);
        this.data = new int[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatInt4D(int[] arr, int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
    }

    public FlatInt4D(int[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatInt4D(int[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(int[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1, int i2, int i3, int i4) {
        return this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1;
    }

    @Override
    public final int get(int i1, int i2, int i3, int i4) {
        return this.data[this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, int value) {
        this.data[this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(int value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextInt();
        }
    }

    @Override
    public void increment(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(IntFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        if (forceCopy) {
            int[] result = new int[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public Int3D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim4)) == 0) {
            return new FlatInt3D(this.data, this.dim1, this.dim2, this.dim3);
        }
        return new StriddenInt3D(this.data, this.dim1dim2dim3 * idx, 1, this.dim1, this.dim1dim2, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Int3D slice(int idx, int dim) {
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 4)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
        } else if (dim == 1) {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
        } else if (dim == 2) {
            sliceOffset = this.dim1dim2 * Helper.fixIndex(idx, this.dim3);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2dim3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
        } else {
            sliceOffset = this.dim1dim2dim3 * Helper.fixIndex(idx, this.dim4);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
        }
        return new StriddenInt3D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceDim1, sliceDim2, sliceDim3);
    }

    @Override
    public Int4D view(Range rng1, Range rng2, Range rng3, Range rng4) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.dim1dim2);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.dim1dim2dim3);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing()) {
            return this;
        }
        return new StriddenInt4D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber());
    }

    @Override
    public Int4D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.dim1dim2, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.dim1dim2dim3, this.dim4, sel4);
        return new SelectedInt4D(this.data, idx1, idx2, idx3, idx4);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.data, this.number);
    }
}

