/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.ArrayMath;
import icy.math.UnitUtil;

public class MathUtil {
    public static final String INFINITE_STRING = "\u221e";
    public static final double POW2_8_DOUBLE = Math.pow(2.0, 8.0);
    public static final float POW2_8_FLOAT = (float)POW2_8_DOUBLE;
    public static final double POW2_16_DOUBLE = Math.pow(2.0, 16.0);
    public static final float POW2_16_FLOAT = (float)POW2_16_DOUBLE;
    public static final double POW2_32_DOUBLE = Math.pow(2.0, 32.0);
    public static final float POW2_32_FLOAT = (float)POW2_32_DOUBLE;
    public static final double POW2_64_DOUBLE = Math.pow(2.0, 64.0);
    public static final float POW2_64_FLOAT = (float)POW2_64_DOUBLE;

    @Deprecated
    public static String getBytesString(double value) {
        return UnitUtil.getBytesString(value);
    }

    public static double frac(double value) {
        return value - Math.floor(value);
    }

    public static void normalize(float[] array) {
        float max = ArrayMath.max(array);
        if (max != 0.0f) {
            MathUtil.divide(array, max);
        } else {
            float min = ArrayMath.min(array);
            if (min != 0.0f) {
                MathUtil.divide(array, min);
            }
        }
    }

    public static void normalize(double[] array) {
        double max = ArrayMath.max(array);
        if (max != 0.0) {
            MathUtil.divide(array, max);
        } else {
            double min = ArrayMath.min(array);
            if (min != 0.0) {
                MathUtil.divide(array, min);
            }
        }
    }

    public static void log(double[] array) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = Math.log(array[i]);
            ++i;
        }
    }

    public static void log(float[] array) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = (float)Math.log(array[i]);
            ++i;
        }
    }

    public static void add(double[] array, double value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i] + value;
            ++i;
        }
    }

    public static void add(float[] array, float value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i] + value;
            ++i;
        }
    }

    public static void madd(double[] array, double mulValue, double addValue) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i] * mulValue + addValue;
            ++i;
        }
    }

    public static void madd(float[] array, float mulValue, float addValue) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i] * mulValue + addValue;
            ++i;
        }
    }

    public static void mul(double[] array, double value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i] * value;
            ++i;
        }
    }

    public static void mul(float[] array, float value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i] * value;
            ++i;
        }
    }

    public static void divide(double[] array, double value) {
        if (value != 0.0) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                array[i] = array[i] / value;
                ++i;
            }
        }
    }

    public static void divide(float[] array, float value) {
        if ((double)value != 0.0) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                array[i] = array[i] / value;
                ++i;
            }
        }
    }

    @Deprecated
    public static double min(Object array, boolean signed) {
        return ArrayMath.min(array, signed);
    }

    @Deprecated
    public static int min(byte[] array, boolean signed) {
        return ArrayMath.min(array, signed);
    }

    @Deprecated
    public static int min(short[] array, boolean signed) {
        return ArrayMath.min(array, signed);
    }

    @Deprecated
    public static long min(int[] array, boolean signed) {
        return ArrayMath.min(array, signed);
    }

    @Deprecated
    public static float min(float[] array) {
        return ArrayMath.min(array);
    }

    @Deprecated
    public static double min(double[] array) {
        return ArrayMath.min(array);
    }

    @Deprecated
    public static double max(Object array, boolean signed) {
        return ArrayMath.max(array, signed);
    }

    @Deprecated
    public static int max(byte[] array, boolean signed) {
        return ArrayMath.max(array, signed);
    }

    @Deprecated
    public static int max(short[] array, boolean signed) {
        return ArrayMath.max(array, signed);
    }

    @Deprecated
    public static long max(int[] array, boolean signed) {
        return ArrayMath.max(array, signed);
    }

    @Deprecated
    public static float max(float[] array) {
        return ArrayMath.max(array);
    }

    @Deprecated
    public static double max(double[] array) {
        return ArrayMath.max(array);
    }

    public static double roundSignificant(double d, int numDigit, boolean keepInteger) {
        if (numDigit <= 0 || d == 0.0) {
            return d;
        }
        double digit = Math.ceil(Math.log10(Math.abs(d)));
        if (digit >= (double)numDigit && keepInteger) {
            return Math.round(d);
        }
        return MathUtil.round(d, numDigit - (int)digit);
    }

    public static double roundSignificant(double d, int numDigit) {
        return MathUtil.roundSignificant(d, numDigit, false);
    }

    public static double round(double d, int numDecimal) {
        double pow = Math.pow(10.0, numDecimal);
        return (double)Math.round(d * pow) / pow;
    }

    public static double prevMultiple(double value, double mul) {
        if (mul == 0.0) {
            return 0.0;
        }
        return Math.floor(value / mul) * mul;
    }

    public static double nextMultiple(double value, double mul) {
        if (mul == 0.0) {
            return 0.0;
        }
        return Math.ceil(value / mul) * mul;
    }

    public static long nextPow2(long value) {
        long result;
        if (value < 0L) {
            result = -1L;
            while (result > value) {
                result <<= 1;
            }
            result >>= 1;
        } else {
            result = 1L;
            while (result <= value) {
                result <<= 1;
            }
        }
        return result;
    }

    public static long nextPow2Mask(long value) {
        long result = MathUtil.nextPow2(value);
        if (value > 0L) {
            return result - 1L;
        }
        return result;
    }

    public static long prevPow2(long value) {
        long result;
        if (value < 0L) {
            result = -1L;
            while (result >= value) {
                result <<= 1;
            }
        } else {
            result = 1L;
            while (result < value) {
                result <<= 1;
            }
            result >>= 1;
        }
        return result;
    }

    public static double nextPow10(double value) {
        if (value == 0.0) {
            return 0.0;
        }
        if (value < 0.0) {
            return -Math.pow(10.0, Math.floor(Math.log10(-value)));
        }
        return Math.pow(10.0, Math.ceil(Math.log10(value)));
    }

    public static double prevPow10(double value) {
        if (value == 0.0) {
            return 0.0;
        }
        if (value < 0.0) {
            return -Math.pow(10.0, Math.ceil(Math.log10(-value)));
        }
        return Math.pow(10.0, Math.floor(Math.log10(value)));
    }

    public static double formatDegreeAngle(double angle) {
        double res = angle % 360.0;
        if (res < 0.0) {
            return 360.0 + res;
        }
        return res;
    }

    public static double formatDegreeAngle2(double angle) {
        double res = angle % 360.0;
        if (res < -180.0) {
            return 360.0 + res;
        }
        if (res > 180.0) {
            return res - 360.0;
        }
        return res;
    }

    public static double formatRadianAngle(double angle) {
        double res = angle % (Math.PI * 2);
        if (res < 0.0) {
            return Math.PI * 2 + res;
        }
        return res;
    }

    public static double formatRadianAngle2(double angle) {
        double res = angle % (Math.PI * 2);
        if (res < -Math.PI) {
            return Math.PI * 2 + res;
        }
        if (res > Math.PI) {
            return res - Math.PI * 2;
        }
        return res;
    }

    public static double closest(double value, double[] source) {
        if (source == null || source.length == 0) {
            return 0.0;
        }
        double result = source[0];
        double minDelta = Math.abs(value - result);
        double[] dArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            double delta = Math.abs(value - d);
            if (delta < minDelta) {
                result = d;
                minDelta = delta;
            }
            ++n2;
        }
        return result;
    }

    public static double cubicRoot(double value) {
        return Math.pow(value, 0.3333333333333333);
    }
}

