/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5DoubleReader;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.IndexMap;
import ch.systemsx.cisd.hdf5.MatrixUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Map;

class HDF5DoubleWriter
extends HDF5DoubleReader
implements IHDF5DoubleWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5DoubleWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(final String objectPath, final String name, final double value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                if (((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(new long[]{1L}, registry);
                    HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, dataSpaceId, new double[]{value}, registry);
                } else {
                    HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, -1, new double[]{value}, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setArrayAttr(final String objectPath, final String name, final double[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(new long[]{value.length}, registry);
                    HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, dataSpaceId, value, registry);
                } else {
                    int memoryTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, value.length, registry);
                    int storageTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_IEEE_F64LE, value.length, registry);
                    HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, -1, value, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(final String objectPath, final String name, final MDDoubleArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(value.longDimensions(), registry);
                    HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, dataSpaceId, value.getAsFlatArray(), registry);
                } else {
                    int memoryTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, value.dimensions(), registry);
                    int storageTypeId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_IEEE_F64LE, value.dimensions(), registry);
                    HDF5DoubleWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, -1, value.getAsFlatArray(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setMatrixAttr(String objectPath, String name, double[][] value) {
        this.setMDArrayAttr(objectPath, name, new MDDoubleArray(value));
    }

    @Override
    public void write(String objectPath, double value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_IEEE_F64LE, HDF5Constants.H5T_NATIVE_DOUBLE, value);
    }

    @Override
    public void writeArray(String objectPath, double[] data) {
        this.writeArray(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final double[] data, final HDF5FloatStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DoubleWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_IEEE_F64LE, new long[]{data.length}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(String objectPath, int size) {
        this.createArray(objectPath, size, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, long size, int blockSize) {
        this.createArray(objectPath, size, blockSize, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void createArray(final String objectPath, final int size, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, new long[1], new long[]{size}, 8, registry);
                } else {
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, new long[]{size}, null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createArray(final String objectPath, final long size, final int blockSize, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeArrayBlock(String objectPath, double[] data, long blockNumber) {
        this.writeArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final double[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileId, objectPath, ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMatrix(String objectPath, double[][] data) {
        this.writeMatrix(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void writeMatrix(String objectPath, double[][] data, HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeMDArray(objectPath, new MDDoubleArray(data), features);
    }

    @Override
    public void createMatrix(String objectPath, int sizeX, int sizeY) {
        assert (objectPath != null);
        assert (sizeX >= 0);
        assert (sizeY >= 0);
        this.createMDArray(objectPath, new int[]{sizeX, sizeY});
    }

    @Override
    public void createMatrix(String objectPath, int sizeX, int sizeY, HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0);
        assert (sizeY >= 0);
        this.createMDArray(objectPath, new int[]{sizeX, sizeY}, features);
    }

    @Override
    public void createMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.createMDArray(objectPath, new long[]{sizeX, sizeY}, new int[]{blockSizeX, blockSizeY});
    }

    @Override
    public void createMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.createMDArray(objectPath, new long[]{sizeX, sizeY}, new int[]{blockSizeX, blockSizeY}, features);
    }

    @Override
    public void writeMatrixBlock(String objectPath, double[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlock(objectPath, new MDDoubleArray(data), new long[]{blockNumberX, blockNumberY});
    }

    @Override
    public void writeMatrixBlockWithOffset(String objectPath, double[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    @Override
    public void writeMatrixBlockWithOffset(String objectPath, double[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    @Override
    public void writeMDArray(String objectPath, MDDoubleArray data) {
        this.writeMDArray(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void writeMDArraySlice(String objectPath, MDDoubleArray data, IndexMap boundIndices) {
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), null, (Map<Integer, Long>)boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArraySlice(String objectPath, MDDoubleArray data, long[] boundIndices) {
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), null, boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArray(final String objectPath, final MDDoubleArray data, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DoubleWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_IEEE_F64LE, data.longDimensions(), 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createMDArray(String objectPath, int[] dimensions) {
        this.createMDArray(objectPath, dimensions, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createMDArray(objectPath, dimensions, blockDimensions, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(final String objectPath, final int[] dimensions, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, nullDimensions, MDArray.toLong(dimensions), 8, registry);
                } else {
                    HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, MDArray.toLong(dimensions), null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5DoubleWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F64LE, features, dimensions, MDArray.toLong(blockDimensions), 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, MDDoubleArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeSlicedMDArrayBlock(String objectPath, MDDoubleArray data, long[] blockNumber, IndexMap boundIndices) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeSlicedMDArrayBlockWithOffset(objectPath, data, offset, boundIndices);
    }

    @Override
    public void writeSlicedMDArrayBlock(String objectPath, MDDoubleArray data, long[] blockNumber, long[] boundIndices) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeSlicedMDArrayBlockWithOffset(objectPath, data, offset, boundIndices);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDDoubleArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileId, objectPath, ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeSlicedMDArrayBlockWithOffset(String objectPath, MDDoubleArray data, long[] offset, IndexMap boundIndices) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), offset, (Map<Integer, Long>)boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeSlicedMDArrayBlockWithOffset(String objectPath, MDDoubleArray data, long[] offset, long[] boundIndices) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), offset, boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDDoubleArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDDoubleArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileId, objectPath, ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5DoubleWriter)HDF5DoubleWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

