/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class TextField<T>
extends SwingVarEditor<T> {
    protected ActionListener actionListener;
    protected FocusListener focusListener;
    protected KeyListener keyListener;

    public TextField(Var<T> variable) {
        super(variable);
    }

    @Override
    public JComponent createEditorComponent() {
        JTextField jTextField = new JTextField();
        this.initializeComponent(jTextField);
        return jTextField;
    }

    protected void initializeComponent(final JTextField jTextField) {
        jTextField.setText(this.getVariable().getValueAsString());
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextField.this.setVariableValue(jTextField);
            }
        };
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TextField.this.setVariableValue(jTextField);
            }
        };
        this.keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    TextField.this.variable.parse(jTextField.getText());
                    jTextField.setForeground(Color.black);
                }
                catch (Exception ex) {
                    jTextField.setForeground(Color.red);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
    }

    protected void setVariableValue(JTextField jTextField) {
        try {
            if (this.variable.getReference() == null) {
                this.variable.setValue(this.variable.parse(jTextField.getText()));
            }
            jTextField.setForeground(Color.black);
            jTextField.setToolTipText(null);
        }
        catch (RuntimeException e) {
            jTextField.setForeground(Color.red);
            jTextField.setToolTipText("Cannot convert input into a " + this.getVariable().getTypeAsString());
        }
    }

    @Override
    protected void updateInterfaceValue() {
        this.getEditorComponent().setText(this.variable.getValueAsString(true));
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public JTextField getEditorComponent() {
        return (JTextField)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        this.getEditorComponent().addActionListener(this.actionListener);
        this.getEditorComponent().addFocusListener(this.focusListener);
        this.getEditorComponent().addKeyListener(this.keyListener);
    }

    @Override
    protected void deactivateListeners() {
        this.getEditorComponent().removeActionListener(this.actionListener);
        this.getEditorComponent().removeFocusListener(this.focusListener);
        this.getEditorComponent().removeKeyListener(this.keyListener);
    }
}

