/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.filtering;

import Jama.Matrix;
import plugins.nchenouard.particletracking.VirtualSpot;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.filtering.Predictor2D;
import plugins.nchenouard.spot.Spot;

public class KF2dRandomWalk
extends KalmanFilter
implements Predictor2D {
    double refVarX = 9.0;
    double refVarY = 9.0;

    public KF2dRandomWalk() {
        this.initMatrices();
    }

    @Override
    public Matrix buildMeasurementMatrix(Spot s) {
        if (s == null) {
            return null;
        }
        return new Matrix((double[][])new double[][]{{s.mass_center.x}, {s.mass_center.y}});
    }

    @Override
    Matrix buildX0(Matrix firstElement) {
        Matrix x0 = new Matrix(2, 1);
        x0.set(0, 0, firstElement.get(0, 0));
        x0.set(1, 0, firstElement.get(1, 0));
        return x0;
    }

    @Override
    Matrix getP0() {
        double[][] p0 = new double[][]{{0.1, 0.0}, {0.0, 0.1}};
        return new Matrix((double[][])p0);
    }

    @Override
    public void setTrackingCovariances(double[] trackingCov) {
        this.Q.set(0, 0, trackingCov[0]);
        this.Q.set(1, 1, trackingCov[1]);
        this.refVarX = trackingCov[0];
        this.refVarY = trackingCov[1];
        this.Q0 = this.Q;
    }

    @Override
    public Spot buildSpotFromState(Matrix state) {
        if (state == null) {
            return null;
        }
        return new Spot(state.get(0, 0), state.get(1, 0), 0.0);
    }

    @Override
    public Predictor copy() {
        KF2dRandomWalk kf = new KF2dRandomWalk();
        this.copyMyDataInKF(kf);
        return kf;
    }

    @Override
    public Predictor copyInit() {
        KF2dRandomWalk kf = new KF2dRandomWalk();
        kf.setTrackingCovariances(this.Q0);
        kf.t = this.t;
        kf.setUpdateCovariances(this.updateCovariances);
        return kf;
    }

    @Override
    public VirtualSpot getCurrentPredictedStateAsSpot() {
        return new VirtualSpot(this.x_pre.get(0, 0), this.x_pre.get(1, 0), 0.0);
    }

    private void initMatrices() {
        double[][] f = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        this.F = new Matrix((double[][])f);
        double[][] q = new double[][]{{2.0, 0.0}, {0.0, 2.0}};
        this.Q = new Matrix((double[][])q);
        double[][] h = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        this.H = new Matrix((double[][])h);
        double[][] r = new double[][]{{2.0, 0.0}, {0.0, 2.0}};
        this.R = new Matrix((double[][])r);
    }

    @Override
    public double getXCoordEstimated() {
        return this.x_est.get(0, 0);
    }

    @Override
    public double getYCoordEstimated() {
        return this.x_est.get(1, 0);
    }

    @Override
    public double getXCoordPredicted() {
        return this.x_pre.get(0, 0);
    }

    @Override
    public double getYCoordPredicted() {
        return this.x_pre.get(1, 0);
    }

    @Override
    public Matrix getStateErrorCovariance2D(int t) {
        Matrix Ppre = this.F.times(this.P_est).times(this.F.transpose()).plus(this.Q);
        for (int i = this.t + 1; i < t; ++i) {
            Ppre = this.F.times(Ppre).times(this.F.transpose()).plus(this.Q);
        }
        return Ppre;
    }

    @Override
    public Matrix getCurrentStateErrorCovariance2D() {
        return this.P_est;
    }

    @Override
    public Matrix getCurrentEstimatedState2D() {
        return this.x_est;
    }

    @Override
    public void setCurrentEstimatedState2D(Matrix m) {
        this.x_est = m;
    }

    @Override
    public void setCurrentStateErrorCovariance2D(Matrix m) {
        this.P_est = m;
    }

    @Override
    public Matrix getCurrentPredictedState2D() {
        return this.x_pre;
    }

    @Override
    protected void covupdate() {
        if (this.updateCovariances) {
            double alpha = 0.15;
            try {
                if (this.x_est.minus(this.x_pre).normF() != 0.0) {
                    Matrix err = this.x_est.minus(this.x_pre);
                    double dist2 = Math.pow(err.get(0, 0), 2.0);
                    this.Q.set(0, 0, Math.min(Math.max((1.0 - alpha) * this.Q.get(0, 0) + alpha * dist2, this.refVarX / 2.0), 2.0 * this.refVarX));
                    this.Q.set(1, 1, Math.min(Math.max((1.0 - alpha) * this.Q.get(1, 1) + alpha * dist2, this.refVarY / 2.0), 2.0 * this.refVarY));
                }
            }
            catch (RuntimeException e) {
                System.out.println("error in KalmanFiter.covupdate:");
                if (this.x_est == null) {
                    System.out.println("xest null");
                }
                if (this.x_pre == null) {
                    System.out.println("xpre null");
                }
                if (this.Q == null) {
                    System.out.println("Q null");
                }
                if (this.Q0 == null) {
                    System.out.println("Q0 null");
                }
                e.printStackTrace();
            }
        }
    }
}

