/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.DoubleScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class StriddenDouble1D
extends Double1D {
    final int order;
    final double[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenDouble1D(double[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.order = Double1D.checkViewStrides(this.data.length, offset, this.stride1, this.dim1);
        this.flat = offset == 0 && this.stride1 == 1;
    }

    public StriddenDouble1D(double[] arr, int offset, int stride1, int dim1) {
        super(dim1);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.order = Double1D.checkViewStrides(this.data.length, offset, stride1, dim1);
        this.flat = offset == 0 && stride1 == 1;
    }

    @Override
    public void checkSanity() {
        Double1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int i1) {
        return this.offset + this.stride1 * i1;
    }

    @Override
    public final double get(int i1) {
        return this.data[this.offset + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, double value) {
        this.data[this.offset + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(double value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = value;
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = generator.nextDouble();
        }
    }

    @Override
    public void increment(double value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(double value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(double value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(DoubleFunction function) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = function.apply(this.data[j1]);
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            if (initialized) {
                scanner.update(this.data[j1]);
                continue;
            }
            scanner.initialize(this.data[j1]);
            initialized = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        double[] out = new double[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, out, 0, this.number);
        } else {
            int j = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                out[++j] = this.data[j1];
            }
        }
        return out;
    }

    @Override
    public double[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public DoubleScalar slice(int idx) {
        return new DoubleScalar(this.data, this.offset + this.stride1 * idx);
    }

    @Override
    public DoubleScalar slice(int idx, int dim) {
        if (dim < 0) {
            ++dim;
        }
        if (dim != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int sliceOffset = this.offset + this.stride1 * idx;
        return new DoubleScalar(this.data, sliceOffset);
    }

    @Override
    public Double1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenDouble1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Double1D view(int[] sel1) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        return new SelectedDouble1D(this.data, idx1);
    }

    @Override
    public Double1D as1D() {
        return this;
    }
}

