/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble3D;
import mitiv.array.impl.StriddenDouble2D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class StriddenDouble3D
extends Double3D {
    final int order;
    final double[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final boolean flat;

    public StriddenDouble3D(double[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 3) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.stride2 = stride[1];
        this.stride3 = stride[2];
        this.order = Double3D.checkViewStrides(this.data.length, offset, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
        this.flat = offset == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2;
    }

    public StriddenDouble3D(double[] arr, int offset, int stride1, int stride2, int stride3, int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.stride2 = stride2;
        this.stride3 = stride3;
        this.order = Double3D.checkViewStrides(this.data.length, offset, stride1, stride2, stride3, dim1, dim2, dim3);
        this.flat = offset == 0 && stride1 == 1 && stride2 == dim1 && stride3 == dim2 * stride2;
    }

    @Override
    public void checkSanity() {
        Double3D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    final int index(int i1, int i2, int i3) {
        return this.offset + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1;
    }

    @Override
    public final double get(int i1, int i2, int i3) {
        return this.data[this.offset + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, double value) {
        this.data[this.offset + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3 = this.stride3 * i3 + j2;
                        this.data[j3] = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1 = this.stride1 * i1 + j2;
                        this.data[j1] = value;
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3 = this.stride3 * i3 + j2;
                        this.data[j3] = generator.nextDouble();
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1 = this.stride1 * i1 + j2;
                        this.data[j1] = generator.nextDouble();
                    }
                }
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3;
                        int n = j3 = this.stride3 * i3 + j2;
                        this.data[n] = this.data[n] + value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1;
                        int n = j1 = this.stride1 * i1 + j2;
                        this.data[n] = this.data[n] + value;
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3;
                        int n = j3 = this.stride3 * i3 + j2;
                        this.data[n] = this.data[n] - value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1;
                        int n = j1 = this.stride1 * i1 + j2;
                        this.data[n] = this.data[n] - value;
                    }
                }
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3;
                        int n = j3 = this.stride3 * i3 + j2;
                        this.data[n] = this.data[n] * value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1;
                        int n = j1 = this.stride1 * i1 + j2;
                        this.data[n] = this.data[n] * value;
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3 = this.stride3 * i3 + j2;
                        this.data[j3] = function.apply(this.data[j3]);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1 = this.stride1 * i1 + j2;
                        this.data[j1] = function.apply(this.data[j1]);
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        int j3 = this.stride3 * i3 + j2;
                        if (initialized) {
                            scanner.update(this.data[j3]);
                            continue;
                        }
                        scanner.initialize(this.data[j3]);
                        initialized = true;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1 = this.stride1 * i1 + j2;
                        if (initialized) {
                            scanner.update(this.data[j1]);
                            continue;
                        }
                        scanner.initialize(this.data[j1]);
                        initialized = true;
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        double[] out = new double[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, out, 0, this.number);
        } else {
            int j = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                int j3 = this.stride3 * i3 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j3;
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        int j1 = this.stride1 * i1 + j2;
                        out[++j] = this.data[j1];
                    }
                }
            }
        }
        return out;
    }

    @Override
    public double[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Double2D slice(int idx) {
        return new StriddenDouble2D(this.data, this.offset + this.stride3 * idx, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    @Override
    public Double2D slice(int idx, int dim) {
        int sliceDim2;
        int sliceDim1;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if (dim < 0) {
            dim += 3;
        }
        if (dim == 0) {
            sliceOffset = this.offset + this.stride1 * idx;
            sliceStride1 = this.stride2;
            sliceStride2 = this.stride3;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
        } else if (dim == 1) {
            sliceOffset = this.offset + this.stride2 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
        } else if (dim == 2) {
            sliceOffset = this.offset + this.stride3 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenDouble2D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceDim1, sliceDim2);
    }

    @Override
    public Double3D view(Range rng1, Range rng2, Range rng3) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.stride2);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.stride3);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing()) {
            return this;
        }
        return new StriddenDouble3D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber());
    }

    @Override
    public Double3D view(int[] sel1, int[] sel2, int[] sel3) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.stride2, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.stride3, this.dim3, sel3);
        return new SelectedDouble3D(this.data, idx1, idx2, idx3);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.flatten(), this.number);
    }
}

