/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology.skeletonization;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.dimension.Dimension3D;
import icy.type.rectangle.Rectangle5D;
import java.awt.Rectangle;
import plugins.kernel.roi.morphology.skeletonization.MinimumSpanningTreeCalculator;
import plugins.kernel.roi.morphology.skeletonization.TopologicalDescriptor;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class ROISkeletonCalculator {
    private ROI roi;
    private Dimension3D pixelSize;
    private ROI skeletonRoi;
    private BooleanMask2D roiBooleanMask;
    ROI2DArea distanceMapRoi2d;

    public ROISkeletonCalculator(ROI roi, Dimension3D pixelSize) {
        this.roi = roi;
        this.pixelSize = pixelSize;
    }

    public ROI getSkeletonROI() throws InterruptedException {
        if (this.skeletonRoi == null) {
            this.compute();
        }
        return this.skeletonRoi;
    }

    private void compute() throws InterruptedException {
        Rectangle5D roiBounds = this.roi.getBounds5D();
        if (roiBounds.getSizeZ() == 1.0 || Double.isInfinite(roiBounds.getSizeZ())) {
            this.roiBooleanMask = this.roi.getBooleanMask2D(0, 0, 0, true);
            this.setDistanceMapRoi2D();
            Sequence dt = ROIUtil.computeDistanceMap(this.distanceMapRoi2d, this.distanceMapRoi2d.getBounds5D().getDimension(), this.pixelSize, false);
            MinimumSpanningTreeCalculator mstCalculator = new MinimumSpanningTreeCalculator(dt, this.pixelSize);
            Sequence costs = mstCalculator.getCosts();
            Sequence mst = mstCalculator.getTree();
            TopologicalDescriptor topologicalDescriptor = new TopologicalDescriptor(dt, costs, mst, this.pixelSize);
            topologicalDescriptor.compute();
        }
    }

    private void setDistanceMapRoi2D() {
        Rectangle distanceMapRoiMaskRect = new Rectangle((int)((double)this.roiBooleanMask.bounds.x - Math.ceil(1.0)), (int)((double)this.roiBooleanMask.bounds.y - Math.ceil(1.0)), (int)((double)this.roiBooleanMask.bounds.width + 2.0 * Math.ceil(1.0)), (int)((double)this.roiBooleanMask.bounds.height + 2.0 * Math.ceil(1.0)));
        boolean[] distanceMapMask = new boolean[distanceMapRoiMaskRect.width * distanceMapRoiMaskRect.height];
        BooleanMask2D distanceMapRoiMask = new BooleanMask2D(distanceMapRoiMaskRect, distanceMapMask);
        distanceMapRoiMask.add(this.roiBooleanMask.bounds, this.roiBooleanMask.mask);
        distanceMapRoiMask.bounds.x = 0;
        distanceMapRoiMask.bounds.y = 0;
        this.distanceMapRoi2d = new ROI2DArea(distanceMapRoiMask);
        this.distanceMapRoi2d.setZ(0);
        this.distanceMapRoi2d.setT(0);
        this.distanceMapRoi2d.setC(0);
    }
}

