/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.NewImage;
import ij.plugin.CanvasResizer;
import ij.plugin.Resizer;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;

public class ImageByte
extends ImageInt {
    public byte[][] pixels;

    public ImageByte(ImagePlus img) {
        super(img);
        this.buildPixels();
    }

    public ImageByte(ImageStack stack) {
        super(stack);
        this.buildPixels();
    }

    public ImageByte(byte[][] pixels, String title, int sizeX) {
        super(title, sizeX, pixels[0].length / sizeX, pixels.length, 0, 0, 0);
        this.pixels = pixels;
        ImageStack st = new ImageStack(sizeX, this.sizeY, this.sizeZ);
        for (int z = 0; z < this.sizeZ; ++z) {
            st.setPixels((Object)pixels[z], z + 1);
        }
        this.img = new ImagePlus(title, st);
    }

    public ImageByte(String title, int sizeX, int sizeY, int sizeZ) {
        super(title, sizeX, sizeY, sizeZ);
        this.img = NewImage.createByteImage((String)title, (int)sizeX, (int)sizeY, (int)sizeZ, (int)1);
        this.pixels = new byte[sizeZ][];
        for (int i = 0; i < sizeZ; ++i) {
            this.pixels[i] = (byte[])this.img.getImageStack().getPixels(i + 1);
        }
    }

    protected ImageByte(int sizeX, int sizeY, int sizeZ) {
        super("blank mask", sizeX, sizeY, sizeZ);
    }

    public ImageByte(ImageHandler im, boolean scaling) {
        super(im.title, im.sizeX, im.sizeY, im.sizeZ, im.offsetX, im.offsetY, im.offsetZ);
        ImageStats s = this.getImageStats(null);
        if (im instanceof ImageShort) {
            ImageByte b = ((ImageShort)im).convertToByte(scaling);
            this.pixels = b.pixels;
            this.img = b.img;
            s.setMinAndMax(0.0, 255.0);
        } else if (im instanceof ImageFloat) {
            if (im.img != null) {
                ImageByte b = ((ImageFloat)im).convertToByte(scaling);
                this.pixels = b.pixels;
                this.img = b.img;
                s.setMinAndMax(0.0, 255.0);
            }
        } else {
            this.img = im.img;
            this.pixels = ((ImageByte)im).pixels;
        }
    }

    public static byte[] getArray1DByte(ImagePlus img) {
        byte[] res = new byte[img.getNSlices() * img.getWidth() * img.getHeight()];
        int offZ = 0;
        int sizeXY = img.getWidth() * img.getHeight();
        for (int slice = 0; slice < img.getNSlices(); ++slice) {
            System.arraycopy(img.getImageStack().getPixels(slice + 1), 0, res, offZ, sizeXY);
            offZ += sizeXY;
        }
        return res;
    }

    public static ImagePlus getImagePlus(byte[] pixels, int sizeX, int sizeY, int sizeZ, boolean setMinAndMax) {
        if (pixels == null) {
            return null;
        }
        ImagePlus res = NewImage.createShortImage((String)"", (int)sizeX, (int)sizeY, (int)sizeZ, (int)1);
        int offZ = 0;
        int sizeXY = sizeX * sizeY;
        for (int z = 0; z < sizeZ; ++z) {
            System.arraycopy(pixels, offZ, res.getImageStack().getPixels(z + 1), 0, sizeXY);
            offZ += sizeXY;
        }
        if (setMinAndMax) {
            int max = 0;
            int min = 0;
            for (byte pixel : pixels) {
                if ((pixel & 0xFF) > max) {
                    max = pixel & 0xFF;
                }
                if ((pixel & 0xFF) >= min) continue;
                min = pixel & 0xFF;
            }
            res.getProcessor().setMinAndMax((double)min, (double)max);
        }
        return res;
    }

    public static byte[] convert(float[] input, boolean scaling) {
        byte[] res = new byte[input.length];
        if (!scaling) {
            for (int i = 0; i < input.length; ++i) {
                res[i] = (byte)(input[i] + 0.5f);
            }
        } else {
            float min = input[0];
            float max = input[0];
            for (float f : input) {
                if (f < min) {
                    min = f;
                }
                if (!(f > max)) continue;
                max = f;
            }
            float coeff = 255.0f / (max - min);
            for (int i = 0; i < input.length; ++i) {
                res[i] = (byte)((double)((input[i] - min) * coeff) - 127.5);
            }
        }
        return res;
    }

    public static byte[] convert(short[] input, boolean scaling) {
        byte[] res = new byte[input.length];
        if (!scaling) {
            for (int i = 0; i < input.length; ++i) {
                res[i] = (byte)((float)input[i] + 0.5f);
            }
        } else {
            float min = input[0];
            float max = input[0];
            short[] sArray = input;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                float f = sArray[i];
                if (f < min) {
                    min = f;
                }
                if (!(f > max)) continue;
                max = f;
            }
            float coeff = 255.0f / (max - min);
            for (int i = 0; i < input.length; ++i) {
                res[i] = (byte)((double)(((float)input[i] - min) * coeff) - 127.5);
            }
        }
        return res;
    }

    private void buildPixels() {
        this.pixels = new byte[this.sizeZ][];
        if (this.img.getImageStack() != null) {
            for (int i = 0; i < this.sizeZ; ++i) {
                this.pixels[i] = (byte[])this.img.getImageStack().getPixels(i + 1);
            }
        } else {
            ImageStack st = new ImageStack(this.sizeX, this.sizeY);
            st.addSlice(this.img.getProcessor());
            this.pixels[0] = (byte[])this.img.getProcessor().getPixels();
            this.img.setStack(null, st);
        }
    }

    @Override
    public Object getArray1D() {
        byte[] res = new byte[this.sizeXYZ];
        int offZ = 0;
        for (int slice = 0; slice < this.img.getNSlices(); ++slice) {
            System.arraycopy(this.img.getImageStack().getPixels(slice + 1), 0, res, offZ, this.sizeXY);
            offZ += this.sizeXY;
        }
        return res;
    }

    @Override
    public Object getArray1D(int z) {
        byte[] res = new byte[this.sizeXY];
        System.arraycopy(this.img.getImageStack().getPixels(z + 1), 0, res, 0, this.sizeXY);
        return res;
    }

    public ImageShort convertToShort(boolean scaling) {
        if (scaling) {
            this.setMinAndMax(null);
        }
        ImageStats s = this.getImageStats(null);
        int currentSlice = this.img.getCurrentSlice();
        ImageStack stack2 = new ImageStack(this.sizeX, this.sizeY);
        ImageStack stack1 = this.img.getImageStack();
        for (int i = 1; i <= this.sizeZ; ++i) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip = stack1.getProcessor(i);
            if (scaling) {
                ip.setMinAndMax(s.getMin(), s.getMax());
            }
            stack2.addSlice(label, ip.convertToShort(scaling));
        }
        ImagePlus imp2 = new ImagePlus(this.img.getTitle(), stack2);
        imp2.setCalibration(this.img.getCalibration());
        imp2.setSlice(currentSlice);
        imp2.getProcessor().setMinAndMax(0.0, 255.0);
        return (ImageShort)ImageHandler.wrap(imp2);
    }

    public ImageFloat convertToFloat(boolean scaling) {
        if (scaling) {
            this.setMinAndMax(null);
        }
        ImageStats s = this.getImageStats(null);
        int currentSlice = this.img.getCurrentSlice();
        ImageStack stack2 = new ImageStack(this.sizeX, this.sizeY);
        ImageStack stack1 = this.img.getImageStack();
        for (int i = 1; i <= this.sizeZ; ++i) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip = stack1.getProcessor(i);
            if (scaling) {
                ip.setMinAndMax(s.getMin(), s.getMax());
            }
            stack2.addSlice(label, ip.convertToFloat());
        }
        ImagePlus imp2 = new ImagePlus(this.img.getTitle(), stack2);
        imp2.setCalibration(this.img.getCalibration());
        imp2.setSlice(currentSlice);
        imp2.getProcessor().setMinAndMax(0.0, 255.0);
        return (ImageFloat)ImageHandler.wrap(imp2);
    }

    @Override
    public void erase() {
        for (int xy = 0; xy < this.sizeXY; ++xy) {
            this.pixels[0][xy] = 0;
        }
        for (int z = 1; z < this.sizeZ; ++z) {
            System.arraycopy(this.pixels[0], 0, this.pixels[z], 0, this.sizeXY);
        }
    }

    @Override
    public void fill(double value, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max >= this.sizeZ) {
            max = this.sizeZ - 1;
        }
        for (int xy = 0; xy < this.sizeXY; ++xy) {
            this.pixels[min][xy] = (byte)value;
        }
        for (int z = min + 1; z <= max; ++z) {
            System.arraycopy(this.pixels[min], 0, this.pixels[z], 0, this.sizeXY);
        }
    }

    @Override
    public ImageByte duplicate() {
        ImageByte res = new ImageByte(this.img.duplicate());
        res.offsetX = this.offsetX;
        res.offsetY = this.offsetY;
        res.offsetZ = this.offsetZ;
        if (this.title != null) {
            res.title = this.title;
        }
        return res;
    }

    public void copy(ImageByte destination) {
        for (int z = 0; z < this.sizeZ; ++z) {
            System.arraycopy(this.pixels[z], 0, destination.pixels[z], 0, this.sizeXY);
        }
    }

    @Override
    public float getPixel(int xy, int z) {
        return this.pixels[z][xy] & 0xFF;
    }

    @Override
    public float getPixel(int coord) {
        return this.pixels[coord / this.sizeXY][coord % this.sizeXY] & 0xFF;
    }

    public float getPixel(Voxel3D vox, boolean approx) {
        return this.pixels[(int)vox.getZ()][(int)vox.getX() + (int)vox.getY() * this.sizeX] & 0xFF;
    }

    @Override
    public float getPixel(int x, int y, int z) {
        return this.pixels[z][x + y * this.sizeX] & 0xFF;
    }

    @Override
    public int getPixelInt(int xy, int z) {
        return this.pixels[z][xy] & 0xFF;
    }

    @Override
    public int getPixelInt(int coord) {
        return this.pixels[coord / this.sizeXY][coord % this.sizeXY] & 0xFF;
    }

    @Override
    public int getPixelInt(int x, int y, int z) {
        return this.pixels[z][x + y * this.sizeX] & 0xFF;
    }

    public float getPixel(IntCoord3D vox) {
        return this.pixels[vox.z][vox.x + vox.y * this.sizeX] & 0xFF;
    }

    public int getPixelInt(IntCoord3D vox) {
        return this.pixels[vox.z][vox.x + vox.y * this.sizeX] & 0xFF;
    }

    @Override
    public void setPixel(int coord, float value) {
        this.pixels[coord / this.sizeXY][coord % this.sizeXY] = (byte)value;
    }

    @Override
    public void setPixel(Point3D point, float value) {
        this.pixels[(int)point.z][(int)point.x + (int)point.y * this.sizeX] = (byte)value;
    }

    @Override
    public void setPixel(int x, int y, int z, float value) {
        this.pixels[z][x + y * this.sizeX] = (byte)value;
    }

    @Override
    public void setPixel(int xy, int z, float value) {
        this.pixels[z][xy] = (byte)value;
    }

    @Override
    public void setPixel(int x, int y, int z, int value) {
        this.pixels[z][x + y * this.sizeX] = (byte)value;
    }

    @Override
    public void setPixelCross3D(int x, int y, int z, int value) {
        byte val;
        this.pixels[z][x + y * this.sizeX] = val = (byte)value;
        if (x - 1 >= 0) {
            this.pixels[z][x - 1 + y * this.sizeX] = val;
        }
        if (y - 1 >= 0) {
            this.pixels[z][x + (y - 1) * this.sizeX] = val;
        }
        if (z - 1 >= 0) {
            this.pixels[z - 1][x + y * this.sizeX] = val;
        }
        if (x + 1 < this.sizeX) {
            this.pixels[z][x + 1 + y * this.sizeX] = val;
        }
        if (y + 1 < this.sizeY) {
            this.pixels[z][x + (y + 1) * this.sizeX] = val;
        }
        if (z + 1 < this.sizeZ) {
            this.pixels[z + 1][x + y * this.sizeX] = val;
        }
    }

    @Override
    public void setPixel(int xy, int z, int value) {
        this.pixels[z][xy] = (byte)value;
    }

    @Override
    protected synchronized void getMinAndMax(ImageInt mask) {
        ImageStats s = this.getImageStats(mask);
        if (s.minAndMaxSet()) {
            return;
        }
        int max = 0;
        int min = 255;
        if (mask == null) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if ((this.pixels[z][xy] & 0xFF) > max) {
                        max = this.pixels[z][xy] & 0xFF;
                    }
                    if ((this.pixels[z][xy] & 0xFF) >= min) continue;
                    min = this.pixels[z][xy] & 0xFF;
                }
            }
        } else {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if (mask.getPixel(xy, z) == 0.0f) continue;
                    if ((this.pixels[z][xy] & 0xFF) > max) {
                        max = this.pixels[z][xy] & 0xFF;
                    }
                    if ((this.pixels[z][xy] & 0xFF) >= min) continue;
                    min = this.pixels[z][xy] & 0xFF;
                }
            }
        }
        s.setMinAndMax(min, max);
    }

    @Override
    protected int[] getHisto(ImageInt mask) {
        if (mask == null) {
            mask = new BlankMask(this);
        }
        this.getMinAndMax(mask);
        ImageStats s = this.getImageStats(mask);
        int[] histo = new int[256];
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                int n = this.pixels[z][xy] & 0xFF;
                histo[n] = histo[n] + 1;
            }
        }
        s.setHisto256(histo, 1.0);
        return histo;
    }

    @Override
    protected int[] getHisto(ImageInt mask, int nBins, double min, double max) {
        if (mask == null) {
            mask = new BlankMask(this);
        }
        double scale = (double)nBins / (max - min + 1.0);
        int[] hist = new int[nBins];
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                int idx = (int)(((double)(this.pixels[z][xy] & 0xFF) - min) * scale);
                if (idx >= nBins) {
                    int n = hist.length - 1;
                    hist[n] = hist[n] + 1;
                    continue;
                }
                int n = idx;
                hist[n] = hist[n] + 1;
            }
        }
        return hist;
    }

    @Override
    public ImageByte thresholdRangeInclusive(float min, float max) {
        ImageByte res = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
        res.offsetX = this.offsetX;
        res.offsetY = this.offsetY;
        res.offsetZ = this.offsetZ;
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (!((float)(this.pixels[z][xy] & 0xFF) >= min) || !((float)(this.pixels[z][xy] & 0xFF) <= max)) continue;
                res.pixels[z][xy] = -1;
            }
        }
        return res;
    }

    @Override
    public ImageByte thresholdRangeExclusive(float min, float max) {
        ImageByte res = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
        res.offsetX = this.offsetX;
        res.offsetY = this.offsetY;
        res.offsetZ = this.offsetZ;
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (!((float)(this.pixels[z][xy] & 0xFF) > min) || !((float)(this.pixels[z][xy] & 0xFF) < max)) continue;
                res.pixels[z][xy] = -1;
            }
        }
        return res;
    }

    @Override
    public ImageByte threshold(float thld, boolean keepUnderThld, boolean strict) {
        ImageByte res;
        block9: {
            block11: {
                block10: {
                    block8: {
                        res = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
                        res.offsetX = this.offsetX;
                        res.offsetY = this.offsetY;
                        res.offsetZ = this.offsetZ;
                        if (keepUnderThld || strict) break block8;
                        for (int z = 0; z < this.sizeZ; ++z) {
                            for (int xy = 0; xy < this.sizeXY; ++xy) {
                                if (!((float)(this.pixels[z][xy] & 0xFF) >= thld)) continue;
                                res.pixels[z][xy] = -1;
                            }
                        }
                        break block9;
                    }
                    if (keepUnderThld || !strict) break block10;
                    for (int z = 0; z < this.sizeZ; ++z) {
                        for (int xy = 0; xy < this.sizeXY; ++xy) {
                            if (!((float)(this.pixels[z][xy] & 0xFF) > thld)) continue;
                            res.pixels[z][xy] = -1;
                        }
                    }
                    break block9;
                }
                if (!keepUnderThld || strict) break block11;
                for (int z = 0; z < this.sizeZ; ++z) {
                    for (int xy = 0; xy < this.sizeXY; ++xy) {
                        if (!((float)(this.pixels[z][xy] & 0xFF) <= thld)) continue;
                        res.pixels[z][xy] = -1;
                    }
                }
                break block9;
            }
            if (!keepUnderThld || !strict) break block9;
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if (!((float)(this.pixels[z][xy] & 0xFF) < thld)) continue;
                    res.pixels[z][xy] = -1;
                }
            }
        }
        return res;
    }

    @Override
    public void thresholdCut(float thld, boolean keepUnderThld, boolean strict) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (keepUnderThld || strict) break block8;
                        for (int z = 0; z < this.sizeZ; ++z) {
                            for (int xy = 0; xy < this.sizeXY; ++xy) {
                                if (!((float)(this.pixels[z][xy] & 0xFF) < thld)) continue;
                                this.pixels[z][xy] = 0;
                            }
                        }
                        break block9;
                    }
                    if (keepUnderThld || !strict) break block10;
                    for (int z = 0; z < this.sizeZ; ++z) {
                        for (int xy = 0; xy < this.sizeXY; ++xy) {
                            if (!((float)(this.pixels[z][xy] & 0xFF) <= thld)) continue;
                            this.pixels[z][xy] = 0;
                        }
                    }
                    break block9;
                }
                if (!keepUnderThld || strict) break block11;
                for (int z = 0; z < this.sizeZ; ++z) {
                    for (int xy = 0; xy < this.sizeXY; ++xy) {
                        if (!((float)(this.pixels[z][xy] & 0xFF) > thld)) continue;
                        this.pixels[z][xy] = 0;
                    }
                }
                break block9;
            }
            if (!keepUnderThld || !strict) break block9;
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if (!((float)(this.pixels[z][xy] & 0xFF) >= thld)) continue;
                    this.pixels[z][xy] = 0;
                }
            }
        }
    }

    @Override
    public ImageByte crop3D(String title, int x_min_, int x_max_, int y_min_, int y_max_, int z_min_, int z_max_) {
        int x_min = x_min_;
        int z_min = z_min_;
        int y_min = y_min_;
        int x_max = x_max_;
        int y_max = y_max_;
        int z_max = z_max_;
        int sX = x_max - x_min + 1;
        int sY = y_max - y_min + 1;
        int sZ = z_max - z_min + 1;
        ImageByte res = new ImageByte(title, sX, sY, sZ);
        res.offsetX = this.offsetX + x_min;
        res.offsetY = this.offsetY + y_min;
        res.offsetZ = this.offsetZ + z_min;
        res.setScale(this);
        int oZ = -z_min;
        int oY_i = 0;
        int oX = 0;
        if (x_min <= -1) {
            x_min = 0;
        }
        if (x_max >= this.sizeX) {
            x_max = this.sizeX - 1;
        }
        if (y_min <= -1) {
            oY_i = -sX * y_min;
            y_min = 0;
        }
        if (y_max >= this.sizeY) {
            y_max = this.sizeY - 1;
        }
        if (z_min <= -1) {
            z_min = 0;
        }
        if (z_max >= this.sizeZ) {
            z_max = this.sizeZ - 1;
        }
        int sXo = x_max - x_min + 1;
        for (int z = z_min; z <= z_max; ++z) {
            int offY = y_min * this.sizeX;
            int oY = oY_i;
            for (int y = y_min; y <= y_max; ++y) {
                System.arraycopy(this.pixels[z], offY + x_min, res.pixels[z + oZ], oY + oX, sXo);
                oY += sX;
                offY += this.sizeX;
            }
        }
        return res;
    }

    @Override
    public boolean shiftIndexes(TreeMap<Integer, int[]> bounds) {
        boolean change = false;
        int newLabel = 1;
        ArrayList<Integer> keySet = new ArrayList<Integer>(bounds.keySet());
        for (Integer aKeySet : keySet) {
            int label = aKeySet;
            if (label > newLabel) {
                int[] bds = bounds.get(label);
                for (int z = bds[4]; z <= bds[5]; ++z) {
                    for (int y = bds[2]; y <= bds[3]; ++y) {
                        for (int x = bds[0]; x <= bds[1]; ++x) {
                            int xy = x + y * this.sizeX;
                            if ((this.pixels[z][xy] & 0xFF) != label) continue;
                            this.pixels[z][xy] = (byte)newLabel;
                        }
                    }
                }
                change = true;
                bounds.remove(label);
                bounds.put(newLabel, bds);
            }
            ++newLabel;
        }
        return change;
    }

    public ImageByte[] crop3D(TreeMap<Integer, int[]> bounds) {
        ImageByte[] ihs = new ImageByte[bounds.size()];
        ArrayList<Integer> keys = new ArrayList<Integer>(bounds.keySet());
        for (int idx = 0; idx < ihs.length; ++idx) {
            int label = keys.get(idx);
            int[] bds = bounds.get(label);
            ihs[idx] = this.crop3D(this.title + ":" + label, bds[0], bds[1], bds[2], bds[3], bds[4], bds[5]);
        }
        return ihs;
    }

    @Override
    public ImageByte crop3DMask(String title, ImageInt mask, int label, int x_min_, int x_max_, int y_min_, int y_max_, int z_min_, int z_max_) {
        ImageByte res;
        block13: {
            int oY_i;
            int sX;
            int z_max;
            int y_max;
            int x_max;
            int y_min;
            block12: {
                int x_min = x_min_;
                int z_min = z_min_;
                y_min = y_min_;
                x_max = x_max_;
                y_max = y_max_;
                z_max = z_max_;
                sX = x_max - x_min + 1;
                int sY = y_max - y_min + 1;
                int sZ = z_max - z_min + 1;
                res = new ImageByte(title, sX, sY, sZ);
                res.offsetX = x_min;
                res.offsetY = y_min;
                res.offsetZ = z_min;
                res.setScale(this);
                int oZ = -z_min;
                oY_i = 0;
                int oX = -x_min;
                if (x_min <= -1) {
                    x_min = 0;
                }
                if (x_max >= this.sizeX) {
                    x_max = this.sizeX - 1;
                }
                if (y_min <= -1) {
                    oY_i = -sX * y_min;
                    y_min = 0;
                }
                if (y_max >= this.sizeY) {
                    y_max = this.sizeY - 1;
                }
                if (z_min <= -1) {
                    z_min = 0;
                }
                if (z_max >= this.sizeZ) {
                    z_max = this.sizeZ - 1;
                }
                if (!(mask instanceof ImageShort)) break block12;
                ImageShort m = (ImageShort)mask;
                for (int z = z_min; z <= z_max; ++z) {
                    int offY = y_min * this.sizeX;
                    int oY = oY_i;
                    for (int y = y_min; y <= y_max; ++y) {
                        for (int x = x_min; x <= x_max; ++x) {
                            if ((m.pixels[z][offY + x] & 0xFFFF) != label) continue;
                            res.pixels[z + oZ][oY + x + oX] = this.pixels[z][offY + x];
                        }
                        oY += sX;
                        offY += this.sizeX;
                    }
                }
                break block13;
            }
            if (!(mask instanceof ImageByte)) break block13;
            ImageByte m = (ImageByte)mask;
            for (int z = z_min; z <= z_max; ++z) {
                int offY = y_min * this.sizeX;
                int oY = oY_i;
                for (int y = y_min; y <= y_max; ++y) {
                    for (int x = x_min; x <= x_max; ++x) {
                        if ((m.pixels[z][offY + x] & 0xFF) != label) continue;
                        res.pixels[z + oZ][oY + x + oX] = this.pixels[z][offY + x];
                    }
                    oY += sX;
                    offY += this.sizeX;
                }
            }
        }
        return res;
    }

    @Override
    public ImageByte crop3DBinary(String title, int label, int x_min_, int x_max_, int y_min_, int y_max_, int z_min_, int z_max_) {
        int x_min = x_min_;
        int z_min = z_min_;
        int y_min = y_min_;
        int x_max = x_max_;
        int y_max = y_max_;
        int z_max = z_max_;
        int sX = x_max - x_min + 1;
        int sY = y_max - y_min + 1;
        int sZ = z_max - z_min + 1;
        ImageByte res = new ImageByte(title, sX, sY, sZ);
        res.offsetX = x_min;
        res.offsetY = y_min;
        res.offsetZ = z_min;
        res.setScale(this);
        int oZ = -z_min;
        int oY_i = 0;
        int oX = -x_min;
        if (x_min <= -1) {
            x_min = 0;
        }
        if (x_max >= this.sizeX) {
            x_max = this.sizeX - 1;
        }
        if (y_min <= -1) {
            oY_i = -sX * y_min;
            y_min = 0;
        }
        if (y_max >= this.sizeY) {
            y_max = this.sizeY - 1;
        }
        if (z_min <= -1) {
            z_min = 0;
        }
        if (z_max >= this.sizeZ) {
            z_max = this.sizeZ - 1;
        }
        for (int z = z_min; z <= z_max; ++z) {
            int offY = y_min * this.sizeX;
            int oY = oY_i;
            for (int y = y_min; y <= y_max; ++y) {
                for (int x = x_min; x <= x_max; ++x) {
                    if ((this.pixels[z][offY + x] & 0xFF) != label) continue;
                    res.pixels[z + oZ][oY + x + oX] = -1;
                }
                oY += sX;
                offY += this.sizeX;
            }
        }
        return res;
    }

    @Override
    public ImageHandler resize(int dX, int dY, int dZ) {
        int i;
        int newX = Math.max(1, this.sizeX + 2 * dX);
        int newY = Math.max(1, this.sizeY + 2 * dY);
        boolean bck = Prefs.get((String)"resizer.zero", (boolean)true);
        Prefs.set((String)"resizer.zero", (boolean)true);
        CanvasResizer cr = new CanvasResizer();
        ImageStack res = cr.expandStack(this.img.getStack(), newX, newY, dX, dY);
        if (!bck) {
            // empty if block
        }
        if (dZ > 0) {
            for (i = 0; i < dZ; ++i) {
                res.addSlice("", (ImageProcessor)new ByteProcessor(newX, newY), 0);
                res.addSlice("", (ImageProcessor)new ByteProcessor(newX, newY));
            }
        } else {
            for (i = 0; i < -dZ && res.getSize() > 2; ++i) {
                res.deleteLastSlice();
                res.deleteSlice(1);
            }
        }
        ImageByte r = new ImageByte(new ImagePlus(this.title + "::resized", res));
        r.offsetX = this.offsetX - dX;
        r.offsetY = this.offsetY - dY;
        r.offsetZ = this.offsetZ - dZ;
        return r;
    }

    @Override
    public ImageByte resample(int newX, int newY, int newZ, int method) {
        ImagePlus ip;
        if (method == -1) {
            method = 2;
        }
        if (newX == this.sizeX && newY == this.sizeY && newZ == this.sizeZ || newX == 0 && newY == 0 && newZ == 0) {
            return new ImageByte(this.img.duplicate());
        }
        if (newX != 0 && newY != 0 && newX != this.sizeX && newY != this.sizeY) {
            StackProcessor sp = new StackProcessor(this.img.getImageStack(), this.img.getProcessor());
            ip = new ImagePlus(this.title + "::resampled", sp.resize(newX, newY, true));
        } else {
            ip = this.img;
        }
        if (newZ != 0 && newZ != this.sizeZ) {
            Resizer r = new Resizer();
            ip = r.zScale(ip, newZ, method);
        }
        return new ImageByte(ip);
    }

    @Override
    public ImageByte resample(int newZ, int method) {
        if (method == -1) {
            method = 2;
        }
        Resizer r = new Resizer();
        return new ImageByte(r.zScale(this.img, newZ, method));
    }

    @Override
    protected ImageFloat normalize_(ImageInt mask, double saturation) {
        this.getMinAndMax(mask);
        ImageStats s = this.getImageStats(mask);
        double max_ = s.getMax();
        if (saturation > 0.0 && saturation < 1.0) {
            max_ = this.getPercentile(saturation, mask);
        }
        if (max_ <= s.getMin()) {
            max_ = s.getMin() + 1.0;
        }
        double scale = 1.0 / (max_ - s.getMin());
        double offset = -s.getMin() * scale;
        ImageFloat res = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        if (saturation > 0.0 && saturation < 1.0) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    res.pixels[z][xy] = (float)((double)(this.pixels[z][xy] & 0xFF) >= max_ ? 1.0 : (double)(this.pixels[z][xy] & 0xFF) * scale + offset);
                }
            }
        } else {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    res.pixels[z][xy] = (float)((double)(this.pixels[z][xy] & 0xFF) * scale + offset);
                }
            }
        }
        return res;
    }

    @Override
    public ImageFloat normalize(double min, double max) {
        double scale = 1.0 / (max - min);
        double offset = -min * scale;
        ImageFloat res = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                double pix = this.pixels[z][xy] & 0xFF;
                res.pixels[z][xy] = pix >= max ? 1.0f : (pix <= min ? 0.0f : (float)(pix * scale + offset));
            }
        }
        return res;
    }

    @Override
    public void invert(ImageInt mask) {
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                this.pixels[z][xy] = (byte)(255 - this.pixels[z][xy]);
            }
        }
    }

    @Override
    public void draw(Object3D o, float value) {
        this.draw(o, (int)((double)value + 0.5));
    }

    @Override
    public void draw(Object3D o, int value) {
        Object3DVoxels ov = !(o instanceof Object3DVoxels) ? o.getObject3DVoxels() : (Object3DVoxels)o;
        if (value > 255) {
            value = 255;
        }
        if (value < 0) {
            value = 0;
        }
        byte val = (byte)value;
        for (Voxel3D v : ov.getVoxels()) {
            if (!this.contains(v.getX(), v.getY(), v.getZ())) continue;
            this.pixels[v.getRoundZ()][v.getRoundX() + v.getRoundY() * this.sizeX] = val;
        }
    }

    @Override
    protected void flushPixels() {
        if (this.pixels != null) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = null;
            }
            this.pixels = null;
        }
    }

    @Override
    public boolean isOpened() {
        return this.pixels != null && this.img != null && this.img.getProcessor() != null;
    }

    @Override
    public float getPixel(Point3D P) {
        return this.pixels[P.getRoundZ()][P.getRoundX() + P.getRoundY() * this.sizeX] & 0xFF;
    }

    @Override
    public int getPixelInt(Point3D P) {
        return this.pixels[P.getRoundZ()][P.getRoundX() + P.getRoundY() * this.sizeX] & 0xFF;
    }

    @Override
    public float getPixelInterpolated(Point3D P) {
        return this.getPixel((float)P.getX(), (float)P.getY(), (float)P.getZ());
    }

    @Override
    public int getPixelIntInterpolated(Point3D P) {
        return (int)this.getPixel((float)P.getX(), (float)P.getY(), (float)P.getZ());
    }

    @Override
    public ImageHandler deleteSlices(int zmin, int zmax) {
        int z;
        int z0 = Math.min(zmin, zmax);
        int z1 = Math.max(zmin, zmax);
        int diff = z1 - z0 + 1;
        int newSz = this.sizeZ - diff;
        ImageByte res = new ImageByte("deleted slices", this.sizeX, this.sizeY, newSz);
        for (z = 0; z < z0; ++z) {
            System.arraycopy(this.pixels[z], 0, res.pixels[z], 0, this.sizeXY);
        }
        for (z = z1 + 1; z < this.sizeZ; ++z) {
            System.arraycopy(this.pixels[z], 0, res.pixels[z - diff], 0, this.sizeXY);
        }
        return res;
    }

    @Override
    public void trimSlices(int zmin, int zmax) {
        int z0 = Math.max(1, Math.min(zmin, zmax));
        int z1 = Math.min(this.sizeZ, Math.max(zmin, zmax));
        int newSize = z1 - z0 + 1;
        byte[][] newPixels = new byte[newSize][];
        System.arraycopy(this.pixels, 0 + z0 - 1, newPixels, 0, newSize);
        if (this.img != null) {
            int i;
            ImageStack stack = this.img.getImageStack();
            for (i = 1; i < z0; ++i) {
                stack.deleteSlice(1);
            }
            for (i = z1 + 1; i <= this.sizeZ; ++i) {
                stack.deleteLastSlice();
            }
        }
        this.sizeZ = newSize;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
        this.offsetZ += z0 - 1;
        this.stats = new HashMap(2);
    }

    @Override
    public void intersectMask(ImageInt mask) {
        if (mask == null) {
            return;
        }
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) != 0.0f) continue;
                this.pixels[z][xy] = 0;
            }
        }
    }

    @Override
    public void intersectMask2D(ImageInt mask, int z) {
        if (mask == null) {
            return;
        }
        for (int xy = 0; xy < this.sizeXY; ++xy) {
            if (mask.getPixel(xy, 0) != 0.0f) continue;
            this.pixels[z][xy] = 0;
        }
    }

    public void substractMask(ImageInt mask) {
        if (mask == null) {
            return;
        }
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                this.pixels[z][xy] = 0;
            }
        }
    }

    public void addMask(ImageInt mask) {
        if (mask == null) {
            return;
        }
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                this.pixels[z][xy] = -1;
            }
        }
    }

    @Override
    public double getSizeInMb() {
        return (double)(this.sizeX * this.sizeY * this.sizeZ) / 1048576.0;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public ImageByte toMask() {
        ImageByte res = new ImageByte("mask", this.sizeX, this.sizeY, this.sizeZ);
        res.setScale(this);
        res.setOffset(this);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (this.pixels[z][xy] == 0) continue;
                res.pixels[z][xy] = -1;
            }
        }
        return res;
    }

    @Override
    public int countMaskVolume() {
        int count = 0;
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (this.pixels[z][xy] == 0) continue;
                ++count;
            }
        }
        return count;
    }
}

