/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.button;

import icy.action.IcyAbstractAction;
import icy.resource.icon.IcyIcon;
import icy.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IcyCommandToggleMenuButton
extends JCommandToggleMenuButton {
    private static final long serialVersionUID = -7391297214095914082L;
    private boolean internalEnabled = this.isEnabled();
    private IcyAbstractAction action = null;
    private final PropertyChangeListener actionPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtil.equals("enabled", evt.getPropertyName())) {
                IcyCommandToggleMenuButton.this.refreshEnabled();
            }
        }
    };

    public IcyCommandToggleMenuButton(String title, IcyIcon icon) {
        super(title, (ResizableIcon)icon);
    }

    @Deprecated
    public IcyCommandToggleMenuButton(String title, String iconName) {
        this(title, new IcyIcon(iconName));
    }

    public IcyCommandToggleMenuButton(IcyIcon icon) {
        this(null, icon);
    }

    public IcyCommandToggleMenuButton(String title) {
        this(title, (IcyIcon)null);
    }

    public IcyCommandToggleMenuButton(IcyAbstractAction action) {
        this((String)null, (IcyIcon)null);
        this.setAction(action);
    }

    @Deprecated
    public IcyCommandToggleMenuButton(icy.common.IcyAbstractAction action) {
        this((String)null, (IcyIcon)null);
        this.setAction(action);
    }

    public IcyCommandToggleMenuButton() {
        this((String)null, (IcyIcon)null);
    }

    public IcyIcon getIcyIcon() {
        ResizableIcon icon = this.getIcon();
        if (icon instanceof IcyIcon) {
            return (IcyIcon)icon;
        }
        return null;
    }

    public String getIconName() {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public void setIconName(String iconName) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setName(iconName);
        }
    }

    public void setEnabled(boolean b) {
        this.internalEnabled = b;
        this.refreshEnabled();
    }

    protected void refreshEnabled() {
        super.setEnabled(this.internalEnabled && (this.action == null || this.action.isEnabled()));
    }

    public void setAction(IcyAbstractAction value) {
        if (this.action != value) {
            if (this.action != null) {
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.action = value;
            this.setText(this.action.getName());
            IcyIcon icon = this.action.getIcon();
            if (icon != null) {
                this.setIcon(new IcyIcon(icon));
            } else {
                this.setIcon(null);
            }
            if (value != null) {
                this.setActionRichTooltip(this.action.getRichToolTip());
                this.addActionListener(value);
                value.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.refreshEnabled();
        }
    }

    public IcyAbstractAction getAction() {
        return this.action;
    }
}

