/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.action.CanvasActions;
import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.gui.component.button.IcyButton;
import icy.gui.inspector.LayersPanel;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayerControlPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 6501341338561271486L;
    JSlider opacitySlider;
    IcyButton deleteButton;
    final LayersPanel layerPanel;
    private JPanel optionsPanel;

    public LayerControlPanel(LayersPanel layerPanel) {
        this.layerPanel = layerPanel;
        this.initialize();
        this.opacitySlider.addChangeListener(this);
    }

    private void initialize() {
        this.setBorder(null);
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, "Center");
        JPanel actionPanel = new JPanel();
        scrollPane.setViewportView(actionPanel);
        scrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        GridBagLayout gbl_actionPanel = new GridBagLayout();
        gbl_actionPanel.columnWidths = new int[4];
        gbl_actionPanel.rowHeights = new int[3];
        gbl_actionPanel.columnWeights = new double[]{1.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_actionPanel.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        actionPanel.setLayout(gbl_actionPanel);
        this.optionsPanel = new JPanel();
        GridBagConstraints gbc_optionsPanel = new GridBagConstraints();
        gbc_optionsPanel.gridwidth = 3;
        gbc_optionsPanel.insets = new Insets(0, 0, 5, 5);
        gbc_optionsPanel.fill = 1;
        gbc_optionsPanel.gridx = 0;
        gbc_optionsPanel.gridy = 0;
        actionPanel.add((Component)this.optionsPanel, gbc_optionsPanel);
        this.optionsPanel.setLayout(new BorderLayout(0, 0));
        JLabel lblOpacity = new JLabel(" Opacity  ");
        GridBagConstraints gbc_lblOpacity = new GridBagConstraints();
        gbc_lblOpacity.anchor = 17;
        gbc_lblOpacity.insets = new Insets(0, 0, 0, 5);
        gbc_lblOpacity.gridx = 0;
        gbc_lblOpacity.gridy = 1;
        actionPanel.add((Component)lblOpacity, gbc_lblOpacity);
        this.opacitySlider = new JSlider();
        this.opacitySlider.setPreferredSize(new Dimension(120, 23));
        this.opacitySlider.setFocusable(false);
        this.opacitySlider.setMinimumSize(new Dimension(120, 23));
        this.opacitySlider.setToolTipText("Change opacity for selected layer(s)");
        GridBagConstraints gbc_opacitySlider = new GridBagConstraints();
        gbc_opacitySlider.fill = 2;
        gbc_opacitySlider.insets = new Insets(0, 0, 0, 5);
        gbc_opacitySlider.gridx = 1;
        gbc_opacitySlider.gridy = 1;
        actionPanel.add((Component)this.opacitySlider, gbc_opacitySlider);
        this.deleteButton = new IcyButton(CanvasActions.deleteLayersAction);
        this.deleteButton.setFlat(true);
        GridBagConstraints gbc_deleteButton = new GridBagConstraints();
        gbc_deleteButton.anchor = 13;
        gbc_deleteButton.gridx = 2;
        gbc_deleteButton.gridy = 1;
        actionPanel.add((Component)this.deleteButton, gbc_deleteButton);
        this.validate();
    }

    public void refresh() {
        ArrayList<Layer> selectedLayers = this.layerPanel.getSelectedLayers();
        final boolean hasSelected = selectedLayers.size() > 0;
        final boolean singleSelected = selectedLayers.size() == 1;
        final Layer firstSelected = hasSelected ? (Layer)selectedLayers.get(0) : null;
        boolean canRemove = false;
        for (Layer layer : selectedLayers) {
            canRemove |= layer.getCanBeRemoved();
        }
        final boolean canRemovef = canRemove;
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                JPanel panel;
                if (hasSelected) {
                    LayerControlPanel.this.opacitySlider.setValue((int)(firstSelected.getOpacity() * 100.0f));
                    LayerControlPanel.this.opacitySlider.setEnabled(true);
                    LayerControlPanel.this.deleteButton.setEnabled(canRemovef);
                } else {
                    LayerControlPanel.this.opacitySlider.setEnabled(false);
                    LayerControlPanel.this.deleteButton.setEnabled(false);
                }
                LayerControlPanel.this.optionsPanel.setVisible(false);
                LayerControlPanel.this.optionsPanel.removeAll();
                if (singleSelected && (panel = firstSelected.getOverlay().getOptionsPanel()) != null) {
                    LayerControlPanel.this.optionsPanel.add(panel);
                    LayerControlPanel.this.optionsPanel.setVisible(true);
                }
                if (LayerControlPanel.this.getParent() != null) {
                    LayerControlPanel.this.getParent().validate();
                } else {
                    LayerControlPanel.this.revalidate();
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        IcyCanvas canvas;
        Viewer viewer = Icy.getMainInterface().getActiveViewer();
        if (viewer != null && (canvas = viewer.getCanvas()) != null) {
            ArrayList<Layer> selectedLayers = this.layerPanel.getSelectedLayers();
            int value = this.opacitySlider.getValue();
            if (selectedLayers.size() > 0) {
                canvas.beginUpdate();
                try {
                    for (Layer layer : selectedLayers) {
                        layer.setOpacity((float)value / 100.0f);
                    }
                }
                finally {
                    canvas.endUpdate();
                }
            }
        }
    }
}

